/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.msgpack.MsgPackBeanPropertyMeta;
import org.apache.juneau.msgpack.MsgPackClassMeta;
import org.apache.juneau.msgpack.MsgPackCommon;
import org.apache.juneau.msgpack.MsgPackMetaProvider;
import org.apache.juneau.msgpack.MsgPackParserBuilder;
import org.apache.juneau.msgpack.MsgPackParserSession;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParserSessionArgs;

@ConfigurableContext
public class MsgPackParser
extends InputStreamParser
implements MsgPackMetaProvider,
MsgPackCommon {
    static final String PREFIX = "MsgPackParser";
    public static final MsgPackParser DEFAULT = new MsgPackParser(PropertyStore.DEFAULT);
    public static final MsgPackParser DEFAULT_SPACED_HEX = new SpacedHex(PropertyStore.DEFAULT);
    public static final MsgPackParser DEFAULT_BASE64 = new Base64(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, MsgPackClassMeta> msgPackClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, MsgPackBeanPropertyMeta> msgPackBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, MsgPackBeanPropertyMeta>();

    public MsgPackParser(PropertyStore ps) {
        super(ps, "octal/msgpack");
    }

    @Override
    public MsgPackParserBuilder builder() {
        return new MsgPackParserBuilder(this.getPropertyStore());
    }

    public static MsgPackParserBuilder create() {
        return new MsgPackParserBuilder();
    }

    @Override
    public MsgPackParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public MsgPackParserSession createSession(ParserSessionArgs args) {
        return new MsgPackParserSession(this, args);
    }

    @Override
    public MsgPackClassMeta getMsgPackClassMeta(ClassMeta<?> cm) {
        MsgPackClassMeta m = this.msgPackClassMetas.get(cm);
        if (m == null) {
            m = new MsgPackClassMeta(cm, this);
            this.msgPackClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public MsgPackBeanPropertyMeta getMsgPackBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return MsgPackBeanPropertyMeta.DEFAULT;
        }
        MsgPackBeanPropertyMeta m = this.msgPackBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new MsgPackBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.msgPackBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap());
    }

    public static class Base64
    extends MsgPackParser {
        public Base64(PropertyStore ps) {
            super(ps.builder().setDefault("InputStreamParser.binaryFormat.s", (Object)BinaryFormat.BASE64).build());
        }
    }

    public static class SpacedHex
    extends MsgPackParser {
        public SpacedHex(PropertyStore ps) {
            super(ps.builder().setDefault("InputStreamParser.binaryFormat.s", (Object)BinaryFormat.SPACED_HEX).build());
        }
    }
}

