/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanTraverseContext;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.http.MediaRange;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.header.Accept;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroupBuilder;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.WriterSerializer;

@ConfigurableContext(nocache=true)
public final class SerializerGroup
extends BeanTraverseContext {
    public static final SerializerGroup EMPTY = SerializerGroup.create().build();
    private final ConcurrentHashMap<String, SerializerMatch> cache = new ConcurrentHashMap();
    private final List<MediaRange> mediaRanges;
    private final List<Serializer> mediaTypeRangeSerializers;
    private final List<MediaType> mediaTypesList;
    private final List<Serializer> serializers;

    public static SerializerGroupBuilder create() {
        return new SerializerGroupBuilder();
    }

    @Override
    public SerializerGroupBuilder builder() {
        return new SerializerGroupBuilder(this);
    }

    public SerializerGroup(PropertyStore ps, Serializer[] serializers) {
        super(ps);
        this.serializers = AList.unmodifiable(serializers);
        AList lmtr = AList.of();
        ASet<MediaType> lmt = ASet.of(new MediaType[0]);
        AList l = AList.of();
        for (Serializer s : serializers) {
            for (MediaRange m : s.getMediaTypeRanges().getRanges()) {
                lmtr.add(m);
                l.add(s);
            }
            for (MediaType mt : s.getAcceptMediaTypes()) {
                lmt.add(mt);
            }
        }
        this.mediaRanges = lmtr.unmodifiable();
        this.mediaTypesList = AList.of(lmt).unmodifiable();
        this.mediaTypeRangeSerializers = l.unmodifiable();
    }

    public SerializerMatch getSerializerMatch(String acceptHeader) {
        if (acceptHeader == null) {
            return null;
        }
        SerializerMatch sm = this.cache.get(acceptHeader);
        if (sm != null) {
            return sm;
        }
        Accept a = Accept.of(acceptHeader);
        int match = a.match(this.mediaRanges);
        if (match >= 0) {
            sm = new SerializerMatch(this.mediaRanges.get(match), this.mediaTypeRangeSerializers.get(match));
            this.cache.putIfAbsent(acceptHeader, sm);
        }
        return this.cache.get(acceptHeader);
    }

    public SerializerMatch getSerializerMatch(MediaType mediaType) {
        return this.getSerializerMatch(mediaType.toString());
    }

    public Serializer getSerializer(String acceptHeader) {
        SerializerMatch sm = this.getSerializerMatch(acceptHeader);
        return sm == null ? null : sm.getSerializer();
    }

    public Serializer getSerializer(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        return this.getSerializer(mediaType.toString());
    }

    public WriterSerializer getWriterSerializer(String acceptHeader) {
        return (WriterSerializer)this.getSerializer(acceptHeader);
    }

    public WriterSerializer getWriterSerializer(MediaType mediaType) {
        return (WriterSerializer)this.getSerializer(mediaType);
    }

    public OutputStreamSerializer getStreamSerializer(String acceptHeader) {
        return (OutputStreamSerializer)this.getSerializer(acceptHeader);
    }

    public OutputStreamSerializer getStreamSerializer(MediaType mediaType) {
        return (OutputStreamSerializer)this.getSerializer(mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypesList;
    }

    public List<Serializer> getSerializers() {
        return this.serializers;
    }

    public boolean isEmpty() {
        return this.serializers.isEmpty();
    }
}

