/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.utils.ClasspathResourceFinder;

@Deprecated
public class ClasspathResourceFinderSimple
implements ClasspathResourceFinder {
    public static final ClasspathResourceFinderSimple INSTANCE = new ClasspathResourceFinderSimple();
    private static final ResourceBundle.Control RB_CONTROL = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private static final List<Locale> ROOT_LOCALE = Arrays.asList(Locale.ROOT);

    @Override
    public InputStream findResource(Class<?> baseClass, String name, Locale locale) throws IOException {
        return this.findClasspathResource(baseClass, name, locale);
    }

    protected InputStream findClasspathResource(Class<?> baseClass, String name, Locale locale) throws IOException {
        if (locale == null) {
            return this.getResourceAsStream(baseClass, name);
        }
        for (String n : ClasspathResourceFinderSimple.getCandidateFileNames(name, locale)) {
            InputStream is = this.getResourceAsStream(baseClass, n);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    private InputStream getResourceAsStream(Class<?> baseClass, String name) {
        return baseClass.getResourceAsStream(name);
    }

    protected static Iterable<String> getCandidateFileNames(final String fileName, final Locale l) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    final Iterator<Locale> locales;
                    String baseName;
                    String ext;
                    {
                        this.locales = ClasspathResourceFinderSimple.getCandidateLocales(l).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.locales.hasNext();
                    }

                    @Override
                    public String next() {
                        Locale l2 = this.locales.next();
                        if (l2.toString().isEmpty()) {
                            return fileName;
                        }
                        if (this.baseName == null) {
                            this.baseName = FileUtils.getBaseName(fileName);
                        }
                        if (this.ext == null) {
                            this.ext = FileUtils.getExtension(fileName);
                        }
                        return this.baseName + "_" + l2.toString() + (this.ext.isEmpty() ? "" : '.' + this.ext);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static final List<Locale> getCandidateLocales(Locale locale) {
        if (locale == null) {
            return ROOT_LOCALE;
        }
        return RB_CONTROL.getCandidateLocales("", locale);
    }
}

