/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.servlet.http.Part;
import org.apache.http.NameValuePair;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.part.BasicStringPart;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestContent;
import org.apache.juneau.rest.httppart.RequestFormParam;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.svl.VarResolverSession;

public class RequestFormParams {
    private final RestRequest req;
    private final boolean caseSensitive;
    private HttpPartParserSession parser;
    private final VarResolverSession vs;
    private List<RequestFormParam> list = new LinkedList<RequestFormParam>();
    private Map<String, List<RequestFormParam>> map = new TreeMap<String, List<RequestFormParam>>();

    public RequestFormParams(RestRequest req, boolean caseSensitive) throws Exception {
        this.req = req;
        this.caseSensitive = caseSensitive;
        this.vs = req.getVarResolverSession();
        Map m = null;
        Collection c = null;
        RequestContent content = req.getContent();
        if (content.isLoaded() || !req.getHeader(ContentType.class).orElse(ContentType.NULL).equalsIgnoreCase("multipart/form-data")) {
            m = RestUtils.parseQuery(content.getReader());
        } else {
            c = req.getHttpServletRequest().getParts();
            if (c == null || c.isEmpty()) {
                m = req.getHttpServletRequest().getParameterMap();
            }
        }
        if (m != null) {
            for (Map.Entry<String, String[]> e : m.entrySet()) {
                String name = e.getKey();
                String key = this.key(name);
                ArrayList<RequestFormParam> l = CollectionUtils.list(new RequestFormParam[0]);
                String[] values = e.getValue();
                if (values == null) {
                    values = new String[]{};
                }
                if (values.length == 1 && values[0] == null) {
                    values[0] = "";
                }
                for (String value : values) {
                    RequestFormParam p = new RequestFormParam(req, name, value);
                    this.list.add(p);
                    l.add(p);
                }
                this.map.put(key, l);
            }
        } else if (c != null) {
            c.stream().forEach(x -> this.add((Part)x));
        }
    }

    private RequestFormParams(RequestFormParams copyFrom) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.list.addAll(copyFrom.list);
        this.map.putAll(copyFrom.map);
        this.vs = copyFrom.vs;
    }

    public RequestFormParams parser(HttpPartParserSession value) {
        this.parser = value;
        for (RequestFormParam p : this.list) {
            p.parser(this.parser);
        }
        return this;
    }

    public RequestFormParams addDefault(List<? extends NameValuePair> pairs) {
        for (NameValuePair nameValuePair : pairs) {
            boolean hasAllBlanks;
            String name = nameValuePair.getName();
            String key = this.key(name);
            List<RequestFormParam> l = this.map.get(key);
            boolean bl = hasAllBlanks = l != null && l.stream().allMatch(x -> StringUtils.isEmpty(x.getValue()));
            if (l != null && !hasAllBlanks) continue;
            if (hasAllBlanks) {
                this.list.removeAll(l);
            }
            RequestFormParam x2 = new RequestFormParam(this.req, name, this.vs.resolve(nameValuePair.getValue()));
            this.list.add(x2);
            this.map.put(key, CollectionUtils.list(x2));
        }
        return this;
    }

    public RequestFormParams addDefault(NameValuePair ... pairs) {
        return this.addDefault(Arrays.asList(pairs));
    }

    public RequestFormParams addDefault(String name, String value) {
        return this.addDefault(BasicStringPart.of(name, value));
    }

    public List<RequestFormParam> getAll(String name) {
        Assertions.assertArgNotNull("name", name);
        List<RequestFormParam> l = this.map.get(this.key(name));
        return l == null ? CollectionUtils.emptyList() : CollectionUtils.unmodifiable(l);
    }

    public List<RequestFormParam> getAll() {
        return CollectionUtils.unmodifiable(this.list);
    }

    public boolean contains(String ... names) {
        Assertions.assertArgNotNull("names", names);
        for (String n : names) {
            if (this.map.containsKey(this.key(n))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(String ... names) {
        Assertions.assertArgNotNull("names", names);
        for (String n : names) {
            if (!this.map.containsKey(this.key(n))) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public RequestFormParams add(String name, Object value) {
        Assertions.assertArgNotNull("name", name);
        String key = this.key(name);
        RequestFormParam h = new RequestFormParam(this.req, name, StringUtils.stringify(value)).parser(this.parser);
        if (this.map.containsKey(key)) {
            this.map.get(key).add(h);
        } else {
            this.map.put(key, CollectionUtils.list(h));
        }
        this.list.add(h);
        return this;
    }

    public RequestFormParams add(Part part) {
        Assertions.assertArgNotNull("part", part);
        String key = this.key(part.getName());
        RequestFormParam h = new RequestFormParam(this.req, part).parser(this.parser);
        if (this.map.containsKey(key)) {
            this.map.get(key).add(h);
        } else {
            this.map.put(key, CollectionUtils.list(h));
        }
        this.list.add(h);
        return this;
    }

    public RequestFormParams add(NameValuePair ... parameters) {
        Assertions.assertArgNotNull("parameters", parameters);
        for (NameValuePair p : parameters) {
            if (p == null) continue;
            this.add(p.getName(), p.getValue());
        }
        return this;
    }

    public RequestFormParams set(String name, Object value) {
        Assertions.assertArgNotNull("name", name);
        String key = this.key(name);
        RequestFormParam p = new RequestFormParam(this.req, name, StringUtils.stringify(value)).parser(this.parser);
        if (this.map.containsKey(key)) {
            this.list.removeIf(x -> this.caseSensitive ? x.getName().equals(name) : x.getName().equalsIgnoreCase(name));
        }
        this.list.add(p);
        this.map.put(key, CollectionUtils.list(p));
        return this;
    }

    public RequestFormParams set(NameValuePair ... parameters) {
        Assertions.assertArgNotNull("headers", parameters);
        for (NameValuePair p : parameters) {
            this.remove(p);
        }
        for (NameValuePair p : parameters) {
            this.add(p);
        }
        return this;
    }

    public RequestFormParams remove(String ... name) {
        Assertions.assertArgNotNull("name", name);
        for (String n : name) {
            String key = this.key(n);
            if (this.map.containsKey(key)) {
                this.list.removeAll((Collection)this.map.get(key));
            }
            this.map.remove(key);
        }
        return this;
    }

    public RequestFormParams remove(NameValuePair ... parameters) {
        for (NameValuePair p : parameters) {
            this.remove(p.getName());
        }
        return this;
    }

    public RequestFormParam getFirst(String name) {
        Assertions.assertArgNotNull("name", name);
        List<RequestFormParam> l = this.map.get(this.key(name));
        return l == null || l.isEmpty() ? new RequestFormParam(this.req, name, null).parser(this.parser) : l.get(0);
    }

    public RequestFormParam getLast(String name) {
        Assertions.assertArgNotNull("name", name);
        List<RequestFormParam> l = this.map.get(this.key(name));
        return l == null || l.isEmpty() ? new RequestFormParam(this.req, name, null).parser(this.parser) : l.get(l.size() - 1);
    }

    public RequestFormParam get(String name) {
        return this.getLast(name);
    }

    public <T> Optional<T> get(Class<T> type) {
        ClassMeta<T> cm = this.req.getBeanSession().getClassMeta(type);
        String name = HttpParts.getName(HttpPartType.FORMDATA, cm).orElseThrow(() -> ThrowableUtils.runtimeException("@FormData(name) not found on class {0}", ClassUtils.className(type)));
        return this.get(name).as(type);
    }

    public String asQueryString() {
        StringBuilder sb = new StringBuilder();
        for (RequestFormParam e : this.list) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(StringUtils.urlEncode(e.getName())).append('=').append(StringUtils.urlEncode(e.getValue()));
        }
        return sb.toString();
    }

    public RequestFormParams copy() {
        return new RequestFormParams(this);
    }

    public String toString(boolean sorted) {
        JsonMap m = JsonMap.create();
        if (sorted) {
            for (List<RequestFormParam> p1 : this.map.values()) {
                for (RequestFormParam p2 : p1) {
                    m.append(p2.getName(), p2.getValue());
                }
            }
        } else {
            for (RequestFormParam p : this.list) {
                m.append(p.getName(), p.getValue());
            }
        }
        return m.toString();
    }

    private String key(String name) {
        return this.caseSensitive ? name : name.toLowerCase();
    }

    public String toString() {
        return this.toString(false);
    }
}

