/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.servlet;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.Value;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestHook;

public abstract class RestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private AtomicReference<RestContext> context = new AtomicReference();
    private AtomicReference<Exception> initException = new AtomicReference();

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        try {
            if (this.context.get() != null) {
                return;
            }
            super.init(servletConfig);
            this.context.set(RestContext.create(((Object)((Object)this)).getClass(), null, servletConfig).init(() -> this).build());
            this.context.get().postInit();
            this.context.get().postInitChildFirst();
        }
        catch (ServletException e) {
            this.initException.set((Exception)((Object)e));
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ClassUtils.className((Object)this));
            throw e;
        }
        catch (Throwable e) {
            this.initException.set(HttpRuntimeException.toHttpException(e, InternalServerError.class));
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ClassUtils.className((Object)this));
        }
    }

    public BeanStore createBeanStore(Optional<BeanStore> parent) {
        return BeanStore.of(parent.orElse(null), (Object)this);
    }

    protected void setContext(RestContext context) throws ServletException {
        if (this.context.get() == null) {
            super.init(context.getBuilder());
            this.context.set(context);
        }
    }

    public synchronized String getPath() {
        RestContext context = this.context.get();
        if (context != null) {
            return context.getFullPath();
        }
        ClassInfo ci = ClassInfo.of(((Object)((Object)this)).getClass());
        Value<String> path = Value.empty();
        ci.forEachAnnotation(Rest.class, x -> StringUtils.isNotEmpty(x.path()), x -> path.set(StringUtils.trimSlashes(x.path())));
        return path.orElse("");
    }

    public void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, InternalServerError, IOException {
        try {
            if (this.initException.get() != null) {
                throw this.initException.get();
            }
            if (this.context.get() == null) {
                throw new InternalServerError("Servlet {0} not initialized.  init(ServletConfig) was not called.  This can occur if you've overridden this method but didn't call super.init(RestConfig).", ClassUtils.className((Object)this));
            }
            this.getContext().execute((Object)this, r1, r2);
        }
        catch (Throwable e) {
            r2.sendError(500, e.getLocalizedMessage());
        }
    }

    public synchronized void destroy() {
        if (this.context.get() != null) {
            this.context.get().destroy();
        }
        super.destroy();
    }

    public synchronized RestContext getContext() {
        RestContext rc = this.context.get();
        if (rc == null) {
            throw new InternalServerError("RestContext object not set on resource.", new Object[0]);
        }
        return rc;
    }

    public void log(String msg) {
        this.doLog(Level.INFO, null, () -> msg);
    }

    public void log(String msg, Throwable cause) {
        this.doLog(Level.INFO, null, () -> msg);
    }

    public void log(Level level, String msg, Object ... args) {
        this.doLog(level, null, () -> StringUtils.format(msg, args));
    }

    public void log(Level level, Throwable cause, String msg, Object ... args) {
        this.doLog(level, cause, () -> StringUtils.format(msg, args));
    }

    protected void doLog(Level level, Throwable cause, Supplier<String> msg) {
        Logger logger;
        RestContext c = this.context.get();
        Logger logger2 = logger = c == null ? null : c.getLogger();
        if (logger == null) {
            logger = Logger.getLogger(ClassUtils.className((Object)this));
        }
        logger.log(level, cause, msg);
    }

    @RestHook(value=HookEvent.INIT)
    public void onInit(RestContext.Builder builder) throws Exception {
    }

    @RestHook(value=HookEvent.POST_INIT)
    public void onPostInit(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.POST_INIT_CHILD_FIRST)
    public void onPostInitChildFirst(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.DESTROY)
    public void onDestroy(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.START_CALL)
    public void onStartCall(HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.PRE_CALL)
    public void onPreCall(RestRequest req, RestResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.POST_CALL)
    public void onPostCall(RestRequest req, RestResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.END_CALL)
    public void onEndCall(HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    public synchronized RestRequest getRequest() {
        return this.getContext().getLocalSession().getOpSession().getRequest();
    }

    public synchronized RestResponse getResponse() {
        return this.getContext().getLocalSession().getOpSession().getResponse();
    }
}

