/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.entity.HttpEntityBuilder;
import org.apache.juneau.internal.IOUtils;

public class InputStreamEntity
extends BasicHttpEntity {
    private final InputStream content = this.contentOrElse(IOUtils.EMPTY_INPUT_STREAM);
    private final long maxLength;
    private final byte[] cache;

    public static HttpEntityBuilder<InputStreamEntity> create() {
        return new HttpEntityBuilder<Class<InputStreamEntity>>(InputStreamEntity.class);
    }

    public InputStreamEntity(HttpEntityBuilder<?> builder) throws IOException {
        super(builder);
        this.cache = builder.cached ? IOUtils.readBytes(this.content) : null;
        this.maxLength = builder.contentLength == -1L && this.cache != null ? (long)this.cache.length : builder.contentLength;
    }

    public HttpEntityBuilder<InputStreamEntity> copy() {
        return new HttpEntityBuilder<InputStreamEntity>(this);
    }

    @Override
    public String asString() throws IOException {
        return new String(this.asBytes(), IOUtils.UTF8);
    }

    @Override
    public byte[] asBytes() throws IOException {
        return this.cache == null ? IOUtils.readBytes(this.content) : this.cache;
    }

    @Override
    public boolean isRepeatable() {
        return this.cache != null;
    }

    @Override
    public long getContentLength() {
        return this.maxLength;
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.cache == null ? this.content : new ByteArrayInputStream(this.cache);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Assertions.assertArgNotNull("out", out);
        if (this.cache != null) {
            IOUtils.pipe(this.cache, out, (int)this.maxLength);
        } else {
            try (InputStream is = this.getContent();){
                IOUtils.pipe(is, out, this.maxLength);
            }
        }
    }

    @Override
    public boolean isStreaming() {
        return this.cache == null;
    }
}

