/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.juneau.http.entity.HttpEntityBuilder;
import org.apache.juneau.http.entity.SerializedEntity;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.serializer.Serializer;

@FluentSetters(returns="SerializedEntityBuilder<T>")
public class SerializedEntityBuilder<T extends SerializedEntity>
extends HttpEntityBuilder<T> {
    Serializer serializer;
    HttpPartSchema schema;

    public SerializedEntityBuilder(Class<T> implClass) {
        super(implClass);
    }

    public SerializedEntityBuilder(T impl) {
        super(impl);
        this.serializer = ((SerializedEntity)impl).serializer;
        this.schema = ((SerializedEntity)impl).schema;
    }

    @Override
    public T build() {
        try {
            return (T)((SerializedEntity)this.implClass.getConstructor(SerializedEntityBuilder.class).newInstance(this));
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    @FluentSetter
    public SerializedEntityBuilder<T> serializer(Serializer value) {
        this.serializer = value;
        return this;
    }

    @FluentSetter
    public SerializedEntityBuilder<T> schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    @Override
    public SerializedEntityBuilder<T> cached() throws IOException {
        super.cached();
        return this;
    }

    @Override
    public SerializedEntityBuilder<T> chunked() {
        super.chunked();
        return this;
    }

    @Override
    public SerializedEntityBuilder<T> chunked(boolean value) {
        super.chunked(value);
        return this;
    }

    @Override
    public SerializedEntityBuilder<T> content(Object value) {
        super.content(value);
        return this;
    }

    @Override
    public SerializedEntityBuilder<T> content(Supplier<?> value) {
        super.content(value);
        return this;
    }

    @Override
    public SerializedEntityBuilder<T> contentEncoding(String value) {
        super.contentEncoding(value);
        return this;
    }

    @Override
    public SerializedEntityBuilder<T> contentEncoding(ContentEncoding value) {
        super.contentEncoding(value);
        return this;
    }

    @Override
    public SerializedEntityBuilder<T> contentLength(long value) {
        super.contentLength(value);
        return this;
    }

    @Override
    public SerializedEntityBuilder<T> contentType(String value) {
        super.contentType(value);
        return this;
    }

    @Override
    public SerializedEntityBuilder<T> contentType(ContentType value) {
        super.contentType(value);
        return this;
    }
}

