/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

public class WeightedAverage {
    private Double value = 0.0;
    private int weight = 0;

    public WeightedAverage add(int w, Number v) {
        if (v != null) {
            try {
                double w1 = this.weight;
                double w2 = w;
                this.weight = Math.addExact(this.weight, w);
                if (this.weight != 0) {
                    this.value = this.value * (w1 / (double)this.weight) + (double)v.floatValue() * (w2 / (double)this.weight);
                }
            }
            catch (ArithmeticException ae) {
                throw new ArithmeticException("Weight overflow.");
            }
        }
        return this;
    }

    public double getValue() {
        return this.value;
    }
}

