/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import org.apache.http.HttpResponse;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.response.BasicHttpResponse;
import org.apache.juneau.http.response.HttpResponseBuilder;

@Response
@StatusCode(value={308})
@Schema(description={"Permanent Redirect"})
public class PermanentRedirect
extends BasicHttpResponse {
    public static final int STATUS_CODE = 308;
    public static final String REASON_PHRASE = "Permanent Redirect";
    private static final BasicStatusLine STATUS_LINE = BasicStatusLine.create().statusCode(308).reasonPhrase("Permanent Redirect").build();
    public static final PermanentRedirect INSTANCE = PermanentRedirect.create().unmodifiable().build();

    public static HttpResponseBuilder<PermanentRedirect> create() {
        return new HttpResponseBuilder<Class<PermanentRedirect>>(PermanentRedirect.class).statusLine(STATUS_LINE);
    }

    public PermanentRedirect(HttpResponseBuilder<?> builder) {
        super(builder);
    }

    public PermanentRedirect(HttpResponse response) {
        this(PermanentRedirect.create().copyFrom(response));
        this.assertStatusCode(response);
    }

    public HttpResponseBuilder<PermanentRedirect> copy() {
        return new HttpResponseBuilder<PermanentRedirect>(this);
    }
}

