/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.annotation.ExternalDocs;
import org.apache.juneau.annotation.ExternalDocsAnnotation;
import org.apache.juneau.annotation.Items;
import org.apache.juneau.annotation.ItemsAnnotation;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SubItemsAnnotation;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMFBuilder;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.jsonschema.SchemaUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class SchemaAnnotation {
    public static final Schema DEFAULT = SchemaAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return SchemaAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return SchemaAnnotation.create().on(on);
    }

    public static boolean empty(Schema a) {
        return a == null || DEFAULT.equals(a);
    }

    public static JsonMap asMap(Schema a) throws ParseException {
        if (a == null) {
            return JsonMap.EMPTY_MAP;
        }
        JsonMap m = new JsonMap();
        if (SchemaAnnotation.empty(a)) {
            return m;
        }
        Predicate<String> ne = StringUtils::isNotEmpty;
        Predicate<Collection> nec = CollectionUtils::isNotEmpty;
        Predicate<Map> nem = CollectionUtils::isNotEmpty;
        Predicate<Boolean> nf = ObjectUtils::isTrue;
        Predicate<Long> nm1 = ObjectUtils::isNotMinusOne;
        return m.appendIf(nem, "additionalProperties", SchemaUtils.parseMap(a.additionalProperties())).appendIf(ne, "allOf", SchemaUtils.joinnl(new String[][]{a.allOf()})).appendFirst(ne, "collectionFormat", a.collectionFormat(), a.cf()).appendIf(ne, "default", SchemaUtils.joinnl(a._default(), a.df())).appendIf(ne, "discriminator", a.discriminator()).appendIf(ne, "description", SchemaUtils.joinnl(a.description(), a.d())).appendFirst(nec, "enum", SchemaUtils.parseSet(a._enum()), SchemaUtils.parseSet(a.e())).appendIf(nf, "exclusiveMaximum", a.exclusiveMaximum() || a.emax()).appendIf(nf, "exclusiveMinimum", a.exclusiveMinimum() || a.emin()).appendIf(nem, "externalDocs", ExternalDocsAnnotation.merge(m.getMap("externalDocs"), a.externalDocs())).appendFirst(ne, "format", a.format(), a.f()).appendIf(ne, "ignore", a.ignore() ? "true" : null).appendIf(nem, "items", SchemaAnnotation.merge(m.getMap("items"), a.items())).appendFirst(ne, "maximum", a.maximum(), a.max()).appendFirst(nm1, "maxItems", a.maxItems(), a.maxi()).appendFirst(nm1, "maxLength", a.maxLength(), a.maxl()).appendFirst(nm1, "maxProperties", a.maxProperties(), a.maxp()).appendFirst(ne, "minimum", a.minimum(), a.min()).appendFirst(nm1, "minItems", a.minItems(), a.mini()).appendFirst(nm1, "minLength", a.minLength(), a.minl()).appendFirst(nm1, "minProperties", a.minProperties(), a.minp()).appendFirst(ne, "multipleOf", a.multipleOf(), a.mo()).appendFirst(ne, "pattern", a.pattern(), a.p()).appendIf(nem, "properties", SchemaUtils.parseMap(a.properties())).appendIf(nf, "readOnly", a.readOnly() || a.ro()).appendIf(nf, "required", a.required() || a.r()).appendIf(ne, "title", a.title()).appendFirst(ne, "type", a.type(), a.t()).appendIf(nf, "uniqueItems", a.uniqueItems() || a.ui()).appendIf(ne, "xml", SchemaUtils.joinnl(new String[][]{a.xml()})).appendIf(ne, "$ref", a.$ref());
    }

    private static JsonMap merge(JsonMap m, Items a) throws ParseException {
        if (ItemsAnnotation.empty(a)) {
            return m;
        }
        Predicate<String> ne = StringUtils::isNotEmpty;
        Predicate<Collection> nec = CollectionUtils::isNotEmpty;
        Predicate<Map> nem = CollectionUtils::isNotEmpty;
        Predicate<Boolean> nf = ObjectUtils::isTrue;
        Predicate<Long> nm1 = ObjectUtils::isNotMinusOne;
        return m.appendFirst(ne, "collectionFormat", a.collectionFormat(), a.cf()).appendIf(ne, "default", SchemaUtils.joinnl(a._default(), a.df())).appendFirst(nec, "enum", SchemaUtils.parseSet(a._enum()), SchemaUtils.parseSet(a.e())).appendFirst(ne, "format", a.format(), a.f()).appendIf(nf, "exclusiveMaximum", a.exclusiveMaximum() || a.emax()).appendIf(nf, "exclusiveMinimum", a.exclusiveMinimum() || a.emin()).appendIf(nem, "items", SubItemsAnnotation.merge(m.getMap("items"), a.items())).appendFirst(ne, "maximum", a.maximum(), a.max()).appendFirst(nm1, "maxItems", a.maxItems(), a.maxi()).appendFirst(nm1, "maxLength", a.maxLength(), a.maxl()).appendFirst(ne, "minimum", a.minimum(), a.min()).appendFirst(nm1, "minItems", a.minItems(), a.mini()).appendFirst(nm1, "minLength", a.minLength(), a.minl()).appendFirst(ne, "multipleOf", a.multipleOf(), a.mo()).appendFirst(ne, "pattern", a.pattern(), a.p()).appendIf(nf, "uniqueItems", a.uniqueItems() || a.ui()).appendFirst(ne, "type", a.type(), a.t()).appendIf(ne, "$ref", a.$ref());
    }

    public static class Builder
    extends TargetedAnnotationTMFBuilder {
        boolean aev;
        boolean allowEmptyValue;
        boolean emax;
        boolean emin;
        boolean exclusiveMaximum;
        boolean exclusiveMinimum;
        boolean ignore;
        boolean r;
        boolean readOnly;
        boolean required;
        boolean ro;
        boolean sie;
        boolean skipIfEmpty;
        boolean ui;
        boolean uniqueItems;
        ExternalDocs externalDocs = ExternalDocsAnnotation.DEFAULT;
        Items items = ItemsAnnotation.DEFAULT;
        long maxi = -1L;
        long maxItems = -1L;
        long maxl = -1L;
        long maxLength = -1L;
        long maxp = -1L;
        long maxProperties = -1L;
        long mini = -1L;
        long minItems = -1L;
        long minl = -1L;
        long minLength = -1L;
        long minp = -1L;
        long minProperties = -1L;
        String $ref = "";
        String cf = "";
        String collectionFormat = "";
        String discriminator = "";
        String f = "";
        String format = "";
        String max = "";
        String maximum = "";
        String min = "";
        String minimum = "";
        String mo = "";
        String multipleOf = "";
        String p = "";
        String pattern = "";
        String t = "";
        String title = "";
        String type = "";
        String[] _default = new String[0];
        String[] _enum = new String[0];
        String[] additionalProperties = new String[0];
        String[] allOf = new String[0];
        String[] d = new String[0];
        String[] description = new String[0];
        String[] df = new String[0];
        String[] e = new String[0];
        String[] properties = new String[0];
        String[] value = new String[0];
        String[] xml = new String[0];

        protected Builder() {
            super(Schema.class);
        }

        public Schema build() {
            return new Impl(this);
        }

        public Builder _default(String ... value) {
            this._default = value;
            return this;
        }

        public Builder _enum(String ... value) {
            this._enum = value;
            return this;
        }

        public Builder $ref(String value) {
            this.$ref = value;
            return this;
        }

        public Builder additionalProperties(String ... value) {
            this.additionalProperties = value;
            return this;
        }

        public Builder allOf(String ... value) {
            this.allOf = value;
            return this;
        }

        public Builder aev(boolean value) {
            this.aev = value;
            return this;
        }

        public Builder allowEmptyValue(boolean value) {
            this.allowEmptyValue = value;
            return this;
        }

        public Builder cf(String value) {
            this.cf = value;
            return this;
        }

        public Builder collectionFormat(String value) {
            this.collectionFormat = value;
            return this;
        }

        public Builder d(String ... value) {
            this.d = value;
            return this;
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder df(String ... value) {
            this.df = value;
            return this;
        }

        public Builder discriminator(String value) {
            this.discriminator = value;
            return this;
        }

        public Builder e(String ... value) {
            this.e = value;
            return this;
        }

        public Builder emax(boolean value) {
            this.emax = value;
            return this;
        }

        public Builder emin(boolean value) {
            this.emin = value;
            return this;
        }

        public Builder exclusiveMaximum(boolean value) {
            this.exclusiveMaximum = value;
            return this;
        }

        public Builder exclusiveMinimum(boolean value) {
            this.exclusiveMinimum = value;
            return this;
        }

        public Builder externalDocs(ExternalDocs value) {
            this.externalDocs = value;
            return this;
        }

        public Builder f(String value) {
            this.f = value;
            return this;
        }

        public Builder format(String value) {
            this.format = value;
            return this;
        }

        public Builder ignore(boolean value) {
            this.ignore = value;
            return this;
        }

        public Builder items(Items value) {
            this.items = value;
            return this;
        }

        public Builder max(String value) {
            this.max = value;
            return this;
        }

        public Builder maxi(long value) {
            this.maxi = value;
            return this;
        }

        public Builder maximum(String value) {
            this.maximum = value;
            return this;
        }

        public Builder maxItems(long value) {
            this.maxItems = value;
            return this;
        }

        public Builder maxl(long value) {
            this.maxl = value;
            return this;
        }

        public Builder maxLength(long value) {
            this.maxLength = value;
            return this;
        }

        public Builder maxp(long value) {
            this.maxp = value;
            return this;
        }

        public Builder maxProperties(long value) {
            this.maxProperties = value;
            return this;
        }

        public Builder min(String value) {
            this.min = value;
            return this;
        }

        public Builder mini(long value) {
            this.mini = value;
            return this;
        }

        public Builder minimum(String value) {
            this.minimum = value;
            return this;
        }

        public Builder minItems(long value) {
            this.minItems = value;
            return this;
        }

        public Builder minl(long value) {
            this.minl = value;
            return this;
        }

        public Builder minLength(long value) {
            this.minLength = value;
            return this;
        }

        public Builder minp(long value) {
            this.minp = value;
            return this;
        }

        public Builder minProperties(long value) {
            this.minProperties = value;
            return this;
        }

        public Builder mo(String value) {
            this.mo = value;
            return this;
        }

        public Builder multipleOf(String value) {
            this.multipleOf = value;
            return this;
        }

        public Builder p(String value) {
            this.p = value;
            return this;
        }

        public Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public Builder properties(String ... value) {
            this.properties = value;
            return this;
        }

        public Builder r(boolean value) {
            this.r = value;
            return this;
        }

        public Builder readOnly(boolean value) {
            this.readOnly = value;
            return this;
        }

        public Builder required(boolean value) {
            this.required = value;
            return this;
        }

        public Builder ro(boolean value) {
            this.ro = value;
            return this;
        }

        public Builder sie(boolean value) {
            this.sie = value;
            return this;
        }

        public Builder skipIfEmpty(boolean value) {
            this.skipIfEmpty = value;
            return this;
        }

        public Builder t(String value) {
            this.t = value;
            return this;
        }

        public Builder title(String value) {
            this.title = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder ui(boolean value) {
            this.ui = value;
            return this;
        }

        public Builder uniqueItems(boolean value) {
            this.uniqueItems = value;
            return this;
        }

        public Builder xml(String ... value) {
            this.xml = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Schema[] value();
    }

    public static class Apply
    extends AnnotationApplier<Schema, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(Schema.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Schema> ai, Context.Builder b) {
            Schema a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(a);
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Schema {
        private final boolean aev;
        private final boolean allowEmptyValue;
        private final boolean exclusiveMaximum;
        private final boolean emax;
        private final boolean exclusiveMinimum;
        private final boolean emin;
        private final boolean uniqueItems;
        private final boolean ui;
        private final boolean required;
        private final boolean r;
        private final boolean readOnly;
        private final boolean ro;
        private final boolean sie;
        private final boolean skipIfEmpty;
        private final boolean ignore;
        private final ExternalDocs externalDocs;
        private final Items items;
        private final long maxLength;
        private final long maxl;
        private final long minLength;
        private final long minl;
        private final long maxItems;
        private final long maxi;
        private final long minItems;
        private final long mini;
        private final long maxProperties;
        private final long maxp;
        private final long minProperties;
        private final long minp;
        private final String $ref;
        private final String format;
        private final String f;
        private final String title;
        private final String multipleOf;
        private final String mo;
        private final String maximum;
        private final String max;
        private final String minimum;
        private final String min;
        private final String pattern;
        private final String p;
        private final String type;
        private final String t;
        private final String collectionFormat;
        private final String cf;
        private final String discriminator;
        private final String[] description;
        private final String[] d;
        private final String[] _default;
        private final String[] df;
        private final String[] _enum;
        private final String[] e;
        private final String[] allOf;
        private final String[] properties;
        private final String[] additionalProperties;
        private final String[] xml;

        Impl(Builder b) {
            super(b);
            this.$ref = b.$ref;
            this._default = ArrayUtils.copyOf(b._default);
            this._enum = ArrayUtils.copyOf(b._enum);
            this.additionalProperties = ArrayUtils.copyOf(b.additionalProperties);
            this.allOf = ArrayUtils.copyOf(b.allOf);
            this.aev = b.aev;
            this.allowEmptyValue = b.allowEmptyValue;
            this.cf = b.cf;
            this.collectionFormat = b.collectionFormat;
            this.d = ArrayUtils.copyOf(b.d);
            this.description = ArrayUtils.copyOf(b.description);
            this.df = ArrayUtils.copyOf(b.df);
            this.discriminator = b.discriminator;
            this.e = ArrayUtils.copyOf(b.e);
            this.emax = b.emax;
            this.emin = b.emin;
            this.exclusiveMaximum = b.exclusiveMaximum;
            this.exclusiveMinimum = b.exclusiveMinimum;
            this.externalDocs = b.externalDocs;
            this.f = b.f;
            this.format = b.format;
            this.ignore = b.ignore;
            this.items = b.items;
            this.max = b.max;
            this.maxi = b.maxi;
            this.maximum = b.maximum;
            this.maxItems = b.maxItems;
            this.maxl = b.maxl;
            this.maxLength = b.maxLength;
            this.maxp = b.maxp;
            this.maxProperties = b.maxProperties;
            this.min = b.min;
            this.mini = b.mini;
            this.minimum = b.minimum;
            this.minItems = b.minItems;
            this.minl = b.minl;
            this.minLength = b.minLength;
            this.minp = b.minp;
            this.minProperties = b.minProperties;
            this.mo = b.mo;
            this.multipleOf = b.multipleOf;
            this.p = b.p;
            this.pattern = b.pattern;
            this.properties = ArrayUtils.copyOf(b.properties);
            this.r = b.r;
            this.readOnly = b.readOnly;
            this.required = b.required;
            this.ro = b.ro;
            this.sie = b.sie;
            this.skipIfEmpty = b.skipIfEmpty;
            this.t = b.t;
            this.title = b.title;
            this.type = b.type;
            this.ui = b.ui;
            this.uniqueItems = b.uniqueItems;
            this.xml = ArrayUtils.copyOf(b.xml);
            this.postConstruct();
        }

        @Override
        public String[] _default() {
            return this._default;
        }

        @Override
        public String[] _enum() {
            return this._enum;
        }

        @Override
        public String $ref() {
            return this.$ref;
        }

        @Override
        public String[] additionalProperties() {
            return this.additionalProperties;
        }

        @Override
        public String[] allOf() {
            return this.allOf;
        }

        @Override
        public boolean aev() {
            return this.aev;
        }

        @Override
        public boolean allowEmptyValue() {
            return this.allowEmptyValue;
        }

        @Override
        public String cf() {
            return this.cf;
        }

        @Override
        public String collectionFormat() {
            return this.collectionFormat;
        }

        @Override
        public String[] d() {
            return this.d;
        }

        @Override
        public String[] description() {
            return this.description;
        }

        @Override
        public String[] df() {
            return this.df;
        }

        @Override
        public String discriminator() {
            return this.discriminator;
        }

        @Override
        public String[] e() {
            return this.e;
        }

        @Override
        public boolean emax() {
            return this.emax;
        }

        @Override
        public boolean emin() {
            return this.emin;
        }

        @Override
        public boolean exclusiveMaximum() {
            return this.exclusiveMaximum;
        }

        @Override
        public boolean exclusiveMinimum() {
            return this.exclusiveMinimum;
        }

        @Override
        public ExternalDocs externalDocs() {
            return this.externalDocs;
        }

        @Override
        public String f() {
            return this.f;
        }

        @Override
        public String format() {
            return this.format;
        }

        @Override
        public boolean ignore() {
            return this.ignore;
        }

        @Override
        public Items items() {
            return this.items;
        }

        @Override
        public String max() {
            return this.max;
        }

        @Override
        public long maxi() {
            return this.maxi;
        }

        @Override
        public String maximum() {
            return this.maximum;
        }

        @Override
        public long maxItems() {
            return this.maxItems;
        }

        @Override
        public long maxl() {
            return this.maxl;
        }

        @Override
        public long maxLength() {
            return this.maxLength;
        }

        @Override
        public long maxp() {
            return this.maxp;
        }

        @Override
        public long maxProperties() {
            return this.maxProperties;
        }

        @Override
        public String min() {
            return this.min;
        }

        @Override
        public long mini() {
            return this.mini;
        }

        @Override
        public String minimum() {
            return this.minimum;
        }

        @Override
        public long minItems() {
            return this.minItems;
        }

        @Override
        public long minl() {
            return this.minl;
        }

        @Override
        public long minLength() {
            return this.minLength;
        }

        @Override
        public long minp() {
            return this.minp;
        }

        @Override
        public long minProperties() {
            return this.minProperties;
        }

        @Override
        public String mo() {
            return this.mo;
        }

        @Override
        public String multipleOf() {
            return this.multipleOf;
        }

        @Override
        public String p() {
            return this.p;
        }

        @Override
        public String pattern() {
            return this.pattern;
        }

        @Override
        public String[] properties() {
            return this.properties;
        }

        @Override
        public boolean r() {
            return this.r;
        }

        @Override
        public boolean readOnly() {
            return this.readOnly;
        }

        @Override
        public boolean required() {
            return this.required;
        }

        @Override
        public boolean ro() {
            return this.ro;
        }

        @Override
        public boolean sie() {
            return this.sie;
        }

        @Override
        public boolean skipIfEmpty() {
            return this.skipIfEmpty;
        }

        @Override
        public String t() {
            return this.t;
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public boolean ui() {
            return this.ui;
        }

        @Override
        public boolean uniqueItems() {
            return this.uniqueItems;
        }

        @Override
        public String[] xml() {
            return this.xml;
        }
    }
}

