/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.Console;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import jline.NoInterruptUnixTerminal;
import jline.Terminal;
import jline.TerminalFactory;
import org.apache.karaf.client.ClientConfig;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshBuilder;
import org.apache.sshd.SshClient;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.local.LocalAgentFactory;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.kex.DHG1;
import org.apache.sshd.client.kex.DHG14;
import org.apache.sshd.client.kex.ECDHP256;
import org.apache.sshd.client.kex.ECDHP384;
import org.apache.sshd.client.kex.ECDHP521;
import org.apache.sshd.client.kex.FixedDHGEX;
import org.apache.sshd.client.kex.FixedDHGEX256;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.impl.SimpleLogger;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int c;
        BufferedReader reader;
        StringBuilder sb;
        ClientConfig config = new ClientConfig(args);
        SimpleLogger.setLevel(config.getLevel());
        if (config.getFile() != null) {
            sb = new StringBuilder();
            sb.setLength(0);
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(config.getFile())));
            try {
                c = ((Reader)reader).read();
                while (c >= 0) {
                    sb.append((char)c);
                    c = ((Reader)reader).read();
                }
            }
            finally {
                ((Reader)reader).close();
            }
            config.setCommand(sb.toString());
        } else if (config.isBatch()) {
            sb = new StringBuilder();
            sb.setLength(0);
            reader = new BufferedReader(new InputStreamReader(System.in));
            c = ((Reader)reader).read();
            while (c >= 0) {
                sb.append((char)c);
                c = ((Reader)reader).read();
            }
            config.setCommand(sb.toString());
        }
        SshClient client = null;
        Terminal terminal = null;
        int exitStatus = 0;
        try {
            ClientChannel channel;
            SshBuilder.ClientBuilder clientBuilder = SshBuilder.client();
            clientBuilder.keyExchangeFactories(Main.getKexFactories());
            client = (SshClient)clientBuilder.build();
            Main.setupAgent(config.getUser(), config.getKeyFile(), client);
            client.getProperties().put("idle-timeout", String.valueOf(config.getIdleTimeout()));
            final Console console = System.console();
            if (console != null) {
                client.setUserInteraction(new UserInteraction(){

                    public void welcome(String banner) {
                        System.out.println(banner);
                    }

                    public String[] interactive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
                        String[] answers = new String[prompt.length];
                        try {
                            for (int i = 0; i < prompt.length; ++i) {
                                answers[i] = echo[i] ? console.readLine(prompt[i] + " ", new Object[0]) : new String(console.readPassword(prompt[i] + " ", new Object[0]));
                                if (answers[i] != null) continue;
                                return null;
                            }
                            return answers;
                        }
                        catch (IOError e) {
                            return null;
                        }
                    }
                });
            }
            client.start();
            if (console != null) {
                console.printf("Logging in as %s\n", config.getUser());
            }
            ClientSession session = Main.connectWithRetries(client, config);
            if (config.getPassword() != null) {
                session.addPasswordIdentity(config.getPassword());
            }
            session.auth().verify();
            if (config.getCommand().length() > 0) {
                channel = session.createChannel("exec", config.getCommand() + "\n");
                channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
            } else {
                TerminalFactory.registerFlavor((TerminalFactory.Flavor)TerminalFactory.Flavor.UNIX, NoInterruptUnixTerminal.class);
                terminal = TerminalFactory.create();
                channel = session.createChannel("shell");
                ConsoleInputStream in = new ConsoleInputStream(terminal.wrapInIfNeeded(System.in));
                new Thread(in).start();
                channel.setIn((InputStream)in);
                ((ChannelShell)channel).setPtyColumns(terminal != null ? terminal.getWidth() : 80);
                ((ChannelShell)channel).setupSensibleDefaultPty();
                ((ChannelShell)channel).setAgentForwarding(true);
                String ctype = System.getenv("LC_CTYPE");
                if (ctype == null) {
                    ctype = Locale.getDefault().toString() + "." + System.getProperty("input.encoding", Charset.defaultCharset().name());
                }
                ((ChannelShell)channel).setEnv("LC_CTYPE", ctype);
            }
            channel.setOut(AnsiConsole.wrapOutputStream((OutputStream)System.out));
            channel.setErr(AnsiConsole.wrapOutputStream((OutputStream)System.err));
            channel.open();
            channel.waitFor(2, 0L);
            if (channel.getExitStatus() != null) {
                exitStatus = channel.getExitStatus();
            }
        }
        catch (Throwable t) {
            if (config.getLevel() > 1) {
                t.printStackTrace();
            } else {
                System.err.println(t.getMessage());
            }
            System.exit(1);
        }
        finally {
            try {
                client.stop();
            }
            catch (Throwable t) {}
            try {
                if (terminal != null) {
                    terminal.restore();
                }
            }
            catch (Throwable t) {}
        }
        System.exit(exitStatus);
    }

    private static List<NamedFactory<KeyExchange>> getKexFactories() {
        ArrayList<NamedFactory<KeyExchange>> list = new ArrayList<NamedFactory<KeyExchange>>();
        if (SecurityUtils.hasEcc()) {
            list.add(new ECDHP521.Factory());
            list.add(new ECDHP384.Factory());
            list.add(new ECDHP256.Factory());
        }
        list.add(new FixedDHGEX256.Factory());
        list.add(new FixedDHGEX.Factory());
        list.add(new DHG14.Factory());
        list.add(new DHG1.Factory());
        return list;
    }

    private static void setupAgent(String user, String keyFile, SshClient client) {
        URL builtInPrivateKey = Main.class.getClassLoader().getResource("karaf.key");
        SshAgent agent = Main.startAgent(user, builtInPrivateKey, keyFile);
        client.setAgentFactory((SshAgentFactory)new LocalAgentFactory(agent));
        client.getProperties().put("SSH_AUTH_SOCK", "local");
    }

    private static ClientSession connectWithRetries(SshClient client, ClientConfig config) throws Exception, InterruptedException {
        ClientSession session = null;
        int retries = 0;
        do {
            ConnectFuture future = client.connect(config.getUser(), config.getHost(), config.getPort());
            future.await();
            try {
                session = future.getSession();
            }
            catch (RuntimeSshException ex) {
                if (retries++ < config.getRetryAttempts()) {
                    Thread.sleep(config.getRetryDelay() * 1000);
                    System.out.println("retrying (attempt " + retries + ") ...");
                    continue;
                }
                throw ex;
            }
        } while (session == null);
        return session;
    }

    private static SshAgent startAgent(String user, URL privateKeyUrl, String keyFile) {
        InputStream is = null;
        try {
            AgentImpl agent = new AgentImpl();
            is = privateKeyUrl.openStream();
            ObjectInputStream r = new ObjectInputStream(is);
            KeyPair keyPair = (KeyPair)r.readObject();
            is.close();
            agent.addIdentity(keyPair, user);
            if (keyFile != null) {
                String[] keyFiles = new String[]{keyFile};
                FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(keyFiles);
                for (KeyPair key : fileKeyPairProvider.loadKeys()) {
                    agent.addIdentity(key, user);
                }
            }
            return agent;
        }
        catch (Throwable e) {
            Main.close(is);
            System.err.println("Error starting ssh agent for: " + e.getMessage());
            return null;
        }
    }

    private static void close(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String readLine(String msg) throws IOException {
        StringBuffer sb = new StringBuffer();
        System.err.print(msg);
        System.err.flush();
        while (true) {
            int c;
            if ((c = System.in.read()) < 0) {
                return null;
            }
            System.err.print((char)c);
            if (c == 13 || c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    private static class ConsoleInputStream
    extends InputStream
    implements Runnable {
        private InputStream in;
        private boolean eof = false;
        private final BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(1024);

        public ConsoleInputStream(InputStream in) {
            this.in = in;
        }

        private int read(boolean wait) throws IOException {
            Integer i;
            if (this.eof && this.queue.isEmpty()) {
                return -1;
            }
            if (wait) {
                try {
                    i = this.queue.take();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            } else {
                i = (Integer)this.queue.poll();
            }
            if (i == null) {
                return -1;
            }
            return i;
        }

        @Override
        public int read() throws IOException {
            return this.read(true);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nb;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int i = this.read(true);
            if (i < 0) {
                return -1;
            }
            b[off++] = (byte)i;
            for (nb = 1; nb < len; ++nb) {
                i = this.read(false);
                if (i < 0) {
                    return nb;
                }
                b[off++] = (byte)i;
            }
            return nb;
        }

        @Override
        public int available() throws IOException {
            return this.queue.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    c = this.in.read();
                    if (c == -1) {
                        this.eof = true;
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable t) {
                    this.eof = true;
                    try {
                        this.queue.put(-1);
                        return;
                    }
                    catch (InterruptedException var2_4) {
                        // empty catch block
                    }
                    return;
                }
                catch (Throwable var3_5) {
                    this.eof = true;
                    try {
                        this.queue.put(-1);
                        throw var3_5;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    throw var3_5;
                }
                try {
                    this.queue.put(-1);
                    return;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    this.queue.put(c);
                    continue;
                }
                break;
            }
        }
    }
}

