/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.helper;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.helper.BaseTracker;
import org.apache.felix.cm.impl.helper.ConfigurationMap;
import org.apache.felix.cm.impl.helper.ManagedServiceFactoryConfigurationMap;
import org.apache.felix.cm.impl.helper.TargetedPID;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class ManagedServiceFactoryTracker
extends BaseTracker<ManagedServiceFactory> {
    public ManagedServiceFactoryTracker(ConfigurationManager cm) {
        super(cm, true);
    }

    @Override
    protected ConfigurationMap<?> createConfigurationMap(String[] pids) {
        return new ManagedServiceFactoryConfigurationMap(pids);
    }

    @Override
    public String getServicePid(ServiceReference<ManagedServiceFactory> service, TargetedPID pid) {
        return pid.getRawPid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void provideConfiguration(ServiceReference<ManagedServiceFactory> reference, TargetedPID configPid, TargetedPID factoryPid, Dictionary<String, ?> properties, long revision, ConfigurationMap<?> configs) {
        ManagedServiceFactory service = this.getRealService(reference);
        if (service == null) {
            return;
        }
        if (configs == null && (configs = (ConfigurationMap)this.getService(reference)) == null) {
            return;
        }
        if (configs.shallTake(configPid, factoryPid, revision)) {
            try {
                Dictionary props = this.getProperties(properties, reference, configPid.toString(), factoryPid.toString());
                this.updated(reference, service, configPid.toString(), props);
                configs.record(configPid, factoryPid, revision);
            }
            catch (Throwable t) {
                this.handleCallBackError(t, reference, configPid);
            }
            finally {
                this.ungetRealService(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfiguration(ServiceReference<ManagedServiceFactory> reference, TargetedPID configPid, TargetedPID factoryPid) {
        ManagedServiceFactory service = this.getRealService(reference);
        ConfigurationMap configs = (ConfigurationMap)this.getService(reference);
        if (service != null && configs != null && configs.removeConfiguration(configPid, factoryPid)) {
            try {
                this.deleted(reference, service, configPid.toString());
                configs.record(configPid, factoryPid, -1L);
            }
            catch (Throwable t) {
                this.handleCallBackError(t, reference, configPid);
            }
            finally {
                this.ungetRealService(reference);
            }
        }
    }

    private void updated(ServiceReference<ManagedServiceFactory> reference, final ManagedServiceFactory service, final String pid, final Dictionary properties) throws ConfigurationException {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ConfigurationException {
                        service.updated(pid, properties);
                        return null;
                    }
                }, this.getAccessControlContext(reference.getBundle()));
            }
            catch (PrivilegedActionException e) {
                throw (ConfigurationException)e.getException();
            }
        } else {
            service.updated(pid, properties);
        }
    }

    private void deleted(ServiceReference<ManagedServiceFactory> reference, final ManagedServiceFactory service, final String pid) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    service.deleted(pid);
                    return null;
                }
            }, this.getAccessControlContext(reference.getBundle()));
        } else {
            service.deleted(pid);
        }
    }
}

