/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="config", name="update", description="Saves and propagates changes from the configuration being edited.")
@Service
public class UpdateCommand
extends ConfigCommandSupport {
    @Override
    protected Object doExecute() throws Exception {
        boolean isFactory;
        TypedProperties props = this.getEditedProps();
        if (props == null) {
            System.err.println("No configuration is being edited. Run the edit command first.");
            return null;
        }
        String pid = (String)this.session.get("ConfigCommand.PID");
        String suffix = (String)this.session.get("ConfigCommand.Type");
        boolean bl = isFactory = this.session.get("ConfigCommand.Factory") != null && (Boolean)this.session.get("ConfigCommand.Factory") != false;
        if (isFactory) {
            String alias = (String)this.session.get("ConfigCommand.Alias");
            this.configRepository.createFactoryConfiguration(pid, alias, props, suffix);
        } else {
            this.configRepository.update(pid, props, suffix);
        }
        this.session.put("ConfigCommand.PID", null);
        this.session.put("ConfigCommand.Factory", null);
        this.session.put("ConfigCommand.Props", null);
        this.session.put("ConfigCommand.Type", null);
        if (this.session.get("ConfigCommand.Alias") != null) {
            this.session.put("ConfigCommand.Alias", null);
        }
        return null;
    }
}

