/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.config.impl;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class GatewayConfigImpl
extends Configuration
implements GatewayConfig {
    private static final String GATEWAY_DEFAULT_TOPOLOGY_NAME_PARAM = "default.app.topology.name";
    private static final String GATEWAY_DEFAULT_TOPOLOGY_NAME = null;
    private static final GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final String GATEWAY_CONFIG_DIR_PREFIX = "conf";
    private static final String GATEWAY_CONFIG_FILE_PREFIX = "gateway";
    private static final String DEFAULT_STACKS_SERVICES_DIR = "services";
    private static final String DEFAULT_APPLICATIONS_DIR = "applications";
    public static final String[] GATEWAY_CONFIG_FILENAMES = new String[]{"conf/gateway-default.xml", "conf/gateway-site.xml"};
    public static final String HTTP_HOST = "gateway.host";
    public static final String HTTP_PORT = "gateway.port";
    public static final String HTTP_PATH = "gateway.path";
    public static final String DEPLOYMENT_DIR = "gateway.deployment.dir";
    public static final String SECURITY_DIR = "gateway.security.dir";
    public static final String DATA_DIR = "gateway.data.dir";
    public static final String STACKS_SERVICES_DIR = "gateway.services.dir";
    public static final String GLOBAL_RULES_SERVICES = "gateway.global.rules.services";
    public static final String APPLICATIONS_DIR = "gateway.applications.dir";
    public static final String HADOOP_CONF_DIR = "gateway.hadoop.conf.dir";
    public static final String FRONTEND_URL = "gateway.frontend.url";
    private static final String TRUST_ALL_CERTS = "gateway.trust.all.certs";
    private static final String CLIENT_AUTH_NEEDED = "gateway.client.auth.needed";
    private static final String CLIENT_AUTH_WANTED = "gateway.client.auth.wanted";
    private static final String TRUSTSTORE_PATH = "gateway.truststore.path";
    private static final String TRUSTSTORE_TYPE = "gateway.truststore.type";
    private static final String KEYSTORE_TYPE = "gateway.keystore.type";
    private static final String XFORWARDED_ENABLED = "gateway.xforwarded.enabled";
    private static final String EPHEMERAL_DH_KEY_SIZE = "gateway.jdk.tls.ephemeralDHKeySize";
    private static final String HTTP_CLIENT_MAX_CONNECTION = "gateway.httpclient.maxConnections";
    private static final String HTTP_CLIENT_CONNECTION_TIMEOUT = "gateway.httpclient.connectionTimeout";
    private static final String HTTP_CLIENT_SOCKET_TIMEOUT = "gateway.httpclient.socketTimeout";
    private static final String THREAD_POOL_MAX = "gateway.threadpool.max";
    public static final String HTTP_SERVER_REQUEST_BUFFER = "gateway.httpserver.requestBuffer";
    public static final String HTTP_SERVER_REQUEST_HEADER_BUFFER = "gateway.httpserver.requestHeaderBuffer";
    public static final String HTTP_SERVER_RESPONSE_BUFFER = "gateway.httpserver.responseBuffer";
    public static final String HTTP_SERVER_RESPONSE_HEADER_BUFFER = "gateway.httpserver.responseHeaderBuffer";
    public static final String DEPLOYMENTS_BACKUP_VERSION_LIMIT = "gateway.deployment.backup.versionLimit";
    public static final String DEPLOYMENTS_BACKUP_AGE_LIMIT = "gateway.deployment.backup.ageLimit";
    public static final String METRICS_ENABLED = "gateway.metrics.enabled";
    public static final String JMX_METRICS_REPORTING_ENABLED = "gateway.jmx.metrics.reporting.enabled";
    public static final String GRAPHITE_METRICS_REPORTING_ENABLED = "gateway.graphite.metrics.reporting.enabled";
    public static final String GRAPHITE_METRICS_REPORTING_HOST = "gateway.graphite.metrics.reporting.host";
    public static final String GRAPHITE_METRICS_REPORTING_PORT = "gateway.graphite.metrics.reporting.port";
    public static final String GRAPHITE_METRICS_REPORTING_FREQUENCY = "gateway.graphite.metrics.reporting.frequency";
    public static final String GATEWAY_IDLE_TIMEOUT = "gateway.idle.timeout";
    public static final String REMOTE_IP_HEADER_NAME = "gateway.remote.ip.header.name";
    public static final String WEBSOCKET_FEATURE_ENABLED = "gateway.websocket.feature.enabled";
    public static final String WEBSOCKET_MAX_TEXT_MESSAGE_SIZE = "gateway.websocket.max.text.size";
    public static final String WEBSOCKET_MAX_BINARY_MESSAGE_SIZE = "gateway.websocket.max.binary.size";
    public static final String WEBSOCKET_MAX_TEXT_MESSAGE_BUFFER_SIZE = "gateway.websocket.max.text.buffer.size";
    public static final String WEBSOCKET_MAX_BINARY_MESSAGE_BUFFER_SIZE = "gateway.websocket.max.binary.buffer.size";
    public static final String WEBSOCKET_INPUT_BUFFER_SIZE = "gateway.websocket.input.buffer.size";
    public static final String WEBSOCKET_ASYNC_WRITE_TIMEOUT = "gateway.websocket.async.write.timeout";
    public static final String WEBSOCKET_IDLE_TIMEOUT = "gateway.websocket.idle.timeout";
    public static final String GATEWAY_PORT_MAPPING_PREFIX = "gateway.port.mapping.";
    public static final String GATEWAY_PORT_MAPPING_REGEX = "gateway\\.port\\.mapping\\..*";
    public static final String GATEWAY_PORT_MAPPING_ENABLED = "gateway.port.mapping.enabled";
    public static final String CLUSTER_CONFIG_MONITOR_PREFIX = "gateway.cluster.config.monitor.";
    public static final String CLUSTER_CONFIG_MONITOR_INTERVAL_SUFFIX = ".interval";
    public static final String CLUSTER_CONFIG_MONITOR_ENABLED_SUFFIX = ".enabled";
    private static final String SSL_ENABLED = "ssl.enabled";
    private static final String SSL_EXCLUDE_PROTOCOLS = "ssl.exclude.protocols";
    private static final String SSL_INCLUDE_CIPHERS = "ssl.include.ciphers";
    private static final String SSL_EXCLUDE_CIPHERS = "ssl.exclude.ciphers";
    public static final String DEFAULT_HTTP_PORT = "8888";
    public static final String DEFAULT_HTTP_PATH = "gateway";
    public static final String DEFAULT_DEPLOYMENT_DIR = "deployments";
    public static final String DEFAULT_SECURITY_DIR = "security";
    public static final String DEFAULT_DATA_DIR = "data";
    private static final String PROVIDERCONFIG_DIR_NAME = "shared-providers";
    private static final String DESCRIPTORS_DIR_NAME = "descriptors";
    public static final String REMOTE_ALIAS_SERVICE_ENABLED = "gateway.remote.alias.service.enabled";
    public static final String STRICT_TOPOLOGY_VALIDATION = "gateway.strict.topology.validation";
    public static final String READ_ONLY_OVERRIDE_TOPOLOGIES = "gateway.read.only.override.topologies";
    public static final boolean DEFAULT_WEBSOCKET_FEATURE_ENABLED = false;
    public static final int DEFAULT_WEBSOCKET_MAX_TEXT_MESSAGE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_WEBSOCKET_MAX_BINARY_MESSAGE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_WEBSOCKET_MAX_TEXT_MESSAGE_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WEBSOCKET_MAX_BINARY_MESSAGE_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WEBSOCKET_INPUT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_WEBSOCKET_ASYNC_WRITE_TIMEOUT = 60000;
    public static final int DEFAULT_WEBSOCKET_IDLE_TIMEOUT = 300000;
    public static final boolean DEFAULT_GATEWAY_PORT_MAPPING_ENABLED = true;
    public static final boolean DEFAULT_REMOTE_ALIAS_SERVICE_ENABLED = true;
    public static final boolean DEFAULT_STRICT_TOPOLOGY_VALIDATION = false;
    public static final String COOKIE_SCOPING_ENABLED = "gateway.scope.cookies.feature.enabled";
    public static final boolean DEFAULT_COOKIE_SCOPING_FEATURE_ENABLED = false;
    private static final String CRYPTO_ALGORITHM = "gateway.crypto.algorithm";
    private static final String CRYPTO_PBE_ALGORITHM = "gateway.crypto.pbe.algorithm";
    private static final String CRYPTO_TRANSFORMATION = "gateway.crypto.transformation";
    private static final String CRYPTO_SALTSIZE = "gateway.crypto.salt.size";
    private static final String CRYPTO_ITERATION_COUNT = "gateway.crypto.iteration.count";
    private static final String CRYPTO_KEY_LENGTH = "gateway.crypto.key.length";
    public static final String SERVER_HEADER_ENABLED = "gateway.server.header.enabled";
    static final String CONFIG_REGISTRY_PREFIX = "gateway.remote.config.registry";
    static final String REMOTE_CONFIG_MONITOR_CLIENT_NAME = "gateway.remote.config.monitor.client";
    static final String REMOTE_CONFIG_MONITOR_CLIENT_ALLOW_READ_ACCESS = "gateway.remote.config.monitor.client.allowUnauthenticatedReadAccess";
    static final String DEFAULT_DISCOVERY_ADDRESS = "gateway.discovery.default.address";
    static final String DEFAULT_DISCOVERY_CLUSTER = "gateway.discovery.default.cluster";
    static final String KNOX_ADMIN_GROUPS = "gateway.knox.admin.groups";
    static final String KNOX_ADMIN_USERS = "gateway.knox.admin.users";
    static final String CUSTOM_FEDERATION_HEADER_NAME = "gateway.custom.federation.header.name";
    static final String DEFAULT_FEDERATION_HEADER_NAME = "SM_USER";
    static final String AUTO_DEPLOY_TOPOLOGIES = "gateway.auto.deploy.topologies";
    static final String DEFAULT_AUTO_DEPLOY_TOPOLOGIES = "manager,admin";
    static final String DISPATCH_HOST_WHITELIST = "gateway.dispatch.whitelist";
    static final String DISPATCH_HOST_WHITELIST_SERVICES = "gateway.dispatch.whitelist.services";
    private static List<String> DEFAULT_GLOBAL_RULES_SERVICES;

    public GatewayConfigImpl() {
        this.init();
    }

    private String getVar(String variableName, String defaultValue) {
        String value = this.get(variableName);
        if (value == null) {
            value = System.getProperty(variableName);
        }
        if (value == null) {
            value = System.getenv(variableName);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private String getGatewayHomeDir() {
        return this.get("GATEWAY_HOME", System.getProperty("GATEWAY_HOME", System.getenv("GATEWAY_HOME")));
    }

    private void setGatewayHomeDir(String dir) {
        this.set("GATEWAY_HOME", dir);
    }

    public String getGatewayConfDir() {
        String value = this.getVar("GATEWAY_CONF_HOME", this.getGatewayHomeDir() + File.separator + GATEWAY_CONFIG_DIR_PREFIX);
        return FilenameUtils.normalize((String)value);
    }

    public String getGatewayDataDir() {
        String systemValue = System.getProperty("GATEWAY_DATA_HOME", System.getenv("GATEWAY_DATA_HOME"));
        String dataDir = null;
        dataDir = systemValue != null ? systemValue : this.get(DATA_DIR, this.getGatewayHomeDir() + File.separator + DEFAULT_DATA_DIR);
        return FilenameUtils.normalize((String)dataDir);
    }

    public String getGatewayServicesDir() {
        return this.get(STACKS_SERVICES_DIR, this.getGatewayDataDir() + File.separator + DEFAULT_STACKS_SERVICES_DIR);
    }

    public String getGatewayApplicationsDir() {
        return this.get(APPLICATIONS_DIR, this.getGatewayDataDir() + File.separator + DEFAULT_APPLICATIONS_DIR);
    }

    public String getHadoopConfDir() {
        return this.get(HADOOP_CONF_DIR);
    }

    private void init() {
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            this.set("env." + e.getKey(), e.getValue());
        }
        for (Map.Entry<Object, Object> p : System.getProperties().entrySet()) {
            this.set("sys." + p.getKey().toString(), p.getValue().toString());
        }
        URL lastFileUrl = null;
        for (String fileName : GATEWAY_CONFIG_FILENAMES) {
            lastFileUrl = this.loadConfig(fileName, lastFileUrl);
        }
        this.setDefaultGlobalRulesServices();
        this.initGatewayHomeDir(lastFileUrl);
        log.cookieScopingFeatureEnabled(this.isCookieScopingToPathEnabled());
    }

    private void setDefaultGlobalRulesServices() {
        DEFAULT_GLOBAL_RULES_SERVICES = new ArrayList<String>();
        DEFAULT_GLOBAL_RULES_SERVICES.add("NAMENODE");
        DEFAULT_GLOBAL_RULES_SERVICES.add("JOBTRACKER");
        DEFAULT_GLOBAL_RULES_SERVICES.add("WEBHDFS");
        DEFAULT_GLOBAL_RULES_SERVICES.add("WEBHCAT");
        DEFAULT_GLOBAL_RULES_SERVICES.add("OOZIE");
        DEFAULT_GLOBAL_RULES_SERVICES.add("WEBHBASE");
        DEFAULT_GLOBAL_RULES_SERVICES.add("HIVE");
        DEFAULT_GLOBAL_RULES_SERVICES.add("RESOURCEMANAGER");
    }

    private void initGatewayHomeDir(URL lastFileUrl) {
        String home = System.getProperty("GATEWAY_HOME");
        if (home != null) {
            this.set("GATEWAY_HOME", home);
            log.settingGatewayHomeDir("system property", home);
            return;
        }
        home = System.getenv("GATEWAY_HOME");
        if (home != null) {
            this.set("GATEWAY_HOME", home);
            log.settingGatewayHomeDir("environment variable", home);
            return;
        }
        if (lastFileUrl != null) {
            File file = new File(lastFileUrl.getFile()).getAbsoluteFile();
            File dir = file.getParentFile().getParentFile();
            if (dir.exists() && dir.canRead()) {
                home = dir.getAbsolutePath();
            }
            this.set("GATEWAY_HOME", home);
            log.settingGatewayHomeDir("configuration file location", home);
            return;
        }
        home = System.getProperty("user.dir");
        if (home != null) {
            this.set("GATEWAY_HOME", home);
            log.settingGatewayHomeDir("user.dir system property", home);
            return;
        }
    }

    private URL loadConfig(String fileName, URL lastFileUrl) {
        lastFileUrl = this.loadConfigFile(System.getProperty("GATEWAY_HOME"), fileName);
        if (lastFileUrl == null) {
            lastFileUrl = this.loadConfigFile(System.getenv("GATEWAY_HOME"), fileName);
        }
        if (lastFileUrl == null) {
            lastFileUrl = this.loadConfigFile(System.getProperty("user.dir"), fileName);
        }
        if (lastFileUrl == null) {
            lastFileUrl = this.loadConfigResource(fileName);
        }
        if (lastFileUrl != null && !"file".equals(lastFileUrl.getProtocol())) {
            lastFileUrl = null;
        }
        return lastFileUrl;
    }

    private URL loadConfigFile(String dir, String file) {
        File f;
        URL url = null;
        if (dir != null && (f = new File(dir, file)).exists()) {
            String path = f.getAbsolutePath();
            try {
                url = f.toURI().toURL();
                this.addResource(new Path(path));
                log.loadingConfigurationFile(path);
            }
            catch (MalformedURLException e) {
                log.failedToLoadConfig(path, e);
            }
        }
        return url;
    }

    private URL loadConfigResource(String file) {
        URL url = this.getResource(file);
        if (url != null) {
            log.loadingConfigurationResource(url.toExternalForm());
            this.addResource(url);
        }
        return url;
    }

    public String getGatewayHost() {
        return this.get(HTTP_HOST, "0.0.0.0");
    }

    public int getGatewayPort() {
        return Integer.parseInt(this.get(HTTP_PORT, DEFAULT_HTTP_PORT));
    }

    public String getGatewayPath() {
        return this.get(HTTP_PATH, "gateway");
    }

    public String getGatewayProvidersConfigDir() {
        return this.getGatewayConfDir() + File.separator + PROVIDERCONFIG_DIR_NAME;
    }

    public String getGatewayDescriptorsDir() {
        return this.getGatewayConfDir() + File.separator + DESCRIPTORS_DIR_NAME;
    }

    public String getGatewayTopologyDir() {
        return this.getGatewayConfDir() + File.separator + "topologies";
    }

    public String getGatewayDeploymentDir() {
        return this.get(DEPLOYMENT_DIR, this.getGatewayDataDir() + File.separator + DEFAULT_DEPLOYMENT_DIR);
    }

    public String getGatewaySecurityDir() {
        return this.get(SECURITY_DIR, this.getGatewayDataDir() + File.separator + DEFAULT_SECURITY_DIR);
    }

    public InetSocketAddress getGatewayAddress() throws UnknownHostException {
        String host = this.getGatewayHost();
        int port = this.getGatewayPort();
        return new InetSocketAddress(host, port);
    }

    public boolean isSSLEnabled() {
        String enabled = this.get(SSL_ENABLED, "true");
        return "true".equals(enabled);
    }

    public boolean isHadoopKerberosSecured() {
        String hadoopKerberosSecured = this.get("gateway.hadoop.kerberos.secured", "false");
        return "true".equals(hadoopKerberosSecured);
    }

    public String getKerberosConfig() {
        return this.get("java.security.krb5.conf");
    }

    public boolean isKerberosDebugEnabled() {
        String kerberosDebugEnabled = this.get("sun.security.krb5.debug", "false");
        return "true".equals(kerberosDebugEnabled);
    }

    public String getKerberosLoginConfig() {
        return this.get("java.security.auth.login.config");
    }

    public String getDefaultTopologyName() {
        String name = this.get(GATEWAY_DEFAULT_TOPOLOGY_NAME_PARAM);
        return name != null ? name : GATEWAY_DEFAULT_TOPOLOGY_NAME;
    }

    public String getDefaultAppRedirectPath() {
        String defTopo = this.getDefaultTopologyName();
        if (defTopo == null) {
            return null;
        }
        return "/" + this.getGatewayPath() + "/" + defTopo;
    }

    public String getFrontendUrl() {
        return this.get(FRONTEND_URL, null);
    }

    public List<String> getExcludedSSLProtocols() {
        List<String> protocols = null;
        String value = this.get(SSL_EXCLUDE_PROTOCOLS);
        if (!"none".equals(value)) {
            protocols = Arrays.asList(value.split("\\s*,\\s*"));
        }
        return protocols;
    }

    public List<String> getIncludedSSLCiphers() {
        List<String> list = null;
        String value = this.get(SSL_INCLUDE_CIPHERS);
        if (value != null && !value.isEmpty() && !"none".equalsIgnoreCase(value.trim())) {
            list = Arrays.asList(value.trim().split("\\s*,\\s*"));
        }
        return list;
    }

    public List<String> getExcludedSSLCiphers() {
        List<String> list = null;
        String value = this.get(SSL_EXCLUDE_CIPHERS);
        if (value != null && !value.isEmpty() && !"none".equalsIgnoreCase(value.trim())) {
            list = Arrays.asList(value.trim().split("\\s*,\\s*"));
        }
        return list;
    }

    public boolean isClientAuthNeeded() {
        String clientAuthNeeded = this.get(CLIENT_AUTH_NEEDED, "false");
        return "true".equals(clientAuthNeeded);
    }

    public boolean isClientAuthWanted() {
        String clientAuthWanted = this.get(CLIENT_AUTH_WANTED, "false");
        return "true".equals(clientAuthWanted);
    }

    public String getTruststorePath() {
        return this.get(TRUSTSTORE_PATH, null);
    }

    public boolean getTrustAllCerts() {
        String trustAllCerts = this.get(TRUST_ALL_CERTS, "false");
        return "true".equals(trustAllCerts);
    }

    public String getTruststoreType() {
        return this.get(TRUSTSTORE_TYPE, "JKS");
    }

    public String getKeystoreType() {
        return this.get(KEYSTORE_TYPE, "JKS");
    }

    public boolean isXForwardedEnabled() {
        String xForwardedEnabled = this.get(XFORWARDED_ENABLED, "true");
        return "true".equals(xForwardedEnabled);
    }

    public String getEphemeralDHKeySize() {
        return this.get(EPHEMERAL_DH_KEY_SIZE, "2048");
    }

    public int getHttpClientMaxConnections() {
        return this.getInt(HTTP_CLIENT_MAX_CONNECTION, 32);
    }

    public int getHttpClientConnectionTimeout() {
        int t = -1;
        String s = this.get(HTTP_CLIENT_CONNECTION_TIMEOUT, String.valueOf(TimeUnit.SECONDS.toMillis(20L)));
        if (s != null) {
            try {
                t = (int)GatewayConfigImpl.parseNetworkTimeout(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t;
    }

    public int getHttpClientSocketTimeout() {
        int t = -1;
        String s = this.get(HTTP_CLIENT_SOCKET_TIMEOUT, String.valueOf(TimeUnit.SECONDS.toMillis(20L)));
        if (s != null) {
            try {
                t = (int)GatewayConfigImpl.parseNetworkTimeout(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t;
    }

    public int getThreadPoolMax() {
        int i = this.getInt(THREAD_POOL_MAX, 254);
        if (i < 5) {
            i = 5;
        }
        return i;
    }

    public int getHttpServerRequestBuffer() {
        return this.getInt(HTTP_SERVER_REQUEST_BUFFER, 16384);
    }

    public int getHttpServerRequestHeaderBuffer() {
        return this.getInt(HTTP_SERVER_REQUEST_HEADER_BUFFER, 8192);
    }

    public int getHttpServerResponseBuffer() {
        return this.getInt(HTTP_SERVER_RESPONSE_BUFFER, 32768);
    }

    public int getHttpServerResponseHeaderBuffer() {
        return this.getInt(HTTP_SERVER_RESPONSE_HEADER_BUFFER, 8192);
    }

    public int getGatewayDeploymentsBackupVersionLimit() {
        int i = this.getInt(DEPLOYMENTS_BACKUP_VERSION_LIMIT, 5);
        if (i < 0) {
            i = -1;
        }
        return i;
    }

    public long getGatewayIdleTimeout() {
        return this.getLong(GATEWAY_IDLE_TIMEOUT, 300000L);
    }

    public long getGatewayDeploymentsBackupAgeLimit() {
        long d;
        PeriodFormatter f = new PeriodFormatterBuilder().appendDays().toFormatter();
        String s = this.get(DEPLOYMENTS_BACKUP_AGE_LIMIT, "-1");
        try {
            Period p = Period.parse((String)s, (PeriodFormatter)f);
            d = p.toStandardDuration().getMillis();
            if (d < 0L) {
                d = -1L;
            }
        }
        catch (Exception e) {
            d = -1L;
        }
        return d;
    }

    public String getSigningKeystoreName() {
        return this.get("gateway.signing.keystore.name");
    }

    public String getSigningKeyAlias() {
        return this.get("gateway.signing.key.alias");
    }

    public List<String> getGlobalRulesServices() {
        String value = this.get(GLOBAL_RULES_SERVICES);
        if (value != null && !value.isEmpty() && !"none".equalsIgnoreCase(value.trim())) {
            return Arrays.asList(value.trim().split("\\s*,\\s*"));
        }
        return DEFAULT_GLOBAL_RULES_SERVICES;
    }

    public boolean isMetricsEnabled() {
        String metricsEnabled = this.get(METRICS_ENABLED, "false");
        return "true".equals(metricsEnabled);
    }

    public boolean isJmxMetricsReportingEnabled() {
        String enabled = this.get(JMX_METRICS_REPORTING_ENABLED, "false");
        return "true".equals(enabled);
    }

    public boolean isGraphiteMetricsReportingEnabled() {
        String enabled = this.get(GRAPHITE_METRICS_REPORTING_ENABLED, "false");
        return "true".equals(enabled);
    }

    public String getGraphiteHost() {
        return this.get(GRAPHITE_METRICS_REPORTING_HOST, "localhost");
    }

    public int getGraphitePort() {
        return this.getInt(GRAPHITE_METRICS_REPORTING_PORT, 32772);
    }

    public int getGraphiteReportingFrequency() {
        return this.getInt(GRAPHITE_METRICS_REPORTING_FREQUENCY, 1);
    }

    public boolean isWebsocketEnabled() {
        String result = this.get(WEBSOCKET_FEATURE_ENABLED, Boolean.toString(false));
        return Boolean.parseBoolean(result);
    }

    public int getWebsocketMaxTextMessageSize() {
        return this.getInt(WEBSOCKET_MAX_TEXT_MESSAGE_SIZE, Integer.MAX_VALUE);
    }

    public int getWebsocketMaxBinaryMessageSize() {
        return this.getInt(WEBSOCKET_MAX_BINARY_MESSAGE_SIZE, Integer.MAX_VALUE);
    }

    public int getWebsocketMaxTextMessageBufferSize() {
        return this.getInt(WEBSOCKET_MAX_TEXT_MESSAGE_BUFFER_SIZE, 32768);
    }

    public int getWebsocketMaxBinaryMessageBufferSize() {
        return this.getInt(WEBSOCKET_MAX_BINARY_MESSAGE_BUFFER_SIZE, 32768);
    }

    public int getWebsocketInputBufferSize() {
        return this.getInt(WEBSOCKET_INPUT_BUFFER_SIZE, 4096);
    }

    public int getWebsocketAsyncWriteTimeout() {
        return this.getInt(WEBSOCKET_ASYNC_WRITE_TIMEOUT, 60000);
    }

    public int getWebsocketIdleTimeout() {
        return this.getInt(WEBSOCKET_IDLE_TIMEOUT, 300000);
    }

    public Map<String, Integer> getGatewayPortMappings() {
        ConcurrentHashMap<String, Integer> result = new ConcurrentHashMap<String, Integer>();
        Map properties = this.getValByRegex(GATEWAY_PORT_MAPPING_REGEX);
        for (Map.Entry e : properties.entrySet()) {
            if (((String)e.getKey()).equalsIgnoreCase(GATEWAY_PORT_MAPPING_ENABLED)) continue;
            result.put(StringUtils.substringAfter((String)((String)e.getKey()), (String)GATEWAY_PORT_MAPPING_PREFIX), Integer.parseInt((String)e.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    public boolean isGatewayPortMappingEnabled() {
        String result = this.get(GATEWAY_PORT_MAPPING_ENABLED, Boolean.toString(true));
        return Boolean.parseBoolean(result);
    }

    private static long parseNetworkTimeout(String s) {
        PeriodFormatter f = new PeriodFormatterBuilder().appendMinutes().appendSuffix("m", " min").appendSeconds().appendSuffix("s", " sec").appendMillis().toFormatter();
        Period p = Period.parse((String)s, (PeriodFormatter)f);
        return p.toStandardDuration().getMillis();
    }

    public boolean isCookieScopingToPathEnabled() {
        return Boolean.parseBoolean(this.get(COOKIE_SCOPING_ENABLED, Boolean.toString(false)));
    }

    public String getHeaderNameForRemoteAddress() {
        return this.getVar(REMOTE_IP_HEADER_NAME, "X-Forwarded-For");
    }

    public String getAlgorithm() {
        return this.getVar(CRYPTO_ALGORITHM, null);
    }

    public String getPBEAlgorithm() {
        return this.getVar(CRYPTO_PBE_ALGORITHM, null);
    }

    public String getTransformation() {
        return this.getVar(CRYPTO_TRANSFORMATION, null);
    }

    public String getSaltSize() {
        return this.getVar(CRYPTO_SALTSIZE, null);
    }

    public String getIterationCount() {
        return this.getVar(CRYPTO_ITERATION_COUNT, null);
    }

    public String getKeyLength() {
        return this.getVar(CRYPTO_KEY_LENGTH, null);
    }

    public boolean isGatewayServerHeaderEnabled() {
        return Boolean.parseBoolean(this.getVar(SERVER_HEADER_ENABLED, "true"));
    }

    public String getDefaultDiscoveryAddress() {
        return this.getVar(DEFAULT_DISCOVERY_ADDRESS, null);
    }

    public String getDefaultDiscoveryCluster() {
        return this.getVar(DEFAULT_DISCOVERY_CLUSTER, null);
    }

    public int getClusterMonitorPollingInterval(String type) {
        return this.getInt(CLUSTER_CONFIG_MONITOR_PREFIX + type.toLowerCase(Locale.ROOT) + CLUSTER_CONFIG_MONITOR_INTERVAL_SUFFIX, -1);
    }

    public boolean isClusterMonitorEnabled(String type) {
        return this.getBoolean(CLUSTER_CONFIG_MONITOR_PREFIX + type.toLowerCase(Locale.ROOT) + CLUSTER_CONFIG_MONITOR_ENABLED_SUFFIX, true);
    }

    public List<String> getRemoteRegistryConfigurationNames() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String propertyName = (String)entry.getKey();
            if (!propertyName.startsWith(CONFIG_REGISTRY_PREFIX)) continue;
            String registryName = propertyName.substring(CONFIG_REGISTRY_PREFIX.length() + 1);
            result.add(registryName);
        }
        return result;
    }

    public String getRemoteRegistryConfiguration(String name) {
        return this.get("gateway.remote.config.registry." + name);
    }

    public String getRemoteConfigurationMonitorClientName() {
        return this.get(REMOTE_CONFIG_MONITOR_CLIENT_NAME);
    }

    public boolean allowUnauthenticatedRemoteRegistryReadAccess() {
        return Boolean.parseBoolean(this.get(REMOTE_CONFIG_MONITOR_CLIENT_ALLOW_READ_ACCESS, String.valueOf(false)));
    }

    public boolean isRemoteAliasServiceEnabled() {
        String result = this.get(REMOTE_ALIAS_SERVICE_ENABLED, Boolean.toString(true));
        return Boolean.parseBoolean(result);
    }

    public List<String> getReadOnlyOverrideTopologyNames() {
        ArrayList<String> topologyNames = new ArrayList<String>();
        String value = this.get(READ_ONLY_OVERRIDE_TOPOLOGIES);
        if (value != null && !value.isEmpty()) {
            topologyNames.addAll(Arrays.asList(value.trim().split("\\s*,\\s*")));
        }
        return topologyNames;
    }

    public String getKnoxAdminGroups() {
        return this.get(KNOX_ADMIN_GROUPS, null);
    }

    public String getKnoxAdminUsers() {
        return this.get(KNOX_ADMIN_USERS, null);
    }

    public String getFederationHeaderName() {
        return this.get(CUSTOM_FEDERATION_HEADER_NAME, DEFAULT_FEDERATION_HEADER_NAME);
    }

    public List<String> getAutoDeployTopologyNames() {
        ArrayList<String> topologyNames = new ArrayList<String>();
        String value = this.get(AUTO_DEPLOY_TOPOLOGIES);
        if (value == null) {
            value = DEFAULT_AUTO_DEPLOY_TOPOLOGIES;
        }
        topologyNames.addAll(Arrays.asList(value.trim().split("\\s*,\\s*")));
        return topologyNames;
    }

    public String getDispatchWhitelist() {
        return this.get(DISPATCH_HOST_WHITELIST);
    }

    public List<String> getDispatchWhitelistServices() {
        ArrayList<String> result = new ArrayList<String>();
        String serviceList = this.get(DISPATCH_HOST_WHITELIST_SERVICES);
        if (serviceList != null) {
            for (String service : serviceList.split(",")) {
                result.add(service.trim());
            }
        }
        return result;
    }

    public boolean isTopologyValidationEnabled() {
        String result = this.get(STRICT_TOPOLOGY_VALIDATION, Boolean.toString(false));
        return Boolean.parseBoolean(result);
    }
}

