/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.preauth.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.preauth.filter.PreAuthValidationException;
import org.apache.knox.gateway.preauth.filter.PreAuthValidator;

public class PreAuthService {
    public static final String VALIDATION_METHOD_PARAM = "preauth.validation.method";
    private static ConcurrentHashMap<String, PreAuthValidator> validatorMap;

    private static void initializeValidators() {
        ServiceLoader<PreAuthValidator> servLoader = ServiceLoader.load(PreAuthValidator.class);
        validatorMap = new ConcurrentHashMap();
        for (PreAuthValidator validator : servLoader) {
            validatorMap.put(validator.getName(), validator);
        }
    }

    public static Map<String, PreAuthValidator> getValidatorMap() {
        return Collections.unmodifiableMap(validatorMap);
    }

    public static List<PreAuthValidator> getValidators(FilterConfig filterConfig) throws ServletException {
        String validationMethods = filterConfig.getInitParameter(VALIDATION_METHOD_PARAM);
        ArrayList<PreAuthValidator> vList = new ArrayList<PreAuthValidator>();
        if (validationMethods == null || validationMethods.isEmpty()) {
            validationMethods = "preauth.default.validation";
        }
        LinkedHashSet vMethodSet = new LinkedHashSet();
        Collections.addAll(vMethodSet, validationMethods.trim().split("\\s*,\\s*"));
        for (String vName : vMethodSet) {
            if (validatorMap.containsKey(vName)) {
                vList.add(validatorMap.get(vName));
                continue;
            }
            throw new ServletException(String.format(Locale.ROOT, "Unable to find validator with name '%s'", validationMethods));
        }
        return vList;
    }

    public static boolean validate(HttpServletRequest httpRequest, FilterConfig filterConfig, List<PreAuthValidator> validators) {
        try {
            for (PreAuthValidator validator : validators) {
                if (validator.validate(httpRequest, filterConfig)) continue;
                return false;
            }
        }
        catch (PreAuthValidationException e) {
            return false;
        }
        return true;
    }

    static {
        PreAuthService.initializeValidators();
    }
}

