/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterRef;
import com.cloudera.api.swagger.model.ApiConfigStalenessStatus;
import com.cloudera.api.swagger.model.ApiEntityStatus;
import com.cloudera.api.swagger.model.ApiEntityType;
import com.cloudera.api.swagger.model.ApiHealthCheck;
import com.cloudera.api.swagger.model.ApiHealthSummary;
import com.cloudera.api.swagger.model.ApiReplicationSchedule;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiRoleConfigGroup;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import com.cloudera.api.swagger.model.ApiServiceState;
import com.cloudera.api.swagger.model.ApiSnapshotPolicy;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A service (such as HDFS, MapReduce, HBase) runs in a cluster. It has roles, which are the actual entities (NameNode, DataNodes, etc.) that perform the service's functions.  <h3>HDFS services and health checks</h3>  In CDH4, HDFS services may not present any health checks. This will happen if the service has more than one nameservice configured. In those cases, the health information will be available by fetching information about the nameservices instead. <p> The health summary is still available, and reflects a service-wide summary.")
public class ApiService {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="clusterRef")
    private ApiClusterRef clusterRef = null;
    @SerializedName(value="serviceState")
    private ApiServiceState serviceState = null;
    @SerializedName(value="healthSummary")
    private ApiHealthSummary healthSummary = null;
    @SerializedName(value="configStale")
    private Boolean configStale = null;
    @SerializedName(value="configStalenessStatus")
    private ApiConfigStalenessStatus configStalenessStatus = null;
    @SerializedName(value="clientConfigStalenessStatus")
    private ApiConfigStalenessStatus clientConfigStalenessStatus = null;
    @SerializedName(value="healthChecks")
    private List<ApiHealthCheck> healthChecks = null;
    @SerializedName(value="serviceUrl")
    private String serviceUrl = null;
    @SerializedName(value="roleInstancesUrl")
    private String roleInstancesUrl = null;
    @SerializedName(value="maintenanceMode")
    private Boolean maintenanceMode = null;
    @SerializedName(value="maintenanceOwners")
    private List<ApiEntityType> maintenanceOwners = null;
    @SerializedName(value="config")
    private ApiServiceConfig config = null;
    @SerializedName(value="roles")
    private List<ApiRole> roles = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="roleConfigGroups")
    private List<ApiRoleConfigGroup> roleConfigGroups = null;
    @SerializedName(value="replicationSchedules")
    private List<ApiReplicationSchedule> replicationSchedules = null;
    @SerializedName(value="snapshotPolicies")
    private List<ApiSnapshotPolicy> snapshotPolicies = null;
    @SerializedName(value="entityStatus")
    private ApiEntityStatus entityStatus = null;

    public ApiService name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the service.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiService type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the service, e.g. HDFS, MAPREDUCE, HBASE.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ApiService clusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
        return this;
    }

    @ApiModelProperty(value="Readonly. A reference to the enclosing cluster.")
    public ApiClusterRef getClusterRef() {
        return this.clusterRef;
    }

    public void setClusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
    }

    public ApiService serviceState(ApiServiceState serviceState) {
        this.serviceState = serviceState;
        return this;
    }

    @ApiModelProperty(value="Readonly. The configured run state of this service. Whether it's running, etc.")
    public ApiServiceState getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(ApiServiceState serviceState) {
        this.serviceState = serviceState;
    }

    public ApiService healthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
        return this;
    }

    @ApiModelProperty(value="Readonly. The high-level health status of this service.")
    public ApiHealthSummary getHealthSummary() {
        return this.healthSummary;
    }

    public void setHealthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
    }

    public ApiService configStale(Boolean configStale) {
        this.configStale = configStale;
        return this;
    }

    @ApiModelProperty(value="Readonly. Expresses whether the service configuration is stale.")
    public Boolean getConfigStale() {
        return this.configStale;
    }

    public void setConfigStale(Boolean configStale) {
        this.configStale = configStale;
    }

    public ApiService configStalenessStatus(ApiConfigStalenessStatus configStalenessStatus) {
        this.configStalenessStatus = configStalenessStatus;
        return this;
    }

    @ApiModelProperty(value="Readonly. Expresses the service's configuration staleness status which is based on the staleness status of its roles. Available since API v6.")
    public ApiConfigStalenessStatus getConfigStalenessStatus() {
        return this.configStalenessStatus;
    }

    public void setConfigStalenessStatus(ApiConfigStalenessStatus configStalenessStatus) {
        this.configStalenessStatus = configStalenessStatus;
    }

    public ApiService clientConfigStalenessStatus(ApiConfigStalenessStatus clientConfigStalenessStatus) {
        this.clientConfigStalenessStatus = clientConfigStalenessStatus;
        return this;
    }

    @ApiModelProperty(value="Readonly. Expresses the service's client configuration staleness status which is marked as stale if any of the service's hosts have missing client configurations or if any of the deployed client configurations are stale. Available since API v6.")
    public ApiConfigStalenessStatus getClientConfigStalenessStatus() {
        return this.clientConfigStalenessStatus;
    }

    public void setClientConfigStalenessStatus(ApiConfigStalenessStatus clientConfigStalenessStatus) {
        this.clientConfigStalenessStatus = clientConfigStalenessStatus;
    }

    public ApiService healthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
        return this;
    }

    public ApiService addHealthChecksItem(ApiHealthCheck healthChecksItem) {
        if (this.healthChecks == null) {
            this.healthChecks = new ArrayList<ApiHealthCheck>();
        }
        this.healthChecks.add(healthChecksItem);
        return this;
    }

    @ApiModelProperty(value="Readonly. The list of health checks of this service.")
    public List<ApiHealthCheck> getHealthChecks() {
        return this.healthChecks;
    }

    public void setHealthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    public ApiService serviceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    @ApiModelProperty(value="Readonly. Link into the Cloudera Manager web UI for this specific service.")
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public ApiService roleInstancesUrl(String roleInstancesUrl) {
        this.roleInstancesUrl = roleInstancesUrl;
        return this;
    }

    @ApiModelProperty(value="Readonly. Link into the Cloudera Manager web UI for role instances table for this specific service. Available since API v11.")
    public String getRoleInstancesUrl() {
        return this.roleInstancesUrl;
    }

    public void setRoleInstancesUrl(String roleInstancesUrl) {
        this.roleInstancesUrl = roleInstancesUrl;
    }

    public ApiService maintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
        return this;
    }

    @ApiModelProperty(value="Readonly. Whether the service is in maintenance mode. Available since API v2.")
    public Boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    public ApiService maintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = maintenanceOwners;
        return this;
    }

    public ApiService addMaintenanceOwnersItem(ApiEntityType maintenanceOwnersItem) {
        if (this.maintenanceOwners == null) {
            this.maintenanceOwners = new ArrayList<ApiEntityType>();
        }
        this.maintenanceOwners.add(maintenanceOwnersItem);
        return this;
    }

    @ApiModelProperty(example="\"null\"", value="Readonly. The list of objects that trigger this service to be in maintenance mode. Available since API v2.")
    public List<ApiEntityType> getMaintenanceOwners() {
        return this.maintenanceOwners;
    }

    public void setMaintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = maintenanceOwners;
    }

    public ApiService config(ApiServiceConfig config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(value="Configuration of the service being created. Optional.")
    public ApiServiceConfig getConfig() {
        return this.config;
    }

    public void setConfig(ApiServiceConfig config) {
        this.config = config;
    }

    public ApiService roles(List<ApiRole> roles) {
        this.roles = roles;
        return this;
    }

    public ApiService addRolesItem(ApiRole rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<ApiRole>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="The list of service roles. Optional.")
    public List<ApiRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<ApiRole> roles) {
        this.roles = roles;
    }

    public ApiService displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="The display name for the service that is shown in the UI. Available since API v2.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiService roleConfigGroups(List<ApiRoleConfigGroup> roleConfigGroups) {
        this.roleConfigGroups = roleConfigGroups;
        return this;
    }

    public ApiService addRoleConfigGroupsItem(ApiRoleConfigGroup roleConfigGroupsItem) {
        if (this.roleConfigGroups == null) {
            this.roleConfigGroups = new ArrayList<ApiRoleConfigGroup>();
        }
        this.roleConfigGroups.add(roleConfigGroupsItem);
        return this;
    }

    @ApiModelProperty(value="The list of role configuration groups in this service. Optional. Available since API v3.")
    public List<ApiRoleConfigGroup> getRoleConfigGroups() {
        return this.roleConfigGroups;
    }

    public void setRoleConfigGroups(List<ApiRoleConfigGroup> roleConfigGroups) {
        this.roleConfigGroups = roleConfigGroups;
    }

    public ApiService replicationSchedules(List<ApiReplicationSchedule> replicationSchedules) {
        this.replicationSchedules = replicationSchedules;
        return this;
    }

    public ApiService addReplicationSchedulesItem(ApiReplicationSchedule replicationSchedulesItem) {
        if (this.replicationSchedules == null) {
            this.replicationSchedules = new ArrayList<ApiReplicationSchedule>();
        }
        this.replicationSchedules.add(replicationSchedulesItem);
        return this;
    }

    @ApiModelProperty(value="The list of replication schedules for this service. Optional. Available since API v6.")
    public List<ApiReplicationSchedule> getReplicationSchedules() {
        return this.replicationSchedules;
    }

    public void setReplicationSchedules(List<ApiReplicationSchedule> replicationSchedules) {
        this.replicationSchedules = replicationSchedules;
    }

    public ApiService snapshotPolicies(List<ApiSnapshotPolicy> snapshotPolicies) {
        this.snapshotPolicies = snapshotPolicies;
        return this;
    }

    public ApiService addSnapshotPoliciesItem(ApiSnapshotPolicy snapshotPoliciesItem) {
        if (this.snapshotPolicies == null) {
            this.snapshotPolicies = new ArrayList<ApiSnapshotPolicy>();
        }
        this.snapshotPolicies.add(snapshotPoliciesItem);
        return this;
    }

    @ApiModelProperty(value="The list of snapshot policies for this service. Optional. Available since API v6.")
    public List<ApiSnapshotPolicy> getSnapshotPolicies() {
        return this.snapshotPolicies;
    }

    public void setSnapshotPolicies(List<ApiSnapshotPolicy> snapshotPolicies) {
        this.snapshotPolicies = snapshotPolicies;
    }

    public ApiService entityStatus(ApiEntityStatus entityStatus) {
        this.entityStatus = entityStatus;
        return this;
    }

    @ApiModelProperty(value="Readonly. The entity status for this service. Available since API v11.")
    public ApiEntityStatus getEntityStatus() {
        return this.entityStatus;
    }

    public void setEntityStatus(ApiEntityStatus entityStatus) {
        this.entityStatus = entityStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiService apiService = (ApiService)o;
        return Objects.equals(this.name, apiService.name) && Objects.equals(this.type, apiService.type) && Objects.equals(this.clusterRef, apiService.clusterRef) && Objects.equals((Object)this.serviceState, (Object)apiService.serviceState) && Objects.equals((Object)this.healthSummary, (Object)apiService.healthSummary) && Objects.equals(this.configStale, apiService.configStale) && Objects.equals((Object)this.configStalenessStatus, (Object)apiService.configStalenessStatus) && Objects.equals((Object)this.clientConfigStalenessStatus, (Object)apiService.clientConfigStalenessStatus) && Objects.equals(this.healthChecks, apiService.healthChecks) && Objects.equals(this.serviceUrl, apiService.serviceUrl) && Objects.equals(this.roleInstancesUrl, apiService.roleInstancesUrl) && Objects.equals(this.maintenanceMode, apiService.maintenanceMode) && Objects.equals(this.maintenanceOwners, apiService.maintenanceOwners) && Objects.equals(this.config, apiService.config) && Objects.equals(this.roles, apiService.roles) && Objects.equals(this.displayName, apiService.displayName) && Objects.equals(this.roleConfigGroups, apiService.roleConfigGroups) && Objects.equals(this.replicationSchedules, apiService.replicationSchedules) && Objects.equals(this.snapshotPolicies, apiService.snapshotPolicies) && Objects.equals((Object)this.entityStatus, (Object)apiService.entityStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.clusterRef, this.serviceState, this.healthSummary, this.configStale, this.configStalenessStatus, this.clientConfigStalenessStatus, this.healthChecks, this.serviceUrl, this.roleInstancesUrl, this.maintenanceMode, this.maintenanceOwners, this.config, this.roles, this.displayName, this.roleConfigGroups, this.replicationSchedules, this.snapshotPolicies, this.entityStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiService {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    clusterRef: ").append(this.toIndentedString(this.clusterRef)).append("\n");
        sb.append("    serviceState: ").append(this.toIndentedString((Object)this.serviceState)).append("\n");
        sb.append("    healthSummary: ").append(this.toIndentedString((Object)this.healthSummary)).append("\n");
        sb.append("    configStale: ").append(this.toIndentedString(this.configStale)).append("\n");
        sb.append("    configStalenessStatus: ").append(this.toIndentedString((Object)this.configStalenessStatus)).append("\n");
        sb.append("    clientConfigStalenessStatus: ").append(this.toIndentedString((Object)this.clientConfigStalenessStatus)).append("\n");
        sb.append("    healthChecks: ").append(this.toIndentedString(this.healthChecks)).append("\n");
        sb.append("    serviceUrl: ").append(this.toIndentedString(this.serviceUrl)).append("\n");
        sb.append("    roleInstancesUrl: ").append(this.toIndentedString(this.roleInstancesUrl)).append("\n");
        sb.append("    maintenanceMode: ").append(this.toIndentedString(this.maintenanceMode)).append("\n");
        sb.append("    maintenanceOwners: ").append(this.toIndentedString(this.maintenanceOwners)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    roleConfigGroups: ").append(this.toIndentedString(this.roleConfigGroups)).append("\n");
        sb.append("    replicationSchedules: ").append(this.toIndentedString(this.replicationSchedules)).append("\n");
        sb.append("    snapshotPolicies: ").append(this.toIndentedString(this.snapshotPolicies)).append("\n");
        sb.append("    entityStatus: ").append(this.toIndentedString((Object)this.entityStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

