/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.lms.DigestUtil;
import org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import org.bouncycastle.pqc.crypto.lms.LMOtsPrivateKey;
import org.bouncycastle.pqc.crypto.lms.LMOtsSignature;
import org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSSignature;
import org.bouncycastle.pqc.crypto.lms.LMSigParameters;
import org.bouncycastle.pqc.crypto.lms.LM_OTS;
import org.bouncycastle.pqc.crypto.lms.LmsUtils;

class LMS {
    static final short D_LEAF = -32126;
    static final short D_INTR = -31869;

    LMS() {
    }

    public static LMSPrivateKeyParameters generateKeys(LMSigParameters lMSigParameters, LMOtsParameters lMOtsParameters, int n, byte[] byArray, byte[] byArray2) throws IllegalArgumentException {
        if (byArray2 == null || byArray2.length < lMSigParameters.getM()) {
            throw new IllegalArgumentException("root seed is less than " + lMSigParameters.getM());
        }
        int n2 = 1 << lMSigParameters.getH();
        return new LMSPrivateKeyParameters(lMSigParameters, lMOtsParameters, n, byArray, n2, byArray2);
    }

    public static LMSSignature generateSign(LMSPrivateKeyParameters lMSPrivateKeyParameters, byte[] byArray) {
        LMSigParameters lMSigParameters = lMSPrivateKeyParameters.getSigParameters();
        int n = lMSigParameters.getH();
        int n2 = lMSPrivateKeyParameters.getIndex();
        LMOtsPrivateKey lMOtsPrivateKey = lMSPrivateKeyParameters.getNextOtsPrivateKey();
        LMOtsSignature lMOtsSignature = LM_OTS.lm_ots_generate_signature(lMOtsPrivateKey, byArray, false);
        int n3 = (1 << n) + n2;
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int n4 = n3 / (1 << i) ^ 1;
            byArrayArray[i] = lMSPrivateKeyParameters.findT(n4);
        }
        return new LMSSignature(n2, lMOtsSignature, lMSigParameters, byArrayArray);
    }

    public static boolean verifySignature(LMSPublicKeyParameters lMSPublicKeyParameters, LMSSignature lMSSignature, byte[] byArray) {
        byte[] byArray2 = LMS.algorithm6a(lMSSignature, lMSPublicKeyParameters.refI(), lMSPublicKeyParameters.getOtsParameters().getType(), byArray);
        return lMSPublicKeyParameters.matchesT1(byArray2);
    }

    public static byte[] algorithm6a(LMSSignature lMSSignature, byte[] byArray, int n, byte[] byArray2) {
        int n2 = lMSSignature.getQ();
        if (lMSSignature.getOtsSignature().getType().getType() != n) {
            throw new IllegalArgumentException("ots type from lsm signature does not match ots signature type from embedded ots signature");
        }
        LMSigParameters lMSigParameters = lMSSignature.getParameter();
        int n3 = lMSigParameters.getM();
        int n4 = lMSigParameters.getH();
        byte[][] byArray3 = lMSSignature.getY();
        byte[] byArray4 = LM_OTS.lm_ots_validate_signature_calculate(LMOtsParameters.getParametersForType(n), byArray, n2, lMSSignature.getOtsSignature(), byArray2, false);
        int n5 = (1 << n4) + n2;
        Digest digest = DigestUtil.getDigest(lMSigParameters.getDigestOID());
        byte[] byArray5 = new byte[digest.getDigestSize()];
        digest.update(byArray, 0, byArray.length);
        LmsUtils.u32str(n5, digest);
        LmsUtils.u16str((short)-32126, digest);
        digest.update(byArray4, 0, byArray4.length);
        digest.doFinal(byArray5, 0);
        int n6 = 0;
        while (n5 > 1) {
            if ((n5 & 1) == 1) {
                digest.update(byArray, 0, byArray.length);
                LmsUtils.u32str(n5 / 2, digest);
                LmsUtils.u16str((short)-31869, digest);
                digest.update(byArray3[n6], 0, byArray3[n6].length);
                digest.update(byArray5, 0, byArray5.length);
                digest.doFinal(byArray5, 0);
            } else {
                digest.update(byArray, 0, byArray.length);
                LmsUtils.u32str(n5 / 2, digest);
                LmsUtils.u16str((short)-31869, digest);
                digest.update(byArray5, 0, byArray5.length);
                digest.update(byArray3[n6], 0, byArray3[n6].length);
                digest.doFinal(byArray5, 0);
            }
            n5 /= 2;
            ++n6;
        }
        return byArray5;
    }
}

