/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.weibo.WeiboProfileDefinition;
import org.pac4j.scribe.builder.api.WeiboApi20;

public class WeiboClient
extends OAuth20Client {
    protected WeiboScope scope = WeiboScope.EMAIL;
    protected String scopeValue;

    public WeiboClient() {
    }

    public WeiboClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit() {
        CommonHelper.assertNotNull((String)"scope", (Object)((Object)this.scope));
        if (this.scope == null) {
            this.scope = WeiboScope.EMAIL;
        }
        this.scopeValue = this.scope.toString().toLowerCase();
        this.configuration.setApi(new WeiboApi20());
        this.configuration.setScope(this.scopeValue);
        this.configuration.setProfileDefinition(new WeiboProfileDefinition());
        this.configuration.setWithState(true);
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String error = ctx.getRequestParameter("error").orElse(null);
            if ("access_denied".equals(error)) {
                return true;
            }
            return false;
        });
        super.clientInit();
    }

    public WeiboScope getScope() {
        return this.scope;
    }

    public void setScope(WeiboScope scope) {
        this.scope = scope;
    }

    public static enum WeiboScope {
        ALL,
        EMAIL,
        DIRECT_MESSAGES_WRITE,
        DIRECT_MESSAGES_READ,
        INVITATION_WRITE,
        FRIENDSHIPS_GROUPS_READ,
        FRIENDSHIPS_GROUPS_WRITE,
        STATUSES_TO_ME_READ,
        FOLLOW_APP_OFFICIAL_MICROBLOG;

    }
}

