/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.RemoteAliasServiceProvider;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AbstractAliasService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.util.PasswordUtils;

public class RemoteAliasService
extends AbstractAliasService {
    public static final String REMOTE_ALIAS_SERVICE_TYPE = "type";
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private final AliasService localAliasService;
    private final MasterService ms;
    private AliasService remoteAliasServiceImpl;

    public RemoteAliasService(AliasService localAliasService, MasterService ms) {
        this.localAliasService = localAliasService;
        this.ms = ms;
    }

    public List<String> getAliasesForCluster(String clusterName) throws AliasServiceException {
        List localAliases;
        ArrayList<String> remoteAliases = new ArrayList();
        if (this.remoteAliasServiceImpl != null) {
            remoteAliases = this.remoteAliasServiceImpl.getAliasesForCluster(clusterName);
        }
        if ((localAliases = this.localAliasService.getAliasesForCluster(clusterName)) != null) {
            for (String alias : localAliases) {
                if (remoteAliases.contains(alias.toLowerCase(Locale.ROOT))) continue;
                remoteAliases.add(alias);
            }
        }
        return remoteAliases;
    }

    public void addAliasForCluster(String clusterName, String givenAlias, String value) throws AliasServiceException {
        this.addAliasesForCluster(clusterName, Collections.singletonMap(givenAlias, value));
    }

    public void addAliasesForCluster(String clusterName, Map<String, String> credentials) throws AliasServiceException {
        HashMap<String, String> loweredCredentials = new HashMap<String, String>();
        for (Map.Entry<String, String> credential : credentials.entrySet()) {
            loweredCredentials.put(credential.getKey().toLowerCase(Locale.ROOT), credential.getValue());
        }
        this.localAliasService.addAliasesForCluster(clusterName, loweredCredentials);
        if (this.remoteAliasServiceImpl != null) {
            this.remoteAliasServiceImpl.addAliasesForCluster(clusterName, loweredCredentials);
        }
    }

    public void removeAliasForCluster(String clusterName, String givenAlias) throws AliasServiceException {
        this.removeAliasesForCluster(clusterName, Collections.singleton(givenAlias));
    }

    public void removeAliasesForCluster(String clusterName, Set<String> aliases) throws AliasServiceException {
        HashSet<String> loweredAliases = new HashSet<String>();
        for (String alias : aliases) {
            loweredAliases.add(alias.toLowerCase(Locale.ROOT));
        }
        this.localAliasService.removeAliasesForCluster(clusterName, loweredAliases);
        if (this.remoteAliasServiceImpl != null) {
            this.remoteAliasServiceImpl.removeAliasesForCluster(clusterName, loweredAliases);
        }
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster(clusterName, alias, false);
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String givenAlias, boolean generate) throws AliasServiceException {
        String alias = givenAlias.toLowerCase(Locale.ROOT);
        if (generate) {
            this.generateAliasForCluster(clusterName, alias);
        }
        char[] password = null;
        if (this.remoteAliasServiceImpl != null) {
            password = this.remoteAliasServiceImpl.getPasswordFromAliasForCluster(clusterName, alias);
        }
        if (password == null) {
            password = this.localAliasService.getPasswordFromAliasForCluster(clusterName, alias);
        }
        return password;
    }

    public void generateAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        String passwordString = PasswordUtils.generatePassword((int)16);
        this.addAliasForCluster(clusterName, alias, passwordString);
    }

    public char[] getPasswordFromAliasForGateway(String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster("__gateway", alias);
    }

    public char[] getGatewayIdentityPassphrase() throws AliasServiceException {
        char[] password = null;
        if (this.remoteAliasServiceImpl != null) {
            password = this.remoteAliasServiceImpl.getGatewayIdentityPassphrase();
        }
        if (password == null) {
            password = this.localAliasService.getGatewayIdentityPassphrase();
        }
        return password;
    }

    public char[] getGatewayIdentityKeystorePassword() throws AliasServiceException {
        char[] password = null;
        if (this.remoteAliasServiceImpl != null) {
            password = this.remoteAliasServiceImpl.getGatewayIdentityKeystorePassword();
        }
        if (password == null) {
            password = this.localAliasService.getGatewayIdentityKeystorePassword();
        }
        return password;
    }

    public char[] getSigningKeyPassphrase() throws AliasServiceException {
        char[] password = null;
        if (this.remoteAliasServiceImpl != null) {
            password = this.remoteAliasServiceImpl.getSigningKeyPassphrase();
        }
        if (password == null) {
            password = this.localAliasService.getSigningKeyPassphrase();
        }
        return password;
    }

    public char[] getSigningKeystorePassword() throws AliasServiceException {
        char[] password = null;
        if (this.remoteAliasServiceImpl != null) {
            password = this.remoteAliasServiceImpl.getSigningKeystorePassword();
        }
        if (password == null) {
            password = this.localAliasService.getSigningKeystorePassword();
        }
        return password;
    }

    public void generateAliasForGateway(String alias) throws AliasServiceException {
        this.generateAliasForCluster("__gateway", alias);
    }

    public Certificate getCertificateForGateway(String alias) throws AliasServiceException {
        return this.localAliasService.getCertificateForGateway(alias);
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        Map remoteAliasServiceConfigs = config.getRemoteAliasServiceConfiguration();
        if (config.isRemoteAliasServiceEnabled() && remoteAliasServiceConfigs != null) {
            String remoteAliasServiceType = (String)remoteAliasServiceConfigs.get(REMOTE_ALIAS_SERVICE_TYPE);
            ServiceLoader<RemoteAliasServiceProvider> providers = ServiceLoader.load(RemoteAliasServiceProvider.class);
            for (RemoteAliasServiceProvider provider : providers) {
                if (!provider.getType().equalsIgnoreCase(remoteAliasServiceType)) continue;
                LOG.remoteAliasServiceEnabled();
                this.remoteAliasServiceImpl = provider.newInstance(this.localAliasService, this.ms);
                this.remoteAliasServiceImpl.init(config, options);
                break;
            }
        } else {
            LOG.remoteAliasServiceDisabled();
        }
    }

    public void start() throws ServiceLifecycleException {
        if (this.remoteAliasServiceImpl != null) {
            this.remoteAliasServiceImpl.start();
        }
    }

    public void stop() throws ServiceLifecycleException {
        if (this.remoteAliasServiceImpl != null) {
            this.remoteAliasServiceImpl.stop();
        }
    }
}

