/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.builder.property.interpreter;

import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.builder.property.interpreter.AbstractInterpreter;
import org.apache.knox.gateway.topology.builder.property.interpreter.InterpretException;
import org.apache.knox.gateway.topology.builder.property.interpreter.ProviderParameterPropertyInterpreter;

public class ProviderPropertyInterpreter
extends AbstractInterpreter {
    private static final String PROVIDER_ENABLED = "enabled";
    private static final String AGGREGATOR_PARAM = "param";
    private static GatewayResources gatewayResources = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private Topology topology;

    public ProviderPropertyInterpreter(Topology topology) {
        if (topology == null) {
            throw new IllegalArgumentException(gatewayResources.topologyIsRequiredError());
        }
        this.topology = topology;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void interpret(String token, String value) throws InterpretException {
        String nextToken;
        int dotPosition = token.indexOf(".");
        if (dotPosition == -1) {
            throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
        }
        String providerRole = token.substring(0, dotPosition);
        if (providerRole != null && providerRole.isEmpty()) {
            providerRole = null;
        }
        if ((dotPosition = (nextToken = token.substring(dotPosition + 1)).indexOf(".")) == -1) {
            throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
        }
        String providerName = nextToken.substring(0, dotPosition);
        if (providerName != null && providerName.isEmpty()) {
            providerName = null;
        }
        nextToken = nextToken.substring(dotPosition + 1);
        Provider provider = this.topology.getProvider(providerRole, providerName);
        if (provider == null) {
            provider = new Provider();
            provider.setName(providerName);
            provider.setRole(providerRole);
            this.topology.addProvider(provider);
        }
        if (PROVIDER_ENABLED.equalsIgnoreCase(nextToken)) {
            provider.setEnabled(Boolean.valueOf(value).booleanValue());
            return;
        } else {
            dotPosition = nextToken.indexOf(".");
            if (dotPosition == -1) throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
            String aggregator = nextToken.substring(0, dotPosition);
            nextToken = nextToken.substring(dotPosition + 1);
            if (!AGGREGATOR_PARAM.equalsIgnoreCase(aggregator)) throw new InterpretException(gatewayResources.unsupportedPropertyTokenError(token));
            new ProviderParameterPropertyInterpreter(provider).interpret(nextToken, value);
        }
    }
}

