/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control;

import org.ldaptive.ad.control.DirSyncControl;
import org.ldaptive.ad.control.GetStatsControl;
import org.ldaptive.control.AbstractControl;
import org.ldaptive.control.AuthorizationIdentityResponseControl;
import org.ldaptive.control.EntryChangeNotificationControl;
import org.ldaptive.control.PagedResultsControl;
import org.ldaptive.control.PasswordExpiredControl;
import org.ldaptive.control.PasswordExpiringControl;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.control.SortResponseControl;
import org.ldaptive.control.SyncDoneControl;
import org.ldaptive.control.SyncStateControl;
import org.ldaptive.control.VirtualListViewResponseControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ControlFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlFactory.class);

    private ControlFactory() {
    }

    public static ResponseControl createResponseControl(String oid, boolean critical, byte[] encoded) {
        AbstractControl ctl = null;
        if ("1.2.840.113556.1.4.474".equals(oid)) {
            ctl = new SortResponseControl(critical);
            ctl.decode(encoded);
        } else if ("1.2.840.113556.1.4.319".equals(oid)) {
            ctl = new PagedResultsControl(critical);
            ctl.decode(encoded);
        } else if ("2.16.840.1.113730.3.4.10".equals(oid)) {
            ctl = new VirtualListViewResponseControl(critical);
            ctl.decode(encoded);
        } else if ("1.3.6.1.4.1.42.2.27.8.5.1".equals(oid)) {
            ctl = new PasswordPolicyControl(critical);
            ctl.decode(encoded);
        } else if ("1.3.6.1.4.1.4203.1.9.1.2".equals(oid)) {
            ctl = new SyncStateControl(critical);
            ctl.decode(encoded);
        } else if ("1.3.6.1.4.1.4203.1.9.1.3".equals(oid)) {
            ctl = new SyncDoneControl(critical);
            ctl.decode(encoded);
        } else if ("1.2.840.113556.1.4.841".equals(oid)) {
            ctl = new DirSyncControl(critical);
            ctl.decode(encoded);
        } else if ("2.16.840.1.113730.3.4.7".equals(oid)) {
            ctl = new EntryChangeNotificationControl(critical);
            ctl.decode(encoded);
        } else if ("1.2.840.113556.1.4.970".equals(oid)) {
            ctl = new GetStatsControl(critical);
            ctl.decode(encoded);
        } else if ("2.16.840.1.113730.3.4.4".equals(oid)) {
            ctl = new PasswordExpiredControl(critical);
            ctl.decode(encoded);
        } else if ("2.16.840.1.113730.3.4.5".equals(oid)) {
            ctl = new PasswordExpiringControl(critical);
            ctl.decode(encoded);
        } else if ("2.16.840.1.113730.3.4.15".equals(oid)) {
            ctl = new AuthorizationIdentityResponseControl(critical);
            ctl.decode(encoded);
        } else {
            LOGGER.debug("Unsupported response control OID {}", (Object)oid);
        }
        return ctl;
    }
}

