/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.HTTPMethod;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A single element of a batch request, often part of a list with other elements.")
public class ApiBatchRequestElement {
    @SerializedName(value="method")
    private HTTPMethod method = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="body")
    private Object body = null;
    @SerializedName(value="contentType")
    private String contentType = null;
    @SerializedName(value="acceptType")
    private String acceptType = null;

    public ApiBatchRequestElement method(HTTPMethod method) {
        this.method = method;
        return this;
    }

    @Schema(description="")
    public HTTPMethod getMethod() {
        return this.method;
    }

    public void setMethod(HTTPMethod method) {
        this.method = method;
    }

    public ApiBatchRequestElement url(String url) {
        this.url = url;
        return this;
    }

    @Schema(description="The URL of the request. Must not have a scheme, host, or port. The path should be prefixed with \"/api/\", and should include path and query parameters.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ApiBatchRequestElement body(Object body) {
        this.body = body;
        return this;
    }

    @Schema(description="Optional body of the request. Must be serialized in accordance with #getContentType(). For application/json, use com.cloudera.api.ApiObjectMapper.")
    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public ApiBatchRequestElement contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Schema(description="Content-Type header of the request element. If unset, the element will be treated as if the wildcard type had been specified unless it has a body, in which case it will fall back to application/json.")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ApiBatchRequestElement acceptType(String acceptType) {
        this.acceptType = acceptType;
        return this;
    }

    @Schema(description="Accept header of the request element. The response body (if it exists) will be in this representation. If unset, the element will be treated as if the wildcard type had been requested.")
    public String getAcceptType() {
        return this.acceptType;
    }

    public void setAcceptType(String acceptType) {
        this.acceptType = acceptType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiBatchRequestElement apiBatchRequestElement = (ApiBatchRequestElement)o;
        return Objects.equals((Object)this.method, (Object)apiBatchRequestElement.method) && Objects.equals(this.url, apiBatchRequestElement.url) && Objects.equals(this.body, apiBatchRequestElement.body) && Objects.equals(this.contentType, apiBatchRequestElement.contentType) && Objects.equals(this.acceptType, apiBatchRequestElement.acceptType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.url, this.body, this.contentType, this.acceptType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiBatchRequestElement {\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    acceptType: ").append(this.toIndentedString(this.acceptType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

