/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.phonetic;

import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.PhoneticEngine;
import org.apache.commons.codec.language.bm.RuleType;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.phonetic.BeiderMorseFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class BeiderMorseFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "beiderMorse";
    private final PhoneticEngine engine;
    private final Languages.LanguageSet languageSet;

    public BeiderMorseFilterFactory(Map<String, String> args) {
        super(args);
        NameType nameType = NameType.valueOf((String)this.get(args, "nameType", NameType.GENERIC.toString()));
        RuleType ruleType = RuleType.valueOf((String)this.get(args, "ruleType", RuleType.APPROX.toString()));
        boolean concat = this.getBoolean(args, "concat", true);
        this.engine = new PhoneticEngine(nameType, ruleType, concat);
        Set langs = this.getSet(args, "languageSet");
        Languages.LanguageSet languageSet = this.languageSet = null == langs || 1 == langs.size() && langs.contains("auto") ? null : Languages.LanguageSet.from((Set)langs);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public TokenStream create(TokenStream input) {
        return new BeiderMorseFilter(input, this.engine, this.languageSet);
    }
}

