/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAllowableActionsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisContentStreamType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRenditionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteTreeResponse;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumUnfileObject;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumVersioningState;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectServicePort;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectServiceImpl
extends AbstractWebServicesService
implements ObjectService {
    private final AbstractPortProvider portProvider;

    public ObjectServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "createDocument");
        try {
            Holder objectId = new Holder();
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.createDocument(repositoryId, WSConverter.convert((Properties)properties), folderId, WSConverter.convert((ContentStream)contentStream, (boolean)false), (EnumVersioningState)WSConverter.convert(EnumVersioningState.class, (Enum)versioningState), policies, WSConverter.convert((Acl)addACEs), WSConverter.convert((Acl)removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "createDocumentFromSource");
        try {
            Holder objectId = new Holder();
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.createDocumentFromSource(repositoryId, sourceId, WSConverter.convert((Properties)properties), folderId, (EnumVersioningState)WSConverter.convert(EnumVersioningState.class, (Enum)versioningState), policies, WSConverter.convert((Acl)addACEs), WSConverter.convert((Acl)removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "createFolder");
        try {
            Holder objectId = new Holder();
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.createFolder(repositoryId, WSConverter.convert((Properties)properties), folderId, policies, WSConverter.convert((Acl)addACEs), WSConverter.convert((Acl)removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "createPolicy");
        try {
            Holder objectId = new Holder();
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.createPolicy(repositoryId, WSConverter.convert((Properties)properties), folderId, policies, WSConverter.convert((Acl)addACEs), WSConverter.convert((Acl)removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        ObjectServicePort port = this.portProvider.getObjectServicePort(CmisVersion.CMIS_1_1, "createItem");
        try {
            Holder objectId = new Holder();
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.createItem(repositoryId, WSConverter.convert((Properties)properties), folderId, WSConverter.convert((Acl)addACEs), WSConverter.convert((Acl)removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "createRelationship");
        try {
            Holder objectId = new Holder();
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.createRelationship(repositoryId, WSConverter.convert((Properties)properties), policies, WSConverter.convert((Acl)addACEs), WSConverter.convert((Acl)removeACEs), portExtension, objectId);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void updateProperties(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "updateProperties");
        try {
            Holder portObjectId = WSConverter.convertHolder(objectId);
            Holder portChangeToken = WSConverter.convertHolder(changeToken);
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.updateProperties(repositoryId, portObjectId, portChangeToken, WSConverter.convert((Properties)properties), portExtension);
            WSConverter.setHolderValue((Holder)portObjectId, objectId);
            WSConverter.setHolderValue((Holder)portChangeToken, changeToken);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        ObjectServicePort port = this.portProvider.getObjectServicePort(CmisVersion.CMIS_1_1, "bulkUpdateProperties");
        try {
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            Holder bulkUpdateResponse = new Holder();
            port.bulkUpdateProperties(repositoryId, WSConverter.convert(objectIdAndChangeToken, (Properties)properties, addSecondaryTypeIds, removeSecondaryTypeIds), portExtension, bulkUpdateResponse);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            List<BulkUpdateObjectIdAndChangeToken> result = null;
            if (bulkUpdateResponse.value != null) {
                // empty if block
            }
            List<BulkUpdateObjectIdAndChangeToken> list = result;
            return list;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "deleteObject");
        try {
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.deleteObject(repositoryId, objectId, allVersions, portExtension);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "deleteTree");
        try {
            FailedToDeleteData failedToDeleteData = WSConverter.convert((DeleteTreeResponse.FailedToDelete)port.deleteTree(repositoryId, folderId, allVersions, (EnumUnfileObject)WSConverter.convert(EnumUnfileObject.class, (Enum)unfileObjects), continueOnFailure, WSConverter.convert((ExtensionsData)extension)));
            return failedToDeleteData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getAllowableActions");
        try {
            AllowableActions allowableActions = WSConverter.convert((CmisAllowableActionsType)port.getAllowableActions(repositoryId, objectId, WSConverter.convert((ExtensionsData)extension)));
            return allowableActions;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getContentStream");
        try {
            boolean isPartial = false;
            if (offset != null && offset.signum() == 1 || length != null) {
                isPartial = true;
            }
            ContentStream contentStream = WSConverter.convert((CmisContentStreamType)port.getContentStream(repositoryId, objectId, streamId, offset, length, WSConverter.convert((ExtensionsData)extension)), (boolean)isPartial);
            return contentStream;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getObject");
        try {
            ObjectData objectData = WSConverter.convert((CmisObjectType)port.getObject(repositoryId, objectId, filter, includeAllowableActions, (EnumIncludeRelationships)WSConverter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeACL, WSConverter.convert((ExtensionsData)extension)));
            return objectData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getObjectByPath");
        try {
            ObjectData objectData = WSConverter.convert((CmisObjectType)port.getObjectByPath(repositoryId, path, filter, includeAllowableActions, (EnumIncludeRelationships)WSConverter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeACL, WSConverter.convert((ExtensionsData)extension)));
            return objectData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getProperties");
        try {
            Properties properties = WSConverter.convert((CmisPropertiesType)port.getProperties(repositoryId, objectId, filter, WSConverter.convert((ExtensionsData)extension)));
            return properties;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "getRenditions");
        try {
            List renditionList = port.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, WSConverter.convert((ExtensionsData)extension));
            if (renditionList == null) {
                List<RenditionData> list = null;
                return list;
            }
            ArrayList<RenditionData> result = new ArrayList<RenditionData>();
            for (CmisRenditionType rendition : renditionList) {
                result.add(WSConverter.convert((CmisRenditionType)rendition));
            }
            ArrayList<RenditionData> arrayList = result;
            return arrayList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void moveObject(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "moveObject");
        try {
            Holder portObjectId = WSConverter.convertHolder(objectId);
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.moveObject(repositoryId, portObjectId, targetFolderId, sourceFolderId, portExtension);
            WSConverter.setHolderValue((Holder)portObjectId, objectId);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void setContentStream(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, Boolean overwriteFlag, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "setContentStream");
        try {
            Holder portObjectId = WSConverter.convertHolder(objectId);
            Holder portChangeToken = WSConverter.convertHolder(changeToken);
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.setContentStream(repositoryId, portObjectId, overwriteFlag, portChangeToken, WSConverter.convert((ContentStream)contentStream, (boolean)false), portExtension);
            WSConverter.setHolderValue((Holder)portObjectId, objectId);
            WSConverter.setHolderValue((Holder)portChangeToken, changeToken);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void deleteContentStream(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort(this.getCmisVersion(repositoryId), "deleteContentStream");
        try {
            Holder portObjectId = WSConverter.convertHolder(objectId);
            Holder portChangeToken = WSConverter.convertHolder(changeToken);
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.deleteContentStream(repositoryId, portObjectId, portChangeToken, portExtension);
            WSConverter.setHolderValue((Holder)portObjectId, objectId);
            WSConverter.setHolderValue((Holder)portChangeToken, changeToken);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void appendContentStream(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        ObjectServicePort port = this.portProvider.getObjectServicePort(CmisVersion.CMIS_1_1, "appendContentStream");
        try {
            Holder portObjectId = WSConverter.convertHolder(objectId);
            Holder portChangeToken = WSConverter.convertHolder(changeToken);
            Holder portExtension = WSConverter.convertExtensionHolder((ExtensionsData)extension);
            port.appendContentStream(repositoryId, portObjectId, Boolean.valueOf(isLastChunk), portChangeToken, WSConverter.convert((ContentStream)contentStream, (boolean)false), portExtension);
            WSConverter.setHolderValue((Holder)portObjectId, objectId);
            WSConverter.setHolderValue((Holder)portChangeToken, changeToken);
            WSConverter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

