/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine.tests;

import org.apache.manifoldcf.scriptengine.VariableFloat;
import org.apache.manifoldcf.scriptengine.VariableInt;
import org.apache.manifoldcf.scriptengine.VariableReference;
import org.apache.manifoldcf.scriptengine.VariableString;
import org.apache.manifoldcf.scriptengine.VariableURL;
import org.apache.manifoldcf.scriptengine.tests.ScriptEngineBase;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionTest
extends ScriptEngineBase {
    @Test
    public void basicIntOperations() throws Exception {
        VariableReference vr = this.evaluateExpression("1+2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)3L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("1-2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)-1L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("2*3");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)6L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("3/2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)1L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("-2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)-2L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("1&5");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)1L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("1|2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)3L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("!2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)0L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("1>1");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("2>1");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("0>=1");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1>=1");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("2<2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1<2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("2<=1");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1<=1");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1==2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1==1");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1!=1");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1!=2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("2 .__int__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)2L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("2 .__string__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"2", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("2 .__float__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((double)2.0, (double)vr.resolve().getDoubleValue(), (double)0.0);
        vr = this.evaluateExpression("2 .__script__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"2", (Object)vr.resolve().getStringValue());
        Assert.assertEquals((long)2L, (long)new VariableInt(2).getIntValue());
        Assert.assertEquals((Object)"2", (Object)new VariableInt(2).getStringValue());
        Assert.assertEquals((double)2.0, (double)new VariableInt(2).getDoubleValue(), (double)0.0);
    }

    @Test
    public void basicFloatOperations() throws Exception {
        VariableReference vr = this.evaluateExpression("1.0+2.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((double)3.0, (double)vr.resolve().getDoubleValue(), (double)0.0);
        vr = this.evaluateExpression("1.0-2.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((double)-1.0, (double)vr.resolve().getDoubleValue(), (double)0.0);
        vr = this.evaluateExpression("2.0*3.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((double)6.0, (double)vr.resolve().getDoubleValue(), (double)0.0);
        vr = this.evaluateExpression("3.0/2.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((double)1.5, (double)vr.resolve().getDoubleValue(), (double)0.0);
        vr = this.evaluateExpression("-2.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((double)-2.0, (double)vr.resolve().getDoubleValue(), (double)0.0);
        vr = this.evaluateExpression("1.0>1.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("2.0>1.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("0.0>=1.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1.0>=1.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("2.0<2.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1.0<2.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("2.0<=1.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1.0<=1.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1.0==2.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1.0==1.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1.0!=1.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("1.0!=2.0");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("2.0 .__int__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)2L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("2.0 .__string__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"2.0", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("2.0 .__float__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((double)2.0, (double)vr.resolve().getDoubleValue(), (double)0.0);
        vr = this.evaluateExpression("2.0 .__script__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"2.0", (Object)vr.resolve().getStringValue());
        Assert.assertEquals((long)2L, (long)new VariableFloat(2.0).getIntValue());
        Assert.assertEquals((Object)"2.0", (Object)new VariableFloat(2.0).getStringValue());
        Assert.assertEquals((double)2.0, (double)new VariableFloat(2.0).getDoubleValue(), (double)0.0);
    }

    @Test
    public void basicBooleanOperations() throws Exception {
        VariableReference vr = this.evaluateExpression("true&false");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("true|false");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("true&&false");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("true||false");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("!true");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("true==false");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("true==true");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("true!=true");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("true!=false");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("true .__script__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"true", (Object)vr.resolve().getStringValue());
    }

    @Test
    public void basicStringOperations() throws Exception {
        VariableReference vr = this.evaluateExpression("'1'+'2'");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"12", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("'1'=='2'");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("'1'=='1'");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("'1'!='1'");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("'1'!='2'");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("'2'.__int__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)2L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("'2'.__string__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"2", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("'2'.__float__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((double)2.0, (double)vr.resolve().getDoubleValue(), (double)0.0);
        vr = this.evaluateExpression("'2'.__script__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"\"2\"", (Object)vr.resolve().getStringValue());
        Assert.assertEquals((long)2L, (long)new VariableString("2").getIntValue());
        Assert.assertEquals((Object)"2", (Object)new VariableString("2").getStringValue());
        Assert.assertEquals((double)2.0, (double)new VariableString("2").getDoubleValue(), (double)0.0);
    }

    @Test
    public void basicURLOperations() throws Exception {
        VariableReference vr = this.evaluateExpression("(new url 'http://localhost:8345/mcf-api-service/json') + 'jobs' + '123'");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"http://localhost:8345/mcf-api-service/json/jobs/123", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("(new url 'hello')==(new url 'there')");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("(new url 'hello')==(new url 'hello')");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("(new url 'hello')!=(new url 'hello')");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)false, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("(new url 'hello')!=(new url 'there')");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)true, (Object)vr.resolve().getBooleanValue());
        vr = this.evaluateExpression("((new url 'abc') + 'def ghi').__string__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"abc/def%20ghi", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("(new url 'abc').__script__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"\"abc\"", (Object)vr.resolve().getStringValue());
        Assert.assertEquals((Object)"abc", (Object)new VariableURL("abc").getStringValue());
        vr = this.evaluateExpression("((new url 'hello') + (new connectionname 'there/guys.')).__string__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"hello/there.%2Bguys..", (Object)vr.resolve().getStringValue());
    }

    @Test
    public void basicArrayOperations() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.executeStatements("set x = [1,'2',3];"));
        VariableReference vr = this.evaluateExpression("x[2]");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)3L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("x.__script__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"[ 1, \"2\", 3 ]", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x.__size__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)3L, (long)vr.resolve().getIntValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("insert 'tail' into x;"));
        vr = this.evaluateExpression("x[3]");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"tail", (Object)vr.resolve().getStringValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("insert 'head' into x at 0;"));
        vr = this.evaluateExpression("x[1]");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)1L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("x.__size__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)5L, (long)vr.resolve().getIntValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("remove 1 from x;"));
        vr = this.evaluateExpression("x[1]");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"2", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x[0]");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"head", (Object)vr.resolve().getStringValue());
    }

    @Test
    public void basicDictOperations() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.executeStatements("set x = new dictionary; set x['a'] = 1; set x['b'] = 2;"));
        VariableReference vr = this.evaluateExpression("x['a']");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)1L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("x.__size__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)2L, (long)vr.resolve().getIntValue());
    }

    @Test
    public void basicConfigurationnodeOperations() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.executeStatements("set x = << 'type' : 'value' : 'attr1' = 'av1', 'attr2' = 'av2' : << 'child1' : 'cv1' : : >>, << 'child2' : 'cv2' : : >> >>;"));
        VariableReference vr = this.evaluateExpression("x[0].__type__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"child1", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x[0].__value__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"cv1", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x.__size__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)2L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("x.__dict__['child1'].__value__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"cv1", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x.attr1");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"av1", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x.attr2");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"av2", (Object)vr.resolve().getStringValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("insert << 'child3' : 'cv3' : : >> into x;"));
        vr = this.evaluateExpression("x[2].__type__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"child3", (Object)vr.resolve().getStringValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("insert << 'childn1' : 'cvn1' : : >> into x at 0;"));
        vr = this.evaluateExpression("x[1].__type__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"child1", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x.__size__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)4L, (long)vr.resolve().getIntValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("remove 1 from x;"));
        vr = this.evaluateExpression("x[1].__type__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"child2", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x[0].__type__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"childn1", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x.__script__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"<< \"type\" : \"value\" : \"attr1\"=\"av1\", \"attr2\"=\"av2\" : << \"childn1\" : \"cvn1\" :  :  >>, << \"child2\" : \"cv2\" :  :  >>, << \"child3\" : \"cv3\" :  :  >> >>", (Object)vr.resolve().getStringValue());
    }

    @Test
    public void basicConfigurationOperations() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.executeStatements("set x = {<< 'child1' : 'cv1' : : >>, << 'child2' : 'cv2' : : >>};"));
        VariableReference vr = this.evaluateExpression("x[0].__type__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"child1", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x[0].__value__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"cv1", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x.__size__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)2L, (long)vr.resolve().getIntValue());
        vr = this.evaluateExpression("x.__dict__['child1'].__value__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"cv1", (Object)vr.resolve().getStringValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("insert << 'child3' : 'cv3' : : >> into x;"));
        vr = this.evaluateExpression("x[2].__type__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"child3", (Object)vr.resolve().getStringValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("insert << 'childn1' : 'cvn1' : : >> into x at 0;"));
        vr = this.evaluateExpression("x[1].__type__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"child1", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x.__size__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((long)4L, (long)vr.resolve().getIntValue());
        Assert.assertEquals((Object)false, (Object)this.executeStatements("remove 1 from x;"));
        vr = this.evaluateExpression("x[1].__type__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"child2", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x[0].__type__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"childn1", (Object)vr.resolve().getStringValue());
        vr = this.evaluateExpression("x.__script__");
        Assert.assertNotNull((Object)vr);
        Assert.assertEquals((Object)"{ << \"childn1\" : \"cvn1\" :  :  >>, << \"child2\" : \"cv2\" :  :  >>, << \"child3\" : \"cv3\" :  :  >> }", (Object)vr.resolve().getStringValue());
    }
}

