/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.elasticsearch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.manifoldcf.elasticsearch.MCFAuthorizerException;
import org.apache.manifoldcf.elasticsearch.MCFConfigurationParameters;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.TermFilterBuilder;

public class MCFAuthorizer {
    public static final String NOSECURITY_TOKEN = "__nosecurity__";
    private static final ESLogger LOG = Loggers.getLogger(MCFAuthorizer.class);
    protected final String authorityBaseURL;
    protected final String fieldAllowDocument;
    protected final String fieldDenyDocument;
    protected final String fieldAllowParent;
    protected final String fieldDenyParent;
    protected final String fieldAllowShare;
    protected final String fieldDenyShare;
    protected final int connectionTimeout;
    protected final int socketTimeout;
    protected final int poolSize;
    protected final ClientConnectionManager connectionManager;
    protected final HttpClient httpClient;

    public MCFAuthorizer(MCFConfigurationParameters cp) {
        this.authorityBaseURL = cp.authorityServiceBaseURL;
        this.fieldAllowDocument = cp.allowFieldPrefix + "document";
        this.fieldDenyDocument = cp.denyFieldPrefix + "document";
        this.fieldAllowShare = cp.allowFieldPrefix + "share";
        this.fieldDenyShare = cp.denyFieldPrefix + "share";
        this.fieldAllowParent = cp.allowFieldPrefix + "parent";
        this.fieldDenyParent = cp.denyFieldPrefix + "parent";
        this.connectionTimeout = cp.connectionTimeout;
        this.socketTimeout = cp.socketTimeout;
        this.poolSize = cp.connectionPoolSize;
        if (this.authorityBaseURL != null) {
            PoolingClientConnectionManager localConnectionManager = new PoolingClientConnectionManager();
            localConnectionManager.setMaxTotal(this.poolSize);
            localConnectionManager.setDefaultMaxPerRoute(this.poolSize);
            this.connectionManager = localConnectionManager;
            BasicHttpParams params = new BasicHttpParams();
            params.setBooleanParameter("http.tcp.nodelay", true);
            params.setBooleanParameter("http.connection.stalecheck", true);
            params.setIntParameter("http.socket.timeout", this.socketTimeout);
            params.setIntParameter("http.connection.timeout", this.connectionTimeout);
            DefaultHttpClient localClient = new DefaultHttpClient(this.connectionManager, (HttpParams)params);
            localClient.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
            this.httpClient = localClient;
        } else {
            this.connectionManager = null;
            this.httpClient = null;
        }
    }

    public void shutdown() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }

    public FilterBuilder buildAuthorizationFilter(String[] authenticatedUserNamesAndDomains) throws MCFAuthorizerException {
        HashMap<String, String> domainMap = new HashMap<String, String>();
        for (String buffer : authenticatedUserNamesAndDomains) {
            String[] authenticatedUserNameAndDomain = buffer.split(":", 2);
            String authenticatedUserName = authenticatedUserNameAndDomain[0];
            String authenticatedUserDomain = authenticatedUserNameAndDomain.length < 2 ? "" : authenticatedUserNameAndDomain[1];
            domainMap.put(authenticatedUserDomain, authenticatedUserName);
        }
        return this.buildAuthorizationFilter(domainMap);
    }

    public FilterBuilder buildAuthorizationFilter(Map<String, String> domainMap) throws MCFAuthorizerException {
        if (this.authorityBaseURL == null) {
            throw new IllegalStateException("Authority base URL required for finding access tokens for a user");
        }
        if (domainMap == null || domainMap.size() == 0) {
            throw new IllegalArgumentException("Cannot find user tokens for null user");
        }
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (String domain : domainMap.keySet()) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                sb.append(domain).append(":").append(domainMap.get(domain));
            }
            sb.append("]");
            LOG.info("Trying to match docs for user '" + sb.toString() + "'", new Object[0]);
        }
        return this.buildAuthorizationFilter(this.getAccessTokens(domainMap));
    }

    public FilterBuilder buildAuthorizationFilter(String authenticatedUserName) throws MCFAuthorizerException {
        return this.buildAuthorizationFilter(authenticatedUserName, "");
    }

    public FilterBuilder buildAuthorizationFilter(String authenticatedUserName, String authenticatedUserDomain) throws MCFAuthorizerException {
        HashMap<String, String> domainMap = new HashMap<String, String>();
        domainMap.put(authenticatedUserDomain, authenticatedUserName);
        return this.buildAuthorizationFilter(domainMap);
    }

    public FilterBuilder buildAuthorizationFilter(List<String> userAccessTokens) throws MCFAuthorizerException {
        BoolFilterBuilder bq = new BoolFilterBuilder();
        TermFilterBuilder allowShareOpen = new TermFilterBuilder(this.fieldAllowShare, NOSECURITY_TOKEN);
        TermFilterBuilder denyShareOpen = new TermFilterBuilder(this.fieldDenyShare, NOSECURITY_TOKEN);
        TermFilterBuilder allowParentOpen = new TermFilterBuilder(this.fieldAllowParent, NOSECURITY_TOKEN);
        TermFilterBuilder denyParentOpen = new TermFilterBuilder(this.fieldDenyParent, NOSECURITY_TOKEN);
        TermFilterBuilder allowDocumentOpen = new TermFilterBuilder(this.fieldAllowDocument, NOSECURITY_TOKEN);
        TermFilterBuilder denyDocumentOpen = new TermFilterBuilder(this.fieldDenyDocument, NOSECURITY_TOKEN);
        if (userAccessTokens == null || userAccessTokens.size() == 0) {
            bq.must((FilterBuilder)allowShareOpen);
            bq.must((FilterBuilder)denyShareOpen);
            bq.must((FilterBuilder)allowParentOpen);
            bq.must((FilterBuilder)denyParentOpen);
            bq.must((FilterBuilder)allowDocumentOpen);
            bq.must((FilterBuilder)denyDocumentOpen);
        } else {
            bq.must(MCFAuthorizer.calculateCompleteSubquery(this.fieldAllowShare, this.fieldDenyShare, (FilterBuilder)allowShareOpen, (FilterBuilder)denyShareOpen, userAccessTokens));
            bq.must(MCFAuthorizer.calculateCompleteSubquery(this.fieldAllowDocument, this.fieldDenyDocument, (FilterBuilder)allowDocumentOpen, (FilterBuilder)denyDocumentOpen, userAccessTokens));
            bq.must(MCFAuthorizer.calculateCompleteSubquery(this.fieldAllowParent, this.fieldDenyParent, (FilterBuilder)allowParentOpen, (FilterBuilder)denyParentOpen, userAccessTokens));
        }
        return bq;
    }

    protected static FilterBuilder calculateCompleteSubquery(String allowField, String denyField, FilterBuilder allowOpen, FilterBuilder denyOpen, List<String> userAccessTokens) {
        BoolFilterBuilder bq = new BoolFilterBuilder();
        BoolFilterBuilder subUnprotectedClause = new BoolFilterBuilder();
        subUnprotectedClause.must(allowOpen);
        subUnprotectedClause.must(denyOpen);
        bq.should((FilterBuilder)subUnprotectedClause);
        for (String accessToken : userAccessTokens) {
            bq.should((FilterBuilder)new TermFilterBuilder(allowField, accessToken));
            bq.mustNot((FilterBuilder)new TermFilterBuilder(denyField, accessToken));
        }
        return bq;
    }

    /*
     * Exception decompiling
     */
    protected List<String> getAccessTokens(Map<String, String> domainMap) throws MCFAuthorizerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

