/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;

public class Zip {
    private static final int BUF_SIZE = 16384;

    public static String zip(File input) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            try (ZipOutputStream zos = new ZipOutputStream(bos);){
                if (input.isDirectory()) {
                    Zip.addToZip(input.getAbsolutePath(), zos, input);
                } else {
                    Zip.addToZip(input.getParentFile().getAbsolutePath(), zos, input);
                }
            }
            String string = Base64.getEncoder().encodeToString(bos.toByteArray());
            return string;
        }
    }

    private static void addToZip(String basePath, ZipOutputStream zos, File toAdd) throws IOException {
        block15: {
            block14: {
                if (!toAdd.isDirectory()) break block14;
                File[] files = toAdd.listFiles();
                if (files == null) break block15;
                for (File file : files) {
                    Zip.addToZip(basePath, zos, file);
                }
                break block15;
            }
            try (FileInputStream fis = new FileInputStream(toAdd);){
                int len;
                String name = toAdd.getAbsolutePath().substring(basePath.length() + 1);
                ZipEntry entry = new ZipEntry(name.replace('\\', '/'));
                zos.putNextEntry(entry);
                byte[] buffer = new byte[4096];
                while ((len = fis.read(buffer)) != -1) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
            }
        }
    }

    public static File unzipToTempDir(String source, String prefix, String suffix) throws IOException {
        File output = TemporaryFilesystem.getDefaultTmpFS().createTempDir(prefix, suffix);
        Zip.unzip(source, output);
        return output;
    }

    public static void unzip(String source, File outputDir) throws IOException {
        byte[] bytes = Base64.getMimeDecoder().decode(source);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            Zip.unzip(bis, outputDir);
        }
    }

    public static File unzipToTempDir(InputStream source, String prefix, String suffix) throws IOException {
        File output = TemporaryFilesystem.getDefaultTmpFS().createTempDir(prefix, suffix);
        Zip.unzip(source, output);
        return output;
    }

    public static void unzip(InputStream source, File outputDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(source);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    FileHandler.createDir(file);
                    continue;
                }
                Zip.unzipFile(outputDir, zis, entry.getName());
            }
        }
    }

    public static void unzipFile(File output, InputStream zipStream, String name) throws IOException {
        File toWrite = new File(output, name);
        if (!FileHandler.createDir(toWrite.getParentFile())) {
            throw new IOException("Cannot create parent directory for: " + name);
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toWrite), 16384);){
            int read;
            byte[] buffer = new byte[16384];
            while ((read = zipStream.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
    }
}

