/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.util.SvnUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnCommandLineUtils {
    public static void addTarget(Commandline cl, List files) throws IOException {
        if (files == null || files.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        String ls = System.getProperty("line.separator");
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            sb.append(f.getPath().replace('\\', '/'));
            sb.append(ls);
        }
        File targets = File.createTempFile("maven-scm-", "-targets");
        PrintStream out = new PrintStream(new FileOutputStream(targets));
        out.print(sb.toString());
        out.flush();
        out.close();
        cl.createArg().setValue("--targets");
        cl.createArg().setValue(targets.getAbsolutePath());
        targets.deleteOnExit();
    }

    public static Commandline getBaseSvnCommandLine(File workingDirectory, SvnScmProviderRepository repository) {
        Commandline cl = new Commandline();
        cl.setExecutable("svn");
        try {
            cl.addSystemEnvironment();
            cl.addEnvironment("LC_MESSAGES", "C");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (workingDirectory != null) {
            cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        }
        if (!StringUtils.isEmpty((String)System.getProperty("maven.scm.svn.config_directory"))) {
            cl.createArg().setValue("--config-dir");
            cl.createArg().setValue(System.getProperty("maven.scm.svn.config_directory"));
        } else if (!StringUtils.isEmpty((String)SvnUtil.getSettings().getConfigDirectory())) {
            cl.createArg().setValue("--config-dir");
            cl.createArg().setValue(SvnUtil.getSettings().getConfigDirectory());
        }
        boolean hasAuthInfo = false;
        if (repository != null && !StringUtils.isEmpty((String)repository.getUser())) {
            hasAuthInfo = true;
            cl.createArg().setValue("--username");
            cl.createArg().setValue(repository.getUser());
        }
        if (repository != null && !StringUtils.isEmpty((String)repository.getPassword())) {
            hasAuthInfo = true;
            cl.createArg().setValue("--password");
            cl.createArg().setValue(repository.getPassword());
        }
        if (hasAuthInfo && !SvnUtil.getSettings().isUseAuthCache()) {
            cl.createArg().setValue("--no-auth-cache");
        }
        if (SvnUtil.getSettings().isUseNonInteractive()) {
            cl.createArg().setValue("--non-interactive");
        }
        return cl;
    }

    public static int execute(Commandline cl, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws CommandLineException {
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        exitCode = SvnCommandLineUtils.checkIfCleanUpIsNeeded(exitCode, cl, consumer, stderr, logger);
        return exitCode;
    }

    public static int execute(Commandline cl, CommandLineUtils.StringStreamConsumer stdout, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws CommandLineException {
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        exitCode = SvnCommandLineUtils.checkIfCleanUpIsNeeded(exitCode, cl, (StreamConsumer)stdout, stderr, logger);
        return exitCode;
    }

    private static int checkIfCleanUpIsNeeded(int exitCode, Commandline cl, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws CommandLineException {
        if (exitCode != 0 && stderr.getOutput() != null && stderr.getOutput().indexOf("'svn cleanup'") > 0 && stderr.getOutput().indexOf("'svn help cleanup'") > 0) {
            if (logger.isInfoEnabled()) {
                logger.info("Svn command failed due to some locks in working copy. We try to run a 'svn cleanup'.");
            }
            if (SvnCommandLineUtils.executeCleanUp(cl.getWorkingDirectory(), consumer, (StreamConsumer)stderr, logger) == 0) {
                exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
            }
        }
        return exitCode;
    }

    public static int executeCleanUp(File workinDirectory, StreamConsumer stdout, StreamConsumer stderr) throws CommandLineException {
        return SvnCommandLineUtils.executeCleanUp(workinDirectory, stdout, stderr, null);
    }

    public static int executeCleanUp(File workinDirectory, StreamConsumer stdout, StreamConsumer stderr, ScmLogger logger) throws CommandLineException {
        Commandline cl = new Commandline();
        cl.setExecutable("svn");
        cl.setWorkingDirectory(workinDirectory.getAbsolutePath());
        if (logger != null && logger.isInfoEnabled()) {
            logger.info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        return CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
    }

    public static String cryptPassword(Commandline cl) {
        String clString = cl.toString();
        int pos = clString.indexOf("--password");
        if (pos > 0) {
            String beforePassword = clString.substring(0, pos + "--password ".length());
            String afterPassword = clString.substring(pos + "--password ".length());
            afterPassword = afterPassword.substring(afterPassword.indexOf(" "));
            clString = Os.isFamily((String)"windows") ? beforePassword + "*****" + afterPassword : beforePassword + "'*****'" + afterPassword;
        }
        return clString;
    }
}

