/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.MSOffice;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.odf.NSNormalizerContentHandler;
import org.apache.tika.parser.xml.AttributeDependantMetadataHandler;
import org.apache.tika.parser.xml.AttributeMetadataHandler;
import org.apache.tika.parser.xml.ElementMetadataHandler;
import org.apache.tika.parser.xml.MetadataHandler;
import org.apache.tika.parser.xml.XMLParser;
import org.apache.tika.sax.TeeContentHandler;
import org.apache.tika.sax.xpath.CompositeMatcher;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OpenDocumentMetaParser
extends XMLParser {
    private static final long serialVersionUID = -8739250869531737584L;
    private static final String META_NS = "urn:oasis:names:tc:opendocument:xmlns:meta:1.0";
    private static final XPathParser META_XPATH = new XPathParser("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
    @Deprecated
    private static final Property TRANSITION_INITIAL_CREATOR_TO_INITIAL_AUTHOR = Property.composite((Property)Office.INITIAL_AUTHOR, (Property[])new Property[]{Property.externalText((String)"initial-creator")});

    private static ContentHandler getDublinCoreHandler(Metadata metadata, Property property, String element) {
        return new ElementMetadataHandler("http://purl.org/dc/elements/1.1/", element, metadata, property);
    }

    private static ContentHandler getMeta(ContentHandler ch, Metadata md, Property property, String element) {
        CompositeMatcher matcher = new CompositeMatcher(META_XPATH.parse("//meta:" + element), META_XPATH.parse("//meta:" + element + "//text()"));
        MatchingContentHandler branch = new MatchingContentHandler((ContentHandler)new MetadataHandler(md, property), (Matcher)matcher);
        return new TeeContentHandler(new ContentHandler[]{ch, branch});
    }

    private static ContentHandler getUserDefined(ContentHandler ch, Metadata md) {
        CompositeMatcher matcher = new CompositeMatcher(META_XPATH.parse("//meta:user-defined/@meta:name"), META_XPATH.parse("//meta:user-defined//text()"));
        MatchingContentHandler branch = new MatchingContentHandler((ContentHandler)new AttributeDependantMetadataHandler(md, "meta:name", "custom:"), (Matcher)matcher);
        return new TeeContentHandler(new ContentHandler[]{ch, branch});
    }

    @Deprecated
    private static ContentHandler getStatistic(ContentHandler ch, Metadata md, String name, String attribute) {
        Matcher matcher = META_XPATH.parse("//meta:document-statistic/@meta:" + attribute);
        MatchingContentHandler branch = new MatchingContentHandler((ContentHandler)new AttributeMetadataHandler(META_NS, attribute, md, name), matcher);
        return new TeeContentHandler(new ContentHandler[]{ch, branch});
    }

    private static ContentHandler getStatistic(ContentHandler ch, Metadata md, Property property, String attribute) {
        Matcher matcher = META_XPATH.parse("//meta:document-statistic/@meta:" + attribute);
        MatchingContentHandler branch = new MatchingContentHandler((ContentHandler)new AttributeMetadataHandler(META_NS, attribute, md, property), matcher);
        return new TeeContentHandler(new ContentHandler[]{ch, branch});
    }

    static ContentHandler getContentHandler(Metadata md, ParseContext context, ContentHandler ... handlers) {
        Object ch = new TeeContentHandler(new ContentHandler[]{OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.TITLE, "title"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.CREATOR, "creator"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.DESCRIPTION, "description"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.PUBLISHER, "publisher"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.CONTRIBUTOR, "contributor"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.TYPE, "type"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.FORMAT, "format"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.IDENTIFIER, "identifier"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.LANGUAGE, "language"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.RIGHTS, "rights")});
        ch = OpenDocumentMetaParser.getMeta((ContentHandler)ch, md, TikaCoreProperties.CREATED, "creation-date");
        ch = new TeeContentHandler(new ContentHandler[]{ch, new ElementMetadataHandler("http://purl.org/dc/elements/1.1/", "date", md, TikaCoreProperties.MODIFIED)});
        ch = new TeeContentHandler(new ContentHandler[]{ch, new ElementMetadataHandler("http://purl.org/dc/elements/1.1/", "subject", md, TikaCoreProperties.TRANSITION_SUBJECT_TO_OO_SUBJECT)});
        ch = OpenDocumentMetaParser.getMeta((ContentHandler)ch, md, TikaCoreProperties.TRANSITION_KEYWORDS_TO_DC_SUBJECT, "keyword");
        ch = OpenDocumentMetaParser.getMeta((ContentHandler)ch, md, Property.externalText((String)"Edit-Time"), "editing-duration");
        ch = OpenDocumentMetaParser.getMeta((ContentHandler)ch, md, Property.externalText((String)"editing-cycles"), "editing-cycles");
        ch = OpenDocumentMetaParser.getMeta((ContentHandler)ch, md, TRANSITION_INITIAL_CREATOR_TO_INITIAL_AUTHOR, "initial-creator");
        ch = OpenDocumentMetaParser.getMeta((ContentHandler)ch, md, Property.externalText((String)"generator"), "generator");
        ch = OpenDocumentMetaParser.getUserDefined((ContentHandler)ch, md);
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, Office.OBJECT_COUNT, "object-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, Office.IMAGE_COUNT, "image-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, Office.PAGE_COUNT, "page-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, PagedText.N_PAGES, "page-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, Office.TABLE_COUNT, "table-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, Office.PARAGRAPH_COUNT, "paragraph-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, Office.WORD_COUNT, "word-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, Office.CHARACTER_COUNT, "character-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, MSOffice.OBJECT_COUNT, "object-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, MSOffice.IMAGE_COUNT, "image-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, MSOffice.PAGE_COUNT, "page-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, MSOffice.TABLE_COUNT, "table-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, MSOffice.PARAGRAPH_COUNT, "paragraph-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, MSOffice.WORD_COUNT, "word-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, MSOffice.CHARACTER_COUNT, "character-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, "nbPage", "page-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, "nbPara", "paragraph-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, "nbWord", "word-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, "nbCharacter", "character-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, "nbTab", "table-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, "nbObject", "object-count");
        ch = OpenDocumentMetaParser.getStatistic((ContentHandler)ch, md, "nbImg", "image-count");
        if (handlers != null && handlers.length > 0) {
            ContentHandler[] newHandlers = new ContentHandler[handlers.length + 1];
            newHandlers[0] = ch;
            System.arraycopy(handlers, 0, newHandlers, 1, handlers.length);
            ch = new TeeContentHandler(newHandlers);
        }
        ch = new NSNormalizerContentHandler((ContentHandler)ch);
        return ch;
    }

    @Override
    protected ContentHandler getContentHandler(ContentHandler ch, Metadata md, ParseContext context) {
        return OpenDocumentMetaParser.getContentHandler(md, context, super.getContentHandler(ch, md, context));
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        super.parse(stream, handler, metadata, context);
        String odfSubject = metadata.get(OfficeOpenXMLCore.SUBJECT);
        if (odfSubject != null && !odfSubject.equals("") && (metadata.get(TikaCoreProperties.DESCRIPTION) == null || metadata.get(TikaCoreProperties.DESCRIPTION).equals(""))) {
            metadata.set(TikaCoreProperties.DESCRIPTION, odfSubject);
        }
    }
}

