/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.ArrayList;

public class SweeperPool {
    private static final boolean DEBUG = false;
    private transient Sweeper sweeper;
    private transient int maxSize;
    private transient int minSize;
    private int triggerSize;
    private ArrayList pooledObjects;
    private boolean shuttingDown = false;

    public SweeperPool(int maxSize, int minSize, int intialCapacity, int sweepInterval, int triggerSize) {
        this.maxSize = this.saneConvert(maxSize);
        this.minSize = this.saneConvert(minSize);
        this.triggerSize = this.saneConvert(triggerSize);
        this.pooledObjects = new ArrayList(intialCapacity);
        if (sweepInterval > 0) {
            this.sweeper = new Sweeper(this, sweepInterval);
            this.sweeper.start();
        }
    }

    private int saneConvert(int value) {
        if (value < 0) {
            return 0;
        }
        return value;
    }

    public synchronized Object get() {
        if (this.pooledObjects.size() == 0 || this.shuttingDown) {
            return null;
        }
        Object obj = this.pooledObjects.remove(0);
        this.objectRetrieved(obj);
        return obj;
    }

    public synchronized boolean put(Object obj) {
        this.objectAdded(obj);
        if (obj != null && this.pooledObjects.size() < this.maxSize && !this.shuttingDown) {
            this.pooledObjects.add(obj);
            return true;
        }
        if (obj != null) {
            this.objectDisposed(obj);
        }
        return false;
    }

    public synchronized int getSize() {
        return this.pooledObjects.size();
    }

    public synchronized void dispose() {
        this.shuttingDown = true;
        if (this.sweeper != null) {
            this.sweeper.stop();
        }
        Object[] objects = this.pooledObjects.toArray();
        for (int i = 0; i < objects.length; ++i) {
            this.objectDisposed(objects[i]);
        }
        this.pooledObjects.clear();
    }

    public synchronized void trim() {
        if (this.triggerSize > 0 && this.pooledObjects.size() >= this.triggerSize || this.maxSize > 0 && this.pooledObjects.size() >= this.maxSize) {
            while (this.pooledObjects.size() > this.minSize) {
                this.objectDisposed(this.pooledObjects.remove(0));
            }
        }
    }

    public void objectDisposed(Object obj) {
    }

    public void objectAdded(Object obj) {
    }

    public void objectRetrieved(Object obj) {
    }

    private static class Sweeper
    implements Runnable {
        private final transient SweeperPool pool;
        private transient boolean service = false;
        private final transient int sweepInterval;

        public Sweeper(SweeperPool pool, int sweepInterval) {
            this.sweepInterval = sweepInterval;
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.debug("started");
            if (this.sweepInterval > 0) {
                Sweeper sweeper = this;
                synchronized (sweeper) {
                    while (this.service) {
                        try {
                            this.wait(this.sweepInterval * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runSweep();
                    }
                }
            }
            this.debug("stopped");
        }

        public synchronized void start() {
            if (!this.service) {
                this.service = true;
                Thread t = new Thread(this);
                t.start();
            }
        }

        public synchronized void stop() {
            this.service = false;
            this.notifyAll();
        }

        private final void debug(String msg) {
        }

        private void runSweep() {
            this.debug("runningSweep. time=" + System.currentTimeMillis());
            this.pool.trim();
        }
    }
}

