/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.util.LittleEndian;

public class FuncVarPtg
extends AbstractFunctionPtg {
    public static final byte sid = 34;
    private static final int SIZE = 4;

    private FuncVarPtg() {
    }

    public FuncVarPtg(byte[] data, int offset) {
        this.field_1_num_args = data[++offset + 0];
        this.field_2_fnc_index = LittleEndian.getShort(data, offset + 1);
    }

    public FuncVarPtg(String pName, byte pNumOperands) {
        this.field_1_num_args = pNumOperands;
        this.field_2_fnc_index = this.lookupIndex(pName);
        try {
            this.returnClass = (Byte)functionData[this.field_2_fnc_index][0];
            this.paramClass = (byte[])functionData[this.field_2_fnc_index][1];
        }
        catch (NullPointerException npe) {
            this.returnClass = (byte)32;
            this.paramClass = new byte[]{32};
        }
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = (byte)(34 + this.ptgClass);
        array[offset + 1] = this.field_1_num_args;
        LittleEndian.putShort(array, offset + 2, this.field_2_fnc_index);
    }

    public int getNumberOfOperands() {
        return this.field_1_num_args;
    }

    public Object clone() {
        FuncVarPtg ptg = new FuncVarPtg();
        ptg.field_1_num_args = this.field_1_num_args;
        ptg.field_2_fnc_index = this.field_2_fnc_index;
        ptg.setClass(this.ptgClass);
        return ptg;
    }

    public int getSize() {
        return 4;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<FunctionVarPtg>").append("\n").append("   field_1_num_args=").append(this.field_1_num_args).append("\n").append("      name         =").append(this.lookupName(this.field_2_fnc_index)).append("\n").append("   field_2_fnc_index=").append(this.field_2_fnc_index).append("\n").append("</FunctionPtg>");
        return buffer.toString();
    }
}

