/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces.core;

import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.behavior.AjaxBehavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.AjaxBehaviorListener;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.BehaviorHolderAttachedObjectHandler;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletHandler;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.composite.ClientBehaviorRedirectEventComponentWrapper;
import org.apache.myfaces.view.facelets.tag.composite.InsertChildrenHandler;
import org.apache.myfaces.view.facelets.tag.faces.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.ui.DecorateHandler;
import org.apache.myfaces.view.facelets.tag.ui.IncludeHandler;
import org.apache.myfaces.view.facelets.tag.ui.InsertHandler;

public class AjaxHandler
extends TagHandler
implements BehaviorHolderAttachedObjectHandler {
    public static final Class<?>[] AJAX_BEHAVIOR_LISTENER_SIG = new Class[]{AjaxBehaviorEvent.class};
    public static final String FACES_JS_DYNAMICALLY_ADDED = "org.apache.myfaces.FACES_JS_DYNAMICALLY_ADDED";
    private final TagAttribute _disabled = this.getAttribute("disabled");
    private final TagAttribute _event = this.getAttribute("event");
    private final TagAttribute _execute = this.getAttribute("execute");
    private final TagAttribute _immediate = this.getAttribute("immediate");
    private final TagAttribute _listener = this.getAttribute("listener");
    private final TagAttribute _onevent;
    private final TagAttribute _onerror = this.getAttribute("onerror");
    private final TagAttribute _render;
    private final TagAttribute _delay;
    private final TagAttribute _resetValues;
    private final boolean _wrapMode;

    public AjaxHandler(TagConfig config) {
        super(config);
        this._onevent = this.getAttribute("onevent");
        this._render = this.getAttribute("render");
        this._delay = this.getAttribute("delay");
        this._resetValues = this.getAttribute("resetValues");
        ArrayList<FaceletHandler> compHandlerList = TagHandlerUtils.findNextByType(this.nextHandler, ComponentHandler.class, InsertChildrenHandler.class, InsertHandler.class, DecorateHandler.class, IncludeHandler.class);
        this._wrapMode = !compHandlerList.isEmpty();
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            if (this._wrapMode) {
                AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
                actx.pushAjaxHandlerToStack(this);
                this.nextHandler.apply(ctx, parent);
                actx.popAjaxHandlerToStack();
            }
            return;
        }
        if (this._wrapMode) {
            AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
            actx.pushAjaxHandlerToStack(this);
            this.nextHandler.apply(ctx, parent);
            actx.popAjaxHandlerToStack();
        } else if (parent instanceof ClientBehaviorHolder) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            mctx.addAttachedObjectHandler(parent, (AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not composite component or of type ClientBehaviorHolder, type is: " + parent);
        }
        AjaxHandler.registerFacesJsResource(ctx, parent);
    }

    public static void registerFacesJsResource(FaceletContext ctx, UIComponent parent) {
        FacesContext facesContext = ctx.getFacesContext();
        if (!facesContext.getAttributes().containsKey(FACES_JS_DYNAMICALLY_ADDED)) {
            UIComponent outputScript = facesContext.getApplication().createComponent(facesContext, "jakarta.faces.Output", "jakarta.faces.resource.Script");
            outputScript.getAttributes().put("name", "faces.js");
            outputScript.getAttributes().put("library", "jakarta.faces");
            outputScript.getAttributes().put("target", "head");
            UIViewRoot uniqueIdVendor = ComponentSupport.getViewRoot(ctx, parent);
            String uid = uniqueIdVendor.createUniqueId(ctx.getFacesContext(), null);
            outputScript.setId(uid);
            parent.getChildren().add(outputScript);
            if (FaceletCompositionContext.getCurrentInstance(ctx).isMarkInitialState()) {
                outputScript.markInitialState();
            }
            facesContext.getAttributes().put(FACES_JS_DYNAMICALLY_ADDED, Boolean.TRUE);
        }
    }

    public String getEventName() {
        if (this._event == null) {
            return null;
        }
        if (this._event.isLiteral()) {
            return this._event.getValue();
        }
        FaceletContext faceletContext = (FaceletContext)FacesContext.getCurrentInstance().getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        return (String)this._event.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        UIComponent composite;
        Map clientBehaviors;
        List clientBehaviorList;
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        ClientBehaviorHolder cvh = (ClientBehaviorHolder)parent;
        String eventName = null;
        if (this._event != null) {
            eventName = this._event.isLiteral() ? this._event.getValue() : (String)this._event.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
        }
        if (eventName == null) {
            eventName = cvh.getDefaultEventName();
            if (eventName == null) {
                if (this._wrapMode) {
                    return;
                }
                throw new TagAttributeException(this._event, "eventName could not be defined for f:ajax tag with no wrap mode.");
            }
        } else if (!cvh.getEventNames().contains(eventName)) {
            if (this._wrapMode) {
                return;
            }
            throw new TagAttributeException(this._event, "event it is not a valid eventName defined for this component");
        }
        if ((clientBehaviorList = (List)(clientBehaviors = cvh.getClientBehaviors()).get(eventName)) != null && !clientBehaviorList.isEmpty()) {
            for (ClientBehavior cb : clientBehaviorList) {
                if (!(cb instanceof AjaxBehavior)) continue;
                return;
            }
        }
        AjaxBehavior ajaxBehavior = this.createBehavior(context);
        if (this._disabled != null) {
            if (this._disabled.isLiteral()) {
                ajaxBehavior.setDisabled(this._disabled.getBoolean(faceletContext));
            } else {
                ajaxBehavior.setValueExpression("disabled", this._disabled.getValueExpression(faceletContext, Boolean.class));
            }
        }
        if (this._execute != null) {
            ajaxBehavior.setValueExpression("execute", this._execute.getValueExpression(faceletContext, Object.class));
        }
        if (this._immediate != null) {
            if (this._immediate.isLiteral()) {
                ajaxBehavior.setImmediate(this._immediate.getBoolean(faceletContext));
            } else {
                ajaxBehavior.setValueExpression("immediate", this._immediate.getValueExpression(faceletContext, Boolean.class));
            }
        }
        if (this._listener != null) {
            MethodExpression expr = this._listener.getMethodExpression(faceletContext, Void.TYPE, (Class[])AJAX_BEHAVIOR_LISTENER_SIG);
            AjaxBehaviorListenerImpl abl = new AjaxBehaviorListenerImpl(expr);
            ajaxBehavior.addAjaxBehaviorListener((AjaxBehaviorListener)abl);
        }
        if (this._onerror != null) {
            if (this._onerror.isLiteral()) {
                ajaxBehavior.setOnerror(this._onerror.getValue(faceletContext));
            } else {
                ajaxBehavior.setValueExpression("onerror", this._onerror.getValueExpression(faceletContext, String.class));
            }
        }
        if (this._onevent != null) {
            if (this._onevent.isLiteral()) {
                ajaxBehavior.setOnevent(this._onevent.getValue(faceletContext));
            } else {
                ajaxBehavior.setValueExpression("onevent", this._onevent.getValueExpression(faceletContext, String.class));
            }
        }
        if (this._render != null) {
            ajaxBehavior.setValueExpression("render", this._render.getValueExpression(faceletContext, Object.class));
        }
        if (this._delay != null) {
            if (this._delay.isLiteral()) {
                ajaxBehavior.setDelay(this._delay.getValue(faceletContext));
            } else {
                ajaxBehavior.setValueExpression("delay", this._delay.getValueExpression(faceletContext, String.class));
            }
        }
        if (this._resetValues != null) {
            if (this._resetValues.isLiteral()) {
                ajaxBehavior.setResetValues(this._resetValues.getBoolean(faceletContext));
            } else {
                ajaxBehavior.setValueExpression("resetValues", this._resetValues.getValueExpression(faceletContext, Boolean.class));
            }
        }
        if (parent instanceof ClientBehaviorRedirectEventComponentWrapper && (composite = ((ClientBehaviorRedirectEventComponentWrapper)parent).getComposite()) != null) {
            Collection render;
            Collection execute = ajaxBehavior.getExecute();
            if (execute != null && execute.contains("@this")) {
                ArrayList<String> newExecute = new ArrayList<String>(execute);
                newExecute.remove("@this");
                newExecute.add("@composite");
                ajaxBehavior.setExecute(newExecute);
            }
            if ((render = ajaxBehavior.getRender()) != null && render.contains("@this")) {
                ArrayList<String> newRender = new ArrayList<String>(render);
                newRender.remove("@this");
                newRender.add("@composite");
                ajaxBehavior.setRender(newRender);
            }
        }
        cvh.addClientBehavior(eventName, (ClientBehavior)ajaxBehavior);
    }

    protected AjaxBehavior createBehavior(FacesContext context) {
        return (AjaxBehavior)context.getApplication().createBehavior("jakarta.faces.behavior.Ajax");
    }

    public String getFor() {
        return null;
    }

    public static final class AjaxBehaviorListenerImpl
    implements AjaxBehaviorListener,
    PartialStateHolder {
        private MethodExpression _expr;
        private boolean _transient;
        private boolean _initialStateMarked;

        public AjaxBehaviorListenerImpl() {
        }

        public AjaxBehaviorListenerImpl(MethodExpression expr) {
            this._expr = expr;
        }

        public void processAjaxBehavior(AjaxBehaviorEvent event) throws AbortProcessingException {
            this._expr.invoke(FacesContext.getCurrentInstance().getELContext(), new Object[]{event});
        }

        public boolean isTransient() {
            return this._transient;
        }

        public void restoreState(FacesContext context, Object state) {
            if (state == null) {
                return;
            }
            this._expr = (MethodExpression)state;
        }

        public Object saveState(FacesContext context) {
            if (this.initialStateMarked()) {
                return null;
            }
            return this._expr;
        }

        public void setTransient(boolean newTransientValue) {
            this._transient = newTransientValue;
        }

        public void clearInitialState() {
            this._initialStateMarked = false;
        }

        public boolean initialStateMarked() {
            return this._initialStateMarked;
        }

        public void markInitialState() {
            this._initialStateMarked = true;
        }
    }
}

