/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.viewController;

/**
 * A {@link ViewControllerManager} implementation which uses
 * annotations on backing beans to determine the beans responsible for a given view and execute
 * the appropriate annotated methods.
 *
 * <p>When using Spring, every bean declaration in the spring config files is checked to see if the
 * referenced class has annotations, and if so that information is cached. Here, that information is
 * then used to locate a bean which has a ViewController annotation that references the current view.</p>
 *
 * <p>See also org.apache.myfaces.orchestra.viewController.annotations.*.</p>
 *
 * @see ViewControllerManager
 */

// TODO: add a feature to the core that allows (view, beanname) pairs to be added to a list
// held by a normal ViewController. A ViewController annotation is then just one of the
// ways in which a bean's name can be added to the list. Maybe also add a map of (event->Method)
// that can be added, so that method annotations are then just another way of configuring these
// method mappings? Watch out for environments that allow hot-deploy/replace though!
// 
// TODO: how can this be configured by an application?
public class PlainAnnotationsViewControllerManager extends AbstractAnnotationsViewControllerManager
{
    private ViewControllerNameMapper viewControllerNameMapper;
    private ViewControllerExecutor viewControllerExecutor;

    public PlainAnnotationsViewControllerManager()
    {
    }

    public void initManager()
    {
        viewControllerNameMapper = new AnnotationsViewControllerNameMapper(getAnnotationInfoManager());
        viewControllerExecutor = new AnnotationsViewControllerExecutor(getAnnotationInfoManager());
    }

    protected ViewControllerNameMapper getViewControllerNameMapper()
    {
        return viewControllerNameMapper;
    }

    protected ViewControllerExecutor getViewControllerExecutor()
    {
        return viewControllerExecutor;
    }
}
