/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNode;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeRenderer.class);
    protected static final String SCROLL_POSITION = "::scrollPosition";

    public void decode(FacesContext facesContext, UIComponent component) {
        AbstractUITree tree = (AbstractUITree)component;
        String value = (String)facesContext.getExternalContext().getRequestParameterMap().get(tree.getClientId(facesContext) + SCROLL_POSITION);
        if (value != null) {
            tree.getState().getScrollPosition().update(value);
        }
        RenderUtils.decodedStateOfTreeData(facesContext, tree);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUITree tree = (AbstractUITree)component;
        for (UIComponent child : tree.getChildren()) {
            if (!(child instanceof AbstractUIStyle)) continue;
            child.encodeAll(facesContext);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUITree tree = (AbstractUITree)component;
        String clientId = tree.getClientId(facesContext);
        Markup markup = tree.getMarkup();
        AbstractUITreeNode root = ComponentUtils.findDescendant((UIComponent)tree, AbstractUITreeNode.class);
        if (root == null) {
            LOG.error("Can't find the tree root. This may occur while updating a tree from Tobago 1.0 to 1.5. Please refer the documentation to see how to use tree tags.");
            return;
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        writer.writeClassAttribute((CssItem)TobagoClass.TREE, TobagoClass.TREE.createMarkup(markup), new CssItem[]{tree.getCustomClass()});
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)tree);
        writer.writeAttribute(DataAttributes.SCROLL_PANEL, Boolean.TRUE.toString(), false);
        Selectable selectable = tree.getSelectable();
        if (selectable.isSupportedByTree()) {
            writer.writeAttribute(DataAttributes.SELECTABLE, selectable.name(), false);
        }
        SelectedState selectedState = tree.getSelectedState();
        StringBuilder selectedValue = new StringBuilder(",");
        ExpandedState expandedState = tree.getExpandedState();
        StringBuilder expandedValue = new StringBuilder(",");
        int last = tree.isRowsUnlimited() ? Integer.MAX_VALUE : tree.getFirst() + tree.getRows();
        for (int rowIndex = tree.getFirst(); rowIndex < last; ++rowIndex) {
            tree.setRowIndex(rowIndex);
            if (!tree.isRowAvailable()) break;
            TreePath path = tree.getPath();
            if (selectedState.isSelected(path)) {
                selectedValue.append(rowIndex);
                selectedValue.append(",");
            }
            if (tree.isFolder() && expandedState.isExpanded(path)) {
                expandedValue.append(rowIndex);
                expandedValue.append(",");
            }
            for (UIComponent child : tree.getChildren()) {
                if (child instanceof AbstractUIStyle) continue;
                child.encodeAll(facesContext);
            }
        }
        tree.setRowIndex(-1);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        String selectedId = clientId + "::" + "selected";
        writer.writeNameAttribute(selectedId);
        writer.writeIdAttribute(selectedId);
        writer.writeClassAttribute(TobagoClass.TREE__SELECTED);
        writer.writeAttribute(HtmlAttributes.VALUE, selectedValue.toString(), false);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        String expandedId = clientId + "::" + "expanded";
        writer.writeNameAttribute(expandedId);
        writer.writeIdAttribute(expandedId);
        writer.writeClassAttribute(TobagoClass.TREE__EXPANDED);
        writer.writeAttribute(HtmlAttributes.VALUE, expandedValue.toString(), false);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(clientId + SCROLL_POSITION);
        writer.writeNameAttribute(clientId + SCROLL_POSITION);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.VALUE, tree.getState().getScrollPosition().encode(), false);
        writer.writeAttribute(DataAttributes.SCROLL_POSITION, Boolean.TRUE.toString(), true);
        writer.endElement(HtmlElements.INPUT);
        writer.endElement(HtmlElements.DIV);
    }
}

