/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.io;

import java.io.IOException;
import java.io.Writer;

public class XMLEscapes {
    static final String[] __BASE_ENTITIES = new String[]{"", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", null, "&#11;", "&#12;", null, "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;", null, null, null, null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&gt;"};
    static final String[] __BODY_ENTITIES = (String[])__BASE_ENTITIES.clone();
    private static final String[] _ATTRIBUTE_ENTITIES;

    public static void writeText(Writer out, String text) throws IOException {
        XMLEscapes._writeText(out, text, __BODY_ENTITIES);
    }

    public static void writeText(Writer out, char[] text, int start, int length) throws IOException {
        XMLEscapes._writeText(out, text, start, length, __BODY_ENTITIES);
    }

    public static void writeAttribute(Writer out, String attributeValue) throws IOException {
        XMLEscapes._writeText(out, attributeValue, _ATTRIBUTE_ENTITIES);
    }

    private static void _writeText(Writer out, char[] text, int start, int length, String[] entities) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch <= '\u007f') {
                if (ch >= '?') {
                    out.write(ch);
                    continue;
                }
                String entity = entities[ch];
                if (entity != null) {
                    out.write(entity);
                    continue;
                }
                out.write(ch);
                continue;
            }
            if (ch > '\ud7ff' && (ch < '\ue000' || ch > '\ufffd')) continue;
            XMLEscapes.__writeDecRef(out, ch);
        }
    }

    private static void _writeText(Writer out, String text, String[] entities) throws IOException {
        int end = text.length();
        for (int i = 0; i < end; ++i) {
            char ch = text.charAt(i);
            if (ch <= '\u007f') {
                if (ch >= '?') {
                    out.write(ch);
                    continue;
                }
                String entity = entities[ch];
                if (entity != null) {
                    out.write(entity);
                    continue;
                }
                out.write(ch);
                continue;
            }
            if (ch > '\ud7ff' && (ch < '\ue000' || ch > '\ufffd')) continue;
            XMLEscapes.__writeDecRef(out, ch);
        }
    }

    static void __writeDecRef(Writer out, char ch) throws IOException {
        out.write("&#");
        int i = ch;
        if (i > 10000) {
            out.write(48 + i / 10000);
            out.write(48 + (i %= 10000) / 1000);
            out.write(48 + (i %= 1000) / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        } else if (i > 1000) {
            out.write(48 + i / 1000);
            out.write(48 + (i %= 1000) / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        } else {
            out.write(48 + i / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        }
        out.write(59);
    }

    private XMLEscapes() {
    }

    static {
        XMLEscapes.__BODY_ENTITIES[60] = "&lt;";
        _ATTRIBUTE_ENTITIES = (String[])__BODY_ENTITIES.clone();
        XMLEscapes._ATTRIBUTE_ENTITIES[34] = "&quot;";
    }
}

