/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class LoadNativeLibAspect {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LoadNativeLibAspect ajc$perSingletonInstance;

    @Around(value="call(void java.lang.System.load(String)) || call(void java.lang.Runtime.load(String))")
    public void around(ProceedingJoinPoint joinPoint) throws Throwable {
        String origLibPathStr = (String)joinPoint.getArgs()[0];
        if (origLibPathStr == null || origLibPathStr.isEmpty()) {
            this.logger.info("Native library path specified as null or empty string, proceeding normally");
            joinPoint.proceed();
            return;
        }
        Path origLibPath = Paths.get(origLibPathStr, new String[0]);
        if (!Files.exists(origLibPath, new LinkOption[0])) {
            this.logger.info("Native library does not exist, proceeding normally");
            joinPoint.proceed();
            return;
        }
        String libFileName = origLibPath.getFileName().toString();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String prefix = String.valueOf(contextClassLoader.getClass().getName()) + "@" + contextClassLoader.hashCode() + "_";
        String suffix = "_" + libFileName;
        Path tempLibPath = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        Files.copy(origLibPath, tempLibPath, StandardCopyOption.REPLACE_EXISTING);
        this.logger.info("Loading native library via absolute path (original lib: {}, copied lib: {}", (Object)origLibPath, (Object)tempLibPath);
        joinPoint.proceed(new Object[]{tempLibPath.toString()});
    }

    public static LoadNativeLibAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.apache.nifi.nar.LoadNativeLibAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            LoadNativeLibAspect.ajc$perSingletonInstance = new LoadNativeLibAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

