/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.nifi.nar.AbstractNativeLibHandlingClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarClassLoader
extends AbstractNativeLibHandlingClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NarClassLoader.class);
    private static final FileFilter JAR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String nameToTest = pathname.getName().toLowerCase();
            return nameToTest.endsWith(".jar") && pathname.isFile();
        }
    };
    private final File narWorkingDirectory;

    public NarClassLoader(File narWorkingDirectory) throws ClassNotFoundException, IOException {
        super(new URL[0], NarClassLoader.initNativeLibDirList(narWorkingDirectory), narWorkingDirectory.getName());
        this.narWorkingDirectory = narWorkingDirectory;
        this.updateClasspath(narWorkingDirectory);
    }

    public NarClassLoader(File narWorkingDirectory, ClassLoader parentClassLoader) throws ClassNotFoundException, IOException {
        super(new URL[0], parentClassLoader, NarClassLoader.initNativeLibDirList(narWorkingDirectory), narWorkingDirectory.getName());
        this.narWorkingDirectory = narWorkingDirectory;
        this.updateClasspath(narWorkingDirectory);
    }

    public File getWorkingDirectory() {
        return this.narWorkingDirectory;
    }

    private void updateClasspath(File root) throws IOException {
        File[] jarFiles;
        this.addURL(root.toURI().toURL());
        File dependencies = new File(root, "NAR-INF/bundled-dependencies");
        if (!dependencies.isDirectory()) {
            LOGGER.warn("{} does not contain NAR-INF/bundled-dependencies!", (Object)this.narWorkingDirectory);
        }
        this.addURL(dependencies.toURI().toURL());
        if (dependencies.isDirectory() && (jarFiles = dependencies.listFiles(JAR_FILTER)) != null) {
            Arrays.sort(jarFiles, Comparator.comparing(File::getName));
            for (File libJar : jarFiles) {
                this.addURL(libJar.toURI().toURL());
            }
        }
    }

    public File getNARNativeLibDir() {
        return NarClassLoader.getNARNativeLibDir(this.narWorkingDirectory);
    }

    private static List<File> initNativeLibDirList(File narWorkingDirectory) {
        ArrayList<File> nativeLibDirList = new ArrayList<File>();
        nativeLibDirList.add(NarClassLoader.getNARNativeLibDir(narWorkingDirectory));
        return nativeLibDirList;
    }

    private static File getNARNativeLibDir(File narWorkingDirectory) {
        File dependencies = new File(narWorkingDirectory, "NAR-INF/bundled-dependencies");
        if (!dependencies.isDirectory()) {
            LOGGER.warn("{} does not contain NAR-INF/bundled-dependencies!", (Object)narWorkingDirectory);
        }
        return new File(dependencies, "native");
    }

    public String toString() {
        return NarClassLoader.class.getName() + "[" + this.narWorkingDirectory.getPath() + "]";
    }
}

