/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.help.HelpAppendable;
import org.apache.commons.cli.help.HelpFormatter;
import org.apache.commons.cli.help.TextHelpAppendable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.Command;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.api.Result;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;

public abstract class AbstractCommand<R extends Result>
implements Command<R> {
    private final String name;
    private final Class<R> resultClass;
    private final Options options;
    private Context context;
    private PrintStream output;

    public AbstractCommand(String name, Class<R> resultClass) {
        this.name = Objects.requireNonNull(name);
        this.resultClass = Objects.requireNonNull(resultClass);
        this.options = this.createBaseOptions();
    }

    protected Options createBaseOptions() {
        Options options = new Options();
        options.addOption(CommandOption.URL.createOption());
        options.addOption(CommandOption.PROPERTIES.createOption());
        options.addOption(CommandOption.CONNECTION_TIMEOUT.createOption());
        options.addOption(CommandOption.READ_TIMEOUT.createOption());
        options.addOption(CommandOption.KEYSTORE.createOption());
        options.addOption(CommandOption.KEYSTORE_TYPE.createOption());
        options.addOption(CommandOption.KEYSTORE_PASSWORD.createOption());
        options.addOption(CommandOption.KEY_PASSWORD.createOption());
        options.addOption(CommandOption.TRUSTSTORE.createOption());
        options.addOption(CommandOption.TRUSTSTORE_TYPE.createOption());
        options.addOption(CommandOption.TRUSTSTORE_PASSWORD.createOption());
        options.addOption(CommandOption.PROXIED_ENTITY.createOption());
        options.addOption(CommandOption.BASIC_AUTH_USER.createOption());
        options.addOption(CommandOption.BASIC_AUTH_PASSWORD.createOption());
        options.addOption(CommandOption.BEARER_TOKEN.createOption());
        options.addOption(CommandOption.OUTPUT_TYPE.createOption());
        options.addOption(CommandOption.VERBOSE.createOption());
        options.addOption(CommandOption.HELP.createOption());
        return options;
    }

    @Override
    public final void initialize(Context context) {
        this.context = Objects.requireNonNull(context);
        this.output = Objects.requireNonNull(context.getOutput());
        this.doInitialize(context);
    }

    protected void doInitialize(Context context) {
    }

    protected void addOption(Option option) {
        this.options.addOption(option);
    }

    protected Context getContext() {
        return this.context;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Class<R> getResultImplType() {
        return this.resultClass;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void printUsage(String errorMessage) {
        this.output.println();
        if (errorMessage != null) {
            this.output.println("ERROR: " + errorMessage);
            this.output.println();
        }
        try {
            PrintWriter printWriter = new PrintWriter(this.output);
            TextHelpAppendable appendable = new TextHelpAppendable((Appendable)printWriter);
            appendable.setMaxWidth(80);
            appendable.appendParagraph((CharSequence)this.getDescription());
            if (this.isReferencable()) {
                appendable.appendParagraph((CharSequence)"PRODUCES BACK-REFERENCES");
            }
            ((HelpFormatter.Builder)HelpFormatter.builder().setHelpAppendable((HelpAppendable)appendable)).setShowSince(false).get().printHelp(this.getName(), null, this.getOptions(), null, false);
            printWriter.println();
            printWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to print command usage for " + this.getName(), e);
        }
    }

    protected void print(String val) {
        this.output.print(val);
    }

    protected void println(String val) {
        this.output.println(val);
    }

    protected void println() {
        this.output.println();
    }

    protected ResultType getResultType(Properties properties) {
        ResultType resultType;
        if (properties.containsKey(CommandOption.OUTPUT_TYPE.getLongName())) {
            String outputTypeValue = properties.getProperty(CommandOption.OUTPUT_TYPE.getLongName());
            resultType = ResultType.valueOf(outputTypeValue.toUpperCase().trim());
        } else {
            resultType = ResultType.SIMPLE;
        }
        return resultType;
    }

    protected String getArg(Properties properties, CommandOption option) {
        return properties.getProperty(option.getLongName());
    }

    protected String getRequiredArg(Properties properties, CommandOption option) throws MissingOptionException {
        String argValue = properties.getProperty(option.getLongName());
        if (StringUtils.isBlank((CharSequence)argValue)) {
            throw new MissingOptionException("Missing required option --" + option.getLongName());
        }
        return argValue;
    }

    protected Integer getIntArg(Properties properties, CommandOption option) throws MissingOptionException {
        String argValue = properties.getProperty(option.getLongName());
        if (StringUtils.isBlank((CharSequence)argValue)) {
            return null;
        }
        try {
            return Integer.valueOf(argValue);
        }
        catch (Exception e) {
            throw new MissingOptionException("Version must be numeric: " + argValue);
        }
    }

    protected Integer getRequiredIntArg(Properties properties, CommandOption option) throws MissingOptionException {
        String argValue = properties.getProperty(option.getLongName());
        if (StringUtils.isBlank((CharSequence)argValue)) {
            throw new MissingOptionException("Missing required option --" + option.getLongName());
        }
        try {
            return Integer.valueOf(argValue);
        }
        catch (Exception e) {
            throw new MissingOptionException("Version must be numeric: " + argValue);
        }
    }

    protected boolean hasArg(Properties properties, CommandOption option) {
        return properties.containsKey(option.getLongName());
    }

    protected boolean isVerbose(Properties properties) {
        return properties.containsKey(CommandOption.VERBOSE.getLongName());
    }

    protected boolean isInteractive() {
        return this.getContext().isInteractive();
    }

    protected void printlnIfInteractive(String val) {
        if (this.isInteractive()) {
            this.println(val);
        }
    }

    protected String getInputSourceContent(String inputFile) throws IOException {
        String contents;
        try {
            contents = IOUtils.toString((URL)URI.create(inputFile).toURL(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            URI uri = Paths.get(inputFile, new String[0]).toAbsolutePath().toUri();
            contents = IOUtils.toString((URI)uri, (Charset)StandardCharsets.UTF_8);
        }
        return contents;
    }
}

