/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import jakarta.inject.Singleton;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.glassfish.jersey.innate.inject.ClassBinding;
import org.glassfish.jersey.innate.inject.InjectionIds;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.innate.inject.InternalBinder;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ServiceFinderBinder;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.Tokenizer;
import org.glassfish.jersey.message.internal.BasicTypesMessageProvider;
import org.glassfish.jersey.message.internal.ByteArrayProvider;
import org.glassfish.jersey.message.internal.CacheControlProvider;
import org.glassfish.jersey.message.internal.CookieProvider;
import org.glassfish.jersey.message.internal.DataSourceProvider;
import org.glassfish.jersey.message.internal.DateProvider;
import org.glassfish.jersey.message.internal.EntityTagProvider;
import org.glassfish.jersey.message.internal.EnumMessageProvider;
import org.glassfish.jersey.message.internal.FileProvider;
import org.glassfish.jersey.message.internal.FormMultivaluedMapProvider;
import org.glassfish.jersey.message.internal.FormProvider;
import org.glassfish.jersey.message.internal.InputStreamProvider;
import org.glassfish.jersey.message.internal.LinkProvider;
import org.glassfish.jersey.message.internal.LocaleProvider;
import org.glassfish.jersey.message.internal.MediaTypeProvider;
import org.glassfish.jersey.message.internal.NewCookieProvider;
import org.glassfish.jersey.message.internal.PathProvider;
import org.glassfish.jersey.message.internal.ReaderProvider;
import org.glassfish.jersey.message.internal.RenderedImageProvider;
import org.glassfish.jersey.message.internal.SourceProvider;
import org.glassfish.jersey.message.internal.StreamingOutputProvider;
import org.glassfish.jersey.message.internal.StringHeaderProvider;
import org.glassfish.jersey.message.internal.StringMessageProvider;
import org.glassfish.jersey.message.internal.UriProvider;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

public final class MessagingBinders {
    private static final Logger LOGGER = Logger.getLogger(MessagingBinders.class.getName());
    private static final Map<EnabledProvidersBinder.Provider, AtomicBoolean> warningMap = new HashMap<EnabledProvidersBinder.Provider, AtomicBoolean>();

    private MessagingBinders() {
    }

    static {
        for (EnabledProvidersBinder.Provider provider : EnabledProvidersBinder.Provider.values()) {
            warningMap.put(provider, new AtomicBoolean(false));
        }
    }

    private static final class EnabledProvidersBinder {
        private static final String ALL = "ALL";
        private HashSet<Provider> enabledProviders = new HashSet();

        private EnabledProvidersBinder() {
            for (Provider provider : Provider.values()) {
                this.enabledProviders.add(provider);
            }
        }

        private void markDisabled(String properties) {
            String[] tokens = Tokenizer.tokenize(properties);
            for (int tokenIndex = 0; tokenIndex != tokens.length; ++tokenIndex) {
                String token = tokens[tokenIndex].toUpperCase(Locale.ROOT);
                if (ALL.equals(token)) {
                    this.enabledProviders.clear();
                    return;
                }
                Iterator<Provider> iterator = this.enabledProviders.iterator();
                while (iterator.hasNext()) {
                    Provider provider = iterator.next();
                    if (!provider.name().equals(token)) continue;
                    iterator.remove();
                }
            }
        }

        private void bindToBinder(InternalBinder binder, RuntimeType runtimeType) {
            ProviderBinder providerBinder = null;
            for (Provider provider : this.enabledProviders) {
                if (EnabledProvidersBinder.isClass(provider.className)) {
                    switch (provider) {
                        case DATASOURCE: {
                            providerBinder = new DataSourceBinder();
                            break;
                        }
                        case DOMSOURCE: {
                            providerBinder = new DomSourceBinder();
                            break;
                        }
                        case RENDEREDIMAGE: {
                            providerBinder = new RenderedImageBinder();
                            break;
                        }
                        case SAXSOURCE: {
                            providerBinder = new SaxSourceBinder();
                            break;
                        }
                        case SOURCE: {
                            providerBinder = new SourceBinder();
                            break;
                        }
                        case STREAMSOURCE: {
                            providerBinder = new StreamSourceBinder();
                        }
                    }
                    providerBinder.bind(binder, provider, runtimeType);
                    continue;
                }
                if (!warningMap.get((Object)provider).compareAndSet(false, true)) continue;
                switch (provider) {
                    case DOMSOURCE: 
                    case SAXSOURCE: 
                    case STREAMSOURCE: {
                        LOGGER.warning(LocalizationMessages.DEPENDENT_CLASS_OF_DEFAULT_PROVIDER_NOT_FOUND(provider.className, "MessageBodyReader<" + provider.className + ">"));
                        break;
                    }
                    case DATASOURCE: 
                    case RENDEREDIMAGE: 
                    case SOURCE: {
                        LOGGER.warning(LocalizationMessages.DEPENDENT_CLASS_OF_DEFAULT_PROVIDER_NOT_FOUND(provider.className, "MessageBodyWriter<" + provider.className + ">"));
                    }
                }
            }
        }

        private static boolean isClass(String className) {
            return null != AccessController.doPrivileged(ReflectionHelper.classForNamePA(className));
        }

        private static enum Provider {
            DATASOURCE("jakarta.activation.DataSource"),
            DOMSOURCE("javax.xml.transform.dom.DOMSource"),
            RENDEREDIMAGE("java.awt.image.RenderedImage"),
            SAXSOURCE("javax.xml.transform.sax.SAXSource"),
            SOURCE("javax.xml.transform.Source"),
            STREAMSOURCE("javax.xml.transform.stream.StreamSource");

            private String className;

            private Provider(String className) {
                this.className = className;
            }
        }

        private static class DataSourceBinder
        implements ProviderBinder {
            private DataSourceBinder() {
            }

            @Override
            public void bind(InternalBinder binder, Provider provider, RuntimeType runtimeType) {
                ((ClassBinding)((ClassBinding)((ClassBinding)binder.bind(DataSourceProvider.class).to(MessageBodyReader.class)).to(MessageBodyWriter.class)).in(Singleton.class)).id(runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_DATA_SOURCE_PROVIDER.id() : (long)InjectionIds.SERVER_DATA_SOURCE_PROVIDER.id());
            }
        }

        private static class DomSourceBinder
        implements ProviderBinder {
            private DomSourceBinder() {
            }

            @Override
            public void bind(InternalBinder binder, Provider provider, RuntimeType runtimeType) {
                ((ClassBinding)((ClassBinding)binder.bind(SourceProvider.DomSourceReader.class).to(MessageBodyReader.class)).in(Singleton.class)).id(runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_DOM_SOURCE_READER.id() : (long)InjectionIds.SERVER_DOM_SOURCE_READER.id());
            }
        }

        private static class RenderedImageBinder
        implements ProviderBinder {
            private RenderedImageBinder() {
            }

            @Override
            public void bind(InternalBinder binder, Provider provider, RuntimeType runtimeType) {
                ((ClassBinding)((ClassBinding)((ClassBinding)binder.bind(RenderedImageProvider.class).to(MessageBodyReader.class)).to(MessageBodyWriter.class)).in(Singleton.class)).id(runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_RENDERED_IMAGE_PROVIDER.id() : (long)InjectionIds.SERVER_RENDERED_IMAGE_PROVIDER.id());
            }
        }

        private static class SaxSourceBinder
        implements ProviderBinder {
            private SaxSourceBinder() {
            }

            @Override
            public void bind(InternalBinder binder, Provider provider, RuntimeType runtimeType) {
                ((ClassBinding)((ClassBinding)binder.bind(SourceProvider.SaxSourceReader.class).to(MessageBodyReader.class)).in(Singleton.class)).id(runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_SAX_SOURCE_READER.id() : (long)InjectionIds.SERVER_SAX_SOURCE_READER.id());
            }
        }

        private static class SourceBinder
        implements ProviderBinder {
            private SourceBinder() {
            }

            @Override
            public void bind(InternalBinder binder, Provider provider, RuntimeType runtimeType) {
                ((ClassBinding)((ClassBinding)binder.bind(SourceProvider.SourceWriter.class).to(MessageBodyWriter.class)).in(Singleton.class)).id(runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_SOURCE_WRITER.id() : (long)InjectionIds.SERVER_SOURCE_WRITER.id());
            }
        }

        private static class StreamSourceBinder
        implements ProviderBinder {
            private StreamSourceBinder() {
            }

            @Override
            public void bind(InternalBinder binder, Provider provider, RuntimeType runtimeType) {
                ((ClassBinding)((ClassBinding)binder.bind(SourceProvider.StreamSourceReader.class).to(MessageBodyReader.class)).in(Singleton.class)).id(runtimeType == RuntimeType.CLIENT ? 2075L : 3075L);
            }
        }

        private static interface ProviderBinder {
            public void bind(InternalBinder var1, Provider var2, RuntimeType var3);
        }
    }

    public static class HeaderDelegateProviders
    extends InternalBinder {
        private final Map<HeaderDelegateProvider, Integer> providers;
        private final RuntimeType runtimeType;

        public HeaderDelegateProviders(RuntimeType runtimeType) {
            this.runtimeType = runtimeType;
            LinkedHashMap<HeaderDelegateProvider, Integer> providers = new LinkedHashMap<HeaderDelegateProvider, Integer>();
            providers.put(new CacheControlProvider(), runtimeType == RuntimeType.CLIENT ? InjectionIds.CLIENT_CACHE_CONTROL_PROVIDER.id() : InjectionIds.SERVER_CACHE_CONTROL_PROVIDER.id());
            providers.put(new CookieProvider(), runtimeType == RuntimeType.CLIENT ? InjectionIds.CLIENT_COOKIE_PROVIDER.id() : InjectionIds.SERVER_COOKIE_PROVIDER.id());
            providers.put(new DateProvider(), runtimeType == RuntimeType.CLIENT ? InjectionIds.CLIENT_DATE_PROVIDER.id() : InjectionIds.SERVER_DATE_PROVIDER.id());
            providers.put(new EntityTagProvider(), runtimeType == RuntimeType.CLIENT ? InjectionIds.CLIENT_ENTITY_TAG_PROVIDER.id() : InjectionIds.SERVER_ENTITY_TAG_PROVIDER.id());
            providers.put(new LinkProvider(), runtimeType == RuntimeType.CLIENT ? InjectionIds.CLIENT_LINK_PROVIDER.id() : InjectionIds.SERVER_LINK_PROVIDER.id());
            providers.put(new LocaleProvider(), runtimeType == RuntimeType.CLIENT ? InjectionIds.CLIENT_LOCALE_PROVIDER.id() : InjectionIds.SERVER_LOCALE_PROVIDER.id());
            providers.put(new MediaTypeProvider(), runtimeType == RuntimeType.CLIENT ? InjectionIds.CLIENT_MEDIA_TYPE_PROVIDER.id() : InjectionIds.SERVER_MEDIA_TYPE_PROVIDER.id());
            providers.put(new NewCookieProvider(), runtimeType == RuntimeType.CLIENT ? InjectionIds.CLIENT_NEW_COOKIE_PROVIDER.id() : InjectionIds.SERVER_NEW_COOKIE_PROVIDER.id());
            providers.put(new StringHeaderProvider(), runtimeType == RuntimeType.CLIENT ? InjectionIds.CLIENT_STRING_HEADER_PROVIDER.id() : InjectionIds.SERVER_STRING_HEADER_PROVIDER.id());
            providers.put(new UriProvider(), runtimeType == RuntimeType.CLIENT ? InjectionIds.CLIENT_URI_PROVIDER.id() : InjectionIds.SERVER_URI_PROVIDER.id());
            this.providers = providers;
        }

        @Override
        protected void configure() {
            this.providers.forEach((provider, id) -> ((InstanceBinding)this.bind(provider).to(HeaderDelegateProvider.class)).id(id.intValue()));
        }

        public Set<HeaderDelegateProvider> getHeaderDelegateProviders() {
            return this.providers.keySet();
        }
    }

    public static class MessageBodyProviders
    extends InternalBinder {
        private final Map<String, Object> applicationProperties;
        private final RuntimeType runtimeType;

        public MessageBodyProviders(Map<String, Object> applicationProperties, RuntimeType runtimeType) {
            this.applicationProperties = applicationProperties;
            this.runtimeType = runtimeType;
        }

        @Override
        protected void configure() {
            this.bindSingletonWorker(ByteArrayProvider.class, this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_BYTE_ARRAY_PROVIDER.id() : (long)InjectionIds.SERVER_BYTE_ARRAY_PROVIDER.id());
            this.bindSingletonWorker(FileProvider.class, this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_FILE_PROVIDER.id() : (long)InjectionIds.SERVER_FILE_PROVIDER.id());
            this.bindSingletonWorker(PathProvider.class, this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_PATH_PROVIDER.id() : (long)InjectionIds.SERVER_PATH_PROVIDER.id());
            this.bindSingletonWorker(FormMultivaluedMapProvider.class, this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_MULTIVALUED_MAP_PROVIDER.id() : (long)InjectionIds.SERVER_MULTIVALUED_MAP_PROVIDER.id());
            this.bindSingletonWorker(FormProvider.class, this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_FORM_PROVIDER.id() : (long)InjectionIds.SERVER_FORM_PROVIDER.id());
            this.bindSingletonWorker(InputStreamProvider.class, this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_INPUT_STREAM_PROVIDER.id() : (long)InjectionIds.SERVER_INPUT_STREAM_PROVIDER.id());
            this.bindSingletonWorker(BasicTypesMessageProvider.class, this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_BASIC_TYPES_PROVIDER.id() : (long)InjectionIds.SERVER_BASIC_TYPES_PROVIDER.id());
            this.bindSingletonWorker(ReaderProvider.class, this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_READER_PROVIDER.id() : (long)InjectionIds.SERVER_READER_PROVIDER.id());
            this.bindSingletonWorker(StringMessageProvider.class, this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_STRING_MESSAGE_PROVIDER.id() : (long)InjectionIds.SERVER_STRING_MESSAGE_PROVIDER.id());
            this.bindSingletonWorker(EnumMessageProvider.class, this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_ENUM_MESSAGE_PROVIDER.id() : (long)InjectionIds.SERVER_ENUM_MESSAGE_PROVIDER.id());
            ((ClassBinding)((ClassBinding)this.bind(StreamingOutputProvider.class).to(MessageBodyWriter.class)).in(Singleton.class)).id(this.runtimeType == RuntimeType.CLIENT ? (long)InjectionIds.CLIENT_STREAMING_OUTPUT_PROVIDER.id() : (long)InjectionIds.SERVER_STREAMING_OUTPUT_PROVIDER.id());
            EnabledProvidersBinder enabledProvidersBinder = new EnabledProvidersBinder();
            if (this.applicationProperties != null && this.applicationProperties.get("jersey.config.disableDefaultProvider") != null) {
                enabledProvidersBinder.markDisabled(String.valueOf(this.applicationProperties.get("jersey.config.disableDefaultProvider")));
            }
            enabledProvidersBinder.bindToBinder(this, this.runtimeType);
            this.install(new ServiceFinderBinder<HeaderDelegateProvider>(HeaderDelegateProvider.class, this.applicationProperties, this.runtimeType));
        }

        private <T extends MessageBodyReader & MessageBodyWriter> void bindSingletonWorker(Class<T> worker, long id) {
            ((ClassBinding)((ClassBinding)((ClassBinding)this.bind((Class)worker).to(MessageBodyReader.class)).to(MessageBodyWriter.class)).in(Singleton.class)).id(id);
        }
    }
}

