/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.flywaydb.core.FlywayExecutor;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.exception.FlywayValidateException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.api.pattern.ValidatePattern;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbInfo;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.command.DbValidate;
import org.flywaydb.core.internal.command.MigrateTelemetryModel;
import org.flywaydb.core.internal.command.clean.DbClean;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.nc.NativeConnectorsModeUtils;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.CommandExtensionUtils;
import org.flywaydb.core.internal.util.FlywayDbWebsiteLinks;
import org.flywaydb.core.internal.util.StringUtils;

public class Flyway {
    @Generated
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private final ClassicConfiguration configuration;
    private final FlywayExecutor flywayExecutor;
    @Deprecated
    private FlywayTelemetryManager flywayTelemetryManager;

    public static FluentConfiguration configure() {
        return new FluentConfiguration();
    }

    public static FluentConfiguration configure(ClassLoader classLoader) {
        return new FluentConfiguration(classLoader);
    }

    public Flyway(Configuration configuration) {
        this.configuration = new ClassicConfiguration(configuration);
        List<Callback> callbacks = this.configuration.loadCallbackLocation("db/callback", false);
        if (!callbacks.isEmpty()) {
            this.configuration.setCallbacks((Callback[])callbacks.toArray(Callback[]::new));
        }
        this.flywayExecutor = new FlywayExecutor(this.configuration);
        LogFactory.setConfiguration(this.configuration);
        FlywayDbWebsiteLinks.FEEDBACK_SURVEY_LINK = LicenseGuard.isLicensed(this.configuration, List.of(Tier.ENTERPRISE)) ? "https://rd.gt/41g7TY9" : "https://rd.gt/4jVBMEa";
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public <T extends ConfigurationExtension> T getConfigurationExtension(Class<T> configClass) {
        return (T)((ConfigurationExtension)this.getConfiguration().getPluginRegister().getExact(configClass));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public MigrateResult migrate() throws FlywayException {
        try (MigrateTelemetryModel telemetryModel = new MigrateTelemetryModel(this.flywayTelemetryManager);){
            Optional<VerbExtension> verb;
            if (NativeConnectorsModeUtils.canUseNativeConnectors(this.configuration, "migrate")) {
                verb = this.configuration.getPluginRegister().getInstancesOf(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("migrate")).findFirst();
                if (verb.isPresent()) {
                    LOG.debug("Native Connectors for migrate is set and a verb is present");
                    MigrateResult result = (MigrateResult)((VerbExtension)verb.get()).executeVerb(this.configuration);
                    telemetryModel.setFromMigrateResult(result);
                    MigrateResult migrateResult = result;
                    return migrateResult;
                }
                LOG.warn("Native Connectors for migrate is set but no verb is present");
            }
            try {
                verb = this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
                    if (this.configuration.isValidateOnMigrate()) {
                        ArrayList<ValidatePattern> ignorePatterns = new ArrayList<ValidatePattern>(Arrays.asList(this.configuration.getIgnoreMigrationPatterns()));
                        ignorePatterns.add(ValidatePattern.fromPattern("*:pending"));
                        ValidateResult validateResult = this.doValidate(database, migrationResolver, schemaHistory, defaultSchema, schemas, callbackExecutor, (ValidatePattern[])ignorePatterns.toArray(ValidatePattern[]::new));
                        if (!validateResult.validationSuccessful) {
                            throw new FlywayValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
                        }
                    }
                    if (this.configuration.isCreateSchemas()) {
                        new DbSchemas(database, schemas, schemaHistory, callbackExecutor).create(false);
                    } else if (!defaultSchema.exists()) {
                        LOG.warn("The configuration option 'createSchemas' is false.\nHowever, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://rd.gt/4iUkpm1");
                    }
                    if (!schemaHistory.exists()) {
                        ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                        for (Schema schema : schemas) {
                            if (!schema.exists() || schema.empty()) continue;
                            nonEmptySchemas.add(schema);
                        }
                        if (nonEmptySchemas.isEmpty() && this.configuration.isBaselineOnMigrate()) {
                            LOG.info("All configured schemas are empty; baseline operation skipped. A baseline or migration script with a lower version than the baseline version may execute if available. Check the Schemas parameter if this is not intended.");
                        }
                        if (!nonEmptySchemas.isEmpty() && !this.configuration.isSkipExecutingMigrations()) {
                            if (this.configuration.isBaselineOnMigrate()) {
                                this.doBaseline(schemaHistory, callbackExecutor, database);
                            } else if (!schemaHistory.exists()) {
                                throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " but no schema history table. Use baseline() or set baselineOnMigrate to true to initialize the schema history table.", CoreErrorCode.NON_EMPTY_SCHEMA_WITHOUT_SCHEMA_HISTORY_TABLE);
                            }
                        }
                        schemaHistory.create(false);
                    }
                    MigrateResult result = new DbMigrate(database, schemaHistory, defaultSchema, migrationResolver, this.configuration, callbackExecutor).migrate();
                    telemetryModel.setFromMigrateResult(result);
                    callbackExecutor.onOperationFinishEvent(Event.AFTER_MIGRATE_OPERATION_FINISH, result);
                    return result;
                }, true, this.flywayTelemetryManager);
                return verb;
            }
            catch (Exception e) {
                telemetryModel.setException(e);
                throw e;
            }
        }
    }

    public MigrationInfoService info() {
        if (NativeConnectorsModeUtils.canUseNativeConnectors(this.configuration, "info")) {
            Optional<VerbExtension> verb = this.configuration.getPluginRegister().getInstancesOf(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("info")).findFirst();
            if (verb.isPresent()) {
                LOG.debug("Native Connectors for info is set and a verb is present");
                return (MigrationInfoService)verb.get().executeVerb(this.configuration);
            }
            LOG.warn("Native Connectors for info is set but no verb is present");
        }
        return this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            MigrationInfoService migrationInfoService = new DbInfo(migrationResolver, schemaHistory, this.configuration, database, callbackExecutor, schemas).info();
            callbackExecutor.onOperationFinishEvent(Event.AFTER_INFO_OPERATION_FINISH, migrationInfoService.getInfoResult());
            return migrationInfoService;
        }, true, this.flywayTelemetryManager);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public CleanResult clean() {
        try (EventTelemetryModel telemetryModel = new EventTelemetryModel("clean", this.flywayTelemetryManager);){
            Optional<VerbExtension> verb;
            if (NativeConnectorsModeUtils.canUseNativeConnectors(this.configuration, "clean")) {
                verb = this.configuration.getPluginRegister().getInstancesOf(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("clean")).findFirst();
                if (verb.isPresent()) {
                    LOG.debug("Native Connectors for clean is set and a verb is present");
                    CleanResult cleanResult = (CleanResult)((VerbExtension)verb.get()).executeVerb(this.configuration);
                    return cleanResult;
                }
                LOG.warn("Native Connectors for clean is set but no verb is present");
            }
            try {
                verb = this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
                    CleanResult cleanResult = this.doClean(database, schemaHistory, defaultSchema, schemas, callbackExecutor);
                    callbackExecutor.onOperationFinishEvent(Event.AFTER_CLEAN_OPERATION_FINISH, cleanResult);
                    return cleanResult;
                }, false, this.flywayTelemetryManager);
                return verb;
            }
            catch (Exception e) {
                telemetryModel.setException(e);
                throw e;
            }
        }
    }

    public void validate() throws FlywayException {
        ValidateResult validateResult = this.validateWithResult();
        if (!validateResult.validationSuccessful) {
            throw new FlywayValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
        }
    }

    public ValidateResult validateWithResult() throws FlywayException {
        if (NativeConnectorsModeUtils.canUseNativeConnectors(this.configuration, "validate")) {
            Optional<VerbExtension> verb = this.configuration.getPluginRegister().getInstancesOf(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("validate")).findFirst();
            if (verb.isPresent()) {
                LOG.debug("Native Connectors for validate is set and a verb is present");
                return (ValidateResult)verb.get().executeVerb(this.configuration);
            }
            LOG.warn("Native Connectors for validate is set but no verb is present");
        }
        return this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            ValidateResult validateResult = this.doValidate(database, migrationResolver, schemaHistory, defaultSchema, schemas, callbackExecutor, this.configuration.getIgnoreMigrationPatterns());
            callbackExecutor.onOperationFinishEvent(Event.AFTER_VALIDATE_OPERATION_FINISH, validateResult);
            return validateResult;
        }, true, this.flywayTelemetryManager);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public BaselineResult baseline() throws FlywayException {
        try (EventTelemetryModel telemetryModel = new EventTelemetryModel("baseline", this.flywayTelemetryManager);){
            Optional<VerbExtension> verb;
            if (NativeConnectorsModeUtils.canUseNativeConnectors(this.configuration, "baseline")) {
                verb = this.configuration.getPluginRegister().getInstancesOf(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("baseline")).findFirst();
                if (verb.isPresent()) {
                    LOG.debug("Native Connectors for baseline is set and a verb is present");
                    BaselineResult baselineResult = (BaselineResult)((VerbExtension)verb.get()).executeVerb(this.configuration);
                    return baselineResult;
                }
                LOG.warn("Native Connectors for baseline is set but no verb is present");
            }
            try {
                verb = this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
                    if (this.configuration.isCreateSchemas()) {
                        new DbSchemas(database, schemas, schemaHistory, callbackExecutor).create(true);
                    } else {
                        LOG.warn("The configuration option 'createSchemas' is false.\nEven though Flyway is configured not to create any schemas, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://rd.gt/4iUkpm1");
                    }
                    BaselineResult baselineResult = this.doBaseline(schemaHistory, callbackExecutor, database);
                    callbackExecutor.onOperationFinishEvent(Event.AFTER_BASELINE_OPERATION_FINISH, baselineResult);
                    return baselineResult;
                }, false, this.flywayTelemetryManager);
                return verb;
            }
            catch (Exception e) {
                telemetryModel.setException(e);
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public RepairResult repair() throws FlywayException {
        try (EventTelemetryModel telemetryModel = new EventTelemetryModel("repair", this.flywayTelemetryManager);){
            Optional<VerbExtension> verb;
            if (NativeConnectorsModeUtils.canUseNativeConnectors(this.configuration, "repair")) {
                verb = this.configuration.getPluginRegister().getInstancesOf(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("repair")).findFirst();
                if (verb.isPresent()) {
                    LOG.debug("Native Connectors for repair is set and a verb is present");
                    RepairResult repairResult = (RepairResult)((VerbExtension)verb.get()).executeVerb(this.configuration);
                    return repairResult;
                }
                LOG.warn("Native Connectors for repair is set but no verb is present");
            }
            try {
                verb = this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
                    RepairResult repairResult = new DbRepair(database, migrationResolver, schemaHistory, callbackExecutor, this.configuration).repair();
                    callbackExecutor.onOperationFinishEvent(Event.AFTER_REPAIR_OPERATION_FINISH, repairResult);
                    return repairResult;
                }, true, this.flywayTelemetryManager);
                return verb;
            }
            catch (Exception e) {
                telemetryModel.setException(e);
                throw e;
            }
        }
    }

    public OperationResult undo() throws FlywayException {
        if (NativeConnectorsModeUtils.canUseNativeConnectors(this.configuration, "undo")) {
            Optional<VerbExtension> verb = this.configuration.getPluginRegister().getInstancesOf(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("undo")).findFirst();
            if (verb.isPresent()) {
                try (EventTelemetryModel ignored = new EventTelemetryModel("undo", this.flywayTelemetryManager);){
                    LOG.debug("Native Connectors for undo is set and a verb is present");
                    OperationResult operationResult = (OperationResult)verb.get().executeVerb(this.configuration);
                    return operationResult;
                }
            }
            LOG.warn("Native Connectors for undo is set but no verb is present");
        }
        try {
            return this.runCommand("undo", Collections.emptyList());
        }
        catch (FlywayException e) {
            if (e.getMessage().startsWith("No command extension found")) {
                throw new FlywayException("The command 'undo' was not recognized. Make sure you have added 'flyway-proprietary' as a dependency.", e);
            }
            throw e;
        }
    }

    private OperationResult runCommand(String command, List<String> flags) {
        return CommandExtensionUtils.runCommandExtension(this.configuration, command, flags);
    }

    private CleanResult doClean(Database database, SchemaHistory schemaHistory, Schema defaultSchema, Schema[] schemas, CallbackExecutor<Event> callbackExecutor) {
        return new DbClean(database, schemaHistory, defaultSchema, schemas, callbackExecutor, this.configuration).clean();
    }

    private ValidateResult doValidate(Database database, CompositeMigrationResolver migrationResolver, SchemaHistory schemaHistory, Schema defaultSchema, Schema[] schemas, CallbackExecutor<Event> callbackExecutor, ValidatePattern[] ignorePatterns) {
        ValidateResult validateResult = new DbValidate(database, schemaHistory, defaultSchema, migrationResolver, this.configuration, callbackExecutor, ignorePatterns).validate();
        if (this.configuration.isCleanOnValidationError()) {
            throw new FlywayException("cleanOnValidationError has been removed");
        }
        return validateResult;
    }

    private BaselineResult doBaseline(SchemaHistory schemaHistory, CallbackExecutor<Event> callbackExecutor, Database database) {
        return new DbBaseline(schemaHistory, this.configuration.getBaselineVersion(), this.configuration.getBaselineDescription(), callbackExecutor, database).baseline();
    }

    @Deprecated
    @Generated
    public void setFlywayTelemetryManager(FlywayTelemetryManager flywayTelemetryManager) {
        this.flywayTelemetryManager = flywayTelemetryManager;
    }
}

