/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.nutch.crawl.CrawlDb;
import org.apache.nutch.crawl.DeduplicationJob;
import org.apache.nutch.crawl.Generator;
import org.apache.nutch.crawl.Injector;
import org.apache.nutch.crawl.LinkDb;
import org.apache.nutch.fetcher.Fetcher;
import org.apache.nutch.indexer.IndexingJob;
import org.apache.nutch.parse.ParseSegment;
import org.apache.nutch.service.JobManager;
import org.apache.nutch.util.NutchTool;

public class JobFactory {
    private static Map<JobManager.JobType, Class<? extends NutchTool>> typeToClass = Maps.newHashMap();

    public NutchTool createToolByType(JobManager.JobType type, Configuration conf) {
        if (!typeToClass.containsKey((Object)type)) {
            return null;
        }
        Class<? extends NutchTool> clz = typeToClass.get((Object)type);
        return this.createTool(clz, conf);
    }

    public NutchTool createToolByClassName(String className, Configuration conf) {
        try {
            Class<?> clz = Class.forName(className);
            return this.createTool(clz, conf);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private NutchTool createTool(Class<? extends NutchTool> clz, Configuration conf) {
        return (NutchTool)((Object)ReflectionUtils.newInstance(clz, (Configuration)conf));
    }

    static {
        typeToClass.put(JobManager.JobType.INJECT, Injector.class);
        typeToClass.put(JobManager.JobType.GENERATE, Generator.class);
        typeToClass.put(JobManager.JobType.FETCH, Fetcher.class);
        typeToClass.put(JobManager.JobType.PARSE, ParseSegment.class);
        typeToClass.put(JobManager.JobType.INDEX, IndexingJob.class);
        typeToClass.put(JobManager.JobType.UPDATEDB, CrawlDb.class);
        typeToClass.put(JobManager.JobType.INVERTLINKS, LinkDb.class);
        typeToClass.put(JobManager.JobType.DEDUP, DeduplicationJob.class);
    }
}

