/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tika.detect.zip.StreamingDetectContext;
import org.apache.tika.detect.zip.ZipContainerDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;

public class FrictionlessPackageDetector
implements ZipContainerDetector {
    private static final MediaType WACZ = MediaType.application((String)"x-wacz");
    private static final MediaType DATA_PACKAGE = MediaType.application((String)"x-vnd.datapackage+zip");

    @Override
    public MediaType detect(ZipFile zip, TikaInputStream tis) throws IOException {
        Enumeration<ZipArchiveEntry> entries = zip.getEntries();
        MediaType mt = null;
        Counter counter = new Counter();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry zae = entries.nextElement();
            this.updateCounter(zae, counter);
            mt = this.getMediaType(counter);
            if (mt != WACZ) continue;
            return WACZ;
        }
        return this.getMediaType(counter);
    }

    @Override
    public MediaType streamingDetectUpdate(ZipArchiveEntry zae, InputStream zis, StreamingDetectContext detectContext) {
        Counter counter = detectContext.get(Counter.class);
        if (counter == null) {
            counter = new Counter();
            detectContext.set(Counter.class, counter);
        }
        this.updateCounter(zae, counter);
        MediaType mt = this.getMediaType(counter);
        if (mt == WACZ) {
            return WACZ;
        }
        return null;
    }

    private void updateCounter(ZipArchiveEntry zae, Counter counter) {
        String name = zae.getName();
        if (name.startsWith("archive/")) {
            counter.update(PARTS.WACZ_ARCHIVE);
        } else if (name.startsWith("indexes/")) {
            counter.update(PARTS.WACZ_INDEXES);
        } else if (name.startsWith("pages/")) {
            counter.update(PARTS.WACZ_PAGES);
        } else if ("datapackage.json".equals(name)) {
            counter.update(PARTS.PACKAGE);
        }
    }

    MediaType getMediaType(Counter counter) {
        if (counter == null) {
            return null;
        }
        if (counter.parts.contains((Object)PARTS.PACKAGE)) {
            if (counter.parts.size() == 1) {
                return DATA_PACKAGE;
            }
            if (counter.parts.contains((Object)PARTS.WACZ_ARCHIVE)) {
                return WACZ;
            }
            if (counter.parts.contains((Object)PARTS.WACZ_INDEXES) && counter.parts.contains((Object)PARTS.WACZ_PAGES)) {
                return WACZ;
            }
        }
        return null;
    }

    @Override
    public MediaType streamingDetectFinal(StreamingDetectContext detectContext) {
        return this.getMediaType(detectContext.get(Counter.class));
    }

    private static class Counter {
        private Set<PARTS> parts = new HashSet<PARTS>();

        private Counter() {
        }

        void update(PARTS val) {
            this.parts.add(val);
        }
    }

    private static enum PARTS {
        PACKAGE,
        WACZ_ARCHIVE,
        WACZ_INDEXES,
        WACZ_PAGES;

    }
}

