/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import shaded.org.apache.commons.io.IOUtils;

public class MSOwnerFileParser
extends AbstractParser {
    private static final int ASCII_CHUNK_LENGTH = 54;
    private static final MediaType MEDIA_TYPE = MediaType.application((String)"x-ms-owner");
    private static final int MAX_STRING_LENGTH = 0xA00000;
    private static final long serialVersionUID = -752276948656079347L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        byte[] asciiNameBytes = new byte[54];
        IOUtils.readFully(stream, asciiNameBytes);
        byte asciiNameLength = asciiNameBytes[0];
        if (asciiNameLength < 0) {
            throw new TikaException("ascii name length must be >= 0");
        }
        if (asciiNameLength > 54) {
            throw new TikaException("ascii name length must be < 55");
        }
        String asciiName = new String(asciiNameBytes, 1, (int)asciiNameLength, StandardCharsets.US_ASCII);
        metadata.set(TikaCoreProperties.MODIFIER, asciiName);
        int unicodeCharLength = stream.read();
        if (asciiNameLength != unicodeCharLength) {
            throw new TikaException("Ascii name length should be the same as the unicode length");
        }
        stream.read();
        byte[] unicodeBytes = new byte[unicodeCharLength * 2];
        IOUtils.readFully(stream, unicodeBytes);
        String unicodeName = new String(unicodeBytes, StandardCharsets.UTF_16LE);
        metadata.set(TikaCoreProperties.MODIFIER, unicodeName);
        xhtml.endDocument();
    }
}

