/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientOperation;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.core.domain.ClientValuableImpl;

public final class ClientPropertyImpl
extends ClientValuableImpl
implements ClientProperty {
    private final List<ClientAnnotation> annotations = new ArrayList<ClientAnnotation>();
    private final String name;
    private final List<ClientOperation> operations = new ArrayList<ClientOperation>();

    public ClientPropertyImpl(String name, ClientValue value) {
        super(value);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ClientOperation getOperation(String title) {
        ClientOperation result = null;
        for (ClientOperation operation : this.operations) {
            if (!title.equals(operation.getTitle())) continue;
            result = operation;
            break;
        }
        return result;
    }

    public List<ClientOperation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean hasNullValue() {
        return this.value == null || this.value.isPrimitive() && this.value.asPrimitive().toValue() == null || this.value.isComplex() && this.value.asComplex().asJavaMap().size() == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ClientPropertyImpl)) {
            return false;
        }
        ClientPropertyImpl other = (ClientPropertyImpl)obj;
        return this.annotations.equals(other.annotations) && (this.name == null ? other.name == null : this.name.equals(other.name)) && (this.value == null ? other.value == null : this.value.equals(other.value));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public List<ClientAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public String toString() {
        return "ClientPropertyImpl{name=" + this.name + ", value=" + this.value + ", annotations=" + this.annotations + '}';
    }
}

