/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class BinaryOperatorNode
extends OperatorNode {
    String operator;
    String methodName;
    ValueNode receiver;
    static final int PLUS = 1;
    static final int MINUS = 2;
    static final int TIMES = 3;
    static final int DIVIDE = 4;
    static final int CONCATENATE = 5;
    static final int EQ = 6;
    static final int NE = 7;
    static final int GT = 8;
    static final int GE = 9;
    static final int LT = 10;
    static final int LE = 11;
    static final int AND = 12;
    static final int OR = 13;
    static final int LIKE = 14;
    ValueNode leftOperand;
    ValueNode rightOperand;
    String leftInterfaceType;
    String rightInterfaceType;
    String resultInterfaceType;
    static final int K_XMLEXISTS = 0;
    static final int K_XMLQUERY = 1;
    static final int K_BASE = 2;
    final int kind;
    static final String[] BinaryOperators = new String[]{"xmlexists", "xmlquery"};
    static final String[] BinaryMethodNames = new String[]{"XMLExists", "XMLQuery"};
    static final String[] BinaryResultTypes = new String[]{"org.apache.derby.iapi.types.BooleanDataValue", "org.apache.derby.iapi.types.XMLDataValue"};
    static final String[][] BinaryArgTypes = new String[][]{{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.XMLDataValue"}, {"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.XMLDataValue"}};
    private String xmlQuery;

    BinaryOperatorNode(ContextManager contextManager) {
        super(contextManager);
        this.kind = 2;
    }

    BinaryOperatorNode(ValueNode valueNode, ValueNode valueNode2, String string, String string2, String string3, String string4, ContextManager contextManager) {
        super(contextManager);
        this.leftOperand = valueNode;
        this.rightOperand = valueNode2;
        this.operator = string;
        this.methodName = string2;
        this.leftInterfaceType = string3;
        this.rightInterfaceType = string4;
        this.kind = 2;
    }

    BinaryOperatorNode(ValueNode valueNode, ValueNode valueNode2, String string, String string2, ContextManager contextManager) {
        super(contextManager);
        this.leftOperand = valueNode;
        this.rightOperand = valueNode2;
        this.leftInterfaceType = string;
        this.rightInterfaceType = string2;
        this.kind = 2;
    }

    BinaryOperatorNode(ValueNode valueNode, ValueNode valueNode2, int n, ContextManager contextManager) {
        super(contextManager);
        this.leftOperand = valueNode;
        this.rightOperand = valueNode2;
        this.kind = n;
        this.operator = BinaryOperators[this.kind];
        this.methodName = BinaryMethodNames[this.kind];
        this.leftInterfaceType = BinaryArgTypes[this.kind][0];
        this.rightInterfaceType = BinaryArgTypes[this.kind][1];
        this.resultInterfaceType = BinaryResultTypes[this.kind];
    }

    @Override
    public String toString() {
        return "";
    }

    void setOperator(String string) {
        this.operator = string;
    }

    void setMethodName(String string) {
        this.methodName = string;
    }

    void setLeftRightInterfaceType(String string) {
        this.leftInterfaceType = string;
        this.rightInterfaceType = string;
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, list);
        this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, list);
        if (this.kind == 0 || this.kind == 1) {
            return this.bindXMLQuery();
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.rightOperand.requiresTypeFromContext()) {
                throw StandardException.newException((String)"42X35", (Object[])new Object[]{this.operator});
            }
            this.leftOperand.setType(this.rightOperand.getTypeServices());
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(this.leftOperand.getTypeServices());
        }
        return this.genSQLJavaSQLTree();
    }

    public ValueNode bindXMLQuery() throws StandardException {
        TypeId typeId = this.rightOperand.getTypeId();
        if (!(this.leftOperand instanceof CharConstantNode)) {
            throw StandardException.newException((String)"42Z75", (Object[])new Object[0]);
        }
        this.xmlQuery = ((CharConstantNode)this.leftOperand).getString();
        if (typeId != null && !typeId.isXMLTypeId()) {
            throw StandardException.newException((String)"42Z77", (Object[])new Object[]{typeId.getSQLTypeName()});
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            throw StandardException.newException((String)"42Z70", (Object[])new Object[0]);
        }
        if (this.kind == 0) {
            this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
        } else {
            this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009));
        }
        return this.genSQLJavaSQLTree();
    }

    @Override
    ValueNode genSQLJavaSQLTree() throws StandardException {
        TypeId typeId;
        TypeId typeId2 = this.leftOperand.getTypeId();
        if (typeId2.userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if ((typeId = this.rightOperand.getTypeId()).userType()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        return this;
    }

    @Override
    ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(n, fromList, subqueryList, predicateList);
        this.rightOperand = this.rightOperand.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        LocalField localField;
        int n;
        String string;
        boolean bl;
        Object object;
        if (this instanceof BinaryRelationalOperatorNode && (object = ((BinaryRelationalOperatorNode)this).getInListOp()) != null) {
            ((InListOperatorNode)object).generateExpression(expressionClassBuilder, methodBuilder);
            return;
        }
        boolean bl2 = bl = this.kind == 1 || this.kind == 0;
        if (this.leftOperand.getTypeId().typePrecedence() > this.rightOperand.getTypeId().typePrecedence()) {
            this.receiver = this.leftOperand;
            string = this.kind == 2 ? this.getReceiverInterfaceName() : this.leftInterfaceType;
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast(string);
            methodBuilder.dup();
            methodBuilder.cast(this.leftInterfaceType);
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast(this.rightInterfaceType);
            n = 2;
        } else {
            this.receiver = this.rightOperand;
            string = this.kind == 2 ? this.getReceiverInterfaceName() : this.rightInterfaceType;
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast(string);
            if (bl) {
                n = 1;
                BinaryOperatorNode.pushSqlXmlUtil(expressionClassBuilder, methodBuilder, this.xmlQuery, this.operator);
            } else {
                n = 2;
                methodBuilder.dup();
                methodBuilder.cast(this.rightInterfaceType);
                this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
                methodBuilder.cast(this.leftInterfaceType);
                methodBuilder.swap();
            }
        }
        object = this.kind == 2 ? this.getTypeCompiler().interfaceName() : this.resultInterfaceType;
        LocalField localField2 = localField = this.getTypeId().isBooleanTypeId() ? null : expressionClassBuilder.newFieldDeclaration(2, (String)object);
        if (localField != null) {
            int n2;
            methodBuilder.getField(localField);
            ++n;
            if (this.getTypeServices() != null && ((n2 = this.getTypeServices().getJDBCTypeId()) == 3 || n2 == 2) && this.operator.equals("/")) {
                methodBuilder.push(this.getTypeServices().getScale());
                ++n;
            }
        }
        methodBuilder.callMethod((short)185, string, this.methodName, (String)object, n);
        if (localField != null) {
            if (this.getTypeId().variableLength() && this.getTypeId().isNumericTypeId()) {
                methodBuilder.dup();
                methodBuilder.push(this.getTypeServices().getPrecision());
                methodBuilder.push(this.getTypeServices().getScale());
                methodBuilder.push(true);
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
            }
            methodBuilder.putField(localField);
        }
    }

    void setLeftOperand(ValueNode valueNode) {
        this.leftOperand = valueNode;
    }

    ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    void setRightOperand(ValueNode valueNode) {
        this.rightOperand = valueNode;
    }

    ValueNode getRightOperand() {
        return this.rightOperand;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = this.leftOperand.categorize(jBitSet, bl);
        bl2 = this.rightOperand.categorize(jBitSet, bl) && bl2;
        return bl2;
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        this.rightOperand = this.rightOperand.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperand.isConstantExpression();
    }

    @Override
    boolean constantExpression(PredicateList predicateList) {
        return this.leftOperand.constantExpression(predicateList) && this.rightOperand.constantExpression(predicateList);
    }

    String getReceiverInterfaceName() throws StandardException {
        return this.receiver.getTypeCompiler().interfaceName();
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        int n = this.leftOperand.getOrderableVariantType();
        int n2 = this.rightOperand.getOrderableVariantType();
        return Math.min(n, n2);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(visitor);
        }
        if (this.rightOperand != null) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(visitor);
        }
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((BinaryOperatorNode)valueNode).kind == this.kind;
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeKind(valueNode)) {
            BinaryOperatorNode binaryOperatorNode = (BinaryOperatorNode)valueNode;
            return this.methodName.equals(binaryOperatorNode.methodName) && this.leftOperand.isEquivalent(binaryOperatorNode.leftOperand) && this.rightOperand.isEquivalent(binaryOperatorNode.rightOperand);
        }
        return false;
    }
}

