/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.GenericStatement;
import org.apache.derby.impl.sql.compile.ParserImpl;
import org.apache.derby.impl.sql.conn.CachedStatement;
import org.apache.derby.impl.sql.conn.GenericLanguageConnectionContext;
import org.apache.derby.shared.common.error.StandardException;

public class GenericLanguageConnectionFactory
implements LanguageConnectionFactory,
CacheableFactory,
PropertySetCallback,
ModuleControl,
ModuleSupportable {
    private ExecutionFactory ef;
    private OptimizerFactory of;
    private TypeCompilerFactory tcf;
    private DataValueFactory dvf;
    private UUIDFactory uuidFactory;
    private JavaFactory javaFactory;
    private ClassFactory classFactory;
    private PropertyFactory pf;
    private int nextLCCInstanceNumber;
    private int cacheSize = 100;
    private CacheManager singleStatementCache;

    @Override
    public Statement getStatement(SchemaDescriptor schemaDescriptor, String string, boolean bl) {
        return new GenericStatement(schemaDescriptor, string, bl);
    }

    @Override
    public LanguageConnectionContext newLanguageConnectionContext(ContextManager contextManager, TransactionController transactionController, LanguageFactory languageFactory, Database database, String string, String string2, String string3) throws StandardException {
        return new GenericLanguageConnectionContext(contextManager, transactionController, languageFactory, this, database, string, this.getNextLCCInstanceNumber(), string2, string3);
    }

    @Override
    public Cacheable newCacheable(CacheManager cacheManager) {
        return new CachedStatement();
    }

    @Override
    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    @Override
    public ClassFactory getClassFactory() {
        return this.classFactory;
    }

    @Override
    public JavaFactory getJavaFactory() {
        return this.javaFactory;
    }

    @Override
    public ExecutionFactory getExecutionFactory() {
        return this.ef;
    }

    @Override
    public PropertyFactory getPropertyFactory() {
        return this.pf;
    }

    @Override
    public OptimizerFactory getOptimizerFactory() {
        return this.of;
    }

    @Override
    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.tcf;
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    @Override
    public boolean canSupport(Properties properties) {
        return Monitor.isDesiredType(properties, 130);
    }

    private int statementCacheSize(Properties properties) {
        String string = null;
        string = PropertyUtil.getPropertyFromSet(properties, "derby.language.statementCacheSize");
        if (string != null) {
            try {
                this.cacheSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.cacheSize = 100;
            }
        }
        return this.cacheSize;
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        this.dvf = (DataValueFactory)GenericLanguageConnectionFactory.bootServiceModule(bl, this, "org.apache.derby.iapi.types.DataValueFactory", properties);
        this.javaFactory = (JavaFactory)GenericLanguageConnectionFactory.startSystemModule("org.apache.derby.iapi.services.compiler.JavaFactory");
        this.uuidFactory = GenericLanguageConnectionFactory.getMonitor().getUUIDFactory();
        this.classFactory = (ClassFactory)GenericLanguageConnectionFactory.getServiceModule(this, "org.apache.derby.iapi.services.loader.ClassFactory");
        if (this.classFactory == null) {
            this.classFactory = (ClassFactory)GenericLanguageConnectionFactory.findSystemModule("org.apache.derby.iapi.services.loader.ClassFactory");
        }
        this.setValidation();
        this.ef = (ExecutionFactory)GenericLanguageConnectionFactory.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.execute.ExecutionFactory", properties);
        this.of = (OptimizerFactory)GenericLanguageConnectionFactory.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.compile.OptimizerFactory", properties);
        this.tcf = (TypeCompilerFactory)GenericLanguageConnectionFactory.startSystemModule("org.apache.derby.iapi.sql.compile.TypeCompilerFactory");
        int n = this.statementCacheSize(properties);
        if (n > 0) {
            CacheFactory cacheFactory = (CacheFactory)GenericLanguageConnectionFactory.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
            this.singleStatementCache = cacheFactory.newCacheManager(this, "StatementCache", n / 4, n);
            DataFactory dataFactory = (DataFactory)GenericLanguageConnectionFactory.findServiceModule(this, "org.apache.derby.iapi.store.raw.data.DataFactory");
            this.singleStatementCache.registerMBean(dataFactory.getRootDirectory());
        }
    }

    @Override
    public CacheManager getStatementCache() {
        return this.singleStatementCache;
    }

    @Override
    public void stop() {
        if (this.singleStatementCache != null) {
            this.singleStatementCache.deregisterMBean();
        }
    }

    @Override
    public void init(boolean bl, Dictionary dictionary) {
    }

    @Override
    public boolean validate(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (serializable == null) {
            return true;
        }
        if (string.equals("derby.database.defaultConnectionMode")) {
            String string2 = (String)((Object)serializable);
            if (!(string2 == null || StringUtil.SQLEqualsIgnoreCase(string2, "NOACCESS") || StringUtil.SQLEqualsIgnoreCase(string2, "READONLYACCESS") || StringUtil.SQLEqualsIgnoreCase(string2, "FULLACCESS"))) {
                throw StandardException.newException((String)"4250B", (Object[])new Object[]{string, string2});
            }
            return true;
        }
        if (string.equals("derby.database.readOnlyAccessUsers") || string.equals("derby.database.fullAccessUsers")) {
            String[] stringArray;
            String string3 = (String)((Object)serializable);
            try {
                stringArray = IdUtil.parseIdList(string3);
            }
            catch (StandardException standardException) {
                throw StandardException.newException((String)"4250B", (Throwable)standardException, (Object[])new Object[]{string, string3});
            }
            String string4 = IdUtil.dups(stringArray);
            if (string4 != null) {
                throw StandardException.newException((String)"4250D", (Object[])new Object[]{string, string4});
            }
            String string5 = string.equals("derby.database.readOnlyAccessUsers") ? (String)dictionary.get("derby.database.fullAccessUsers") : (String)dictionary.get("derby.database.readOnlyAccessUsers");
            String[] stringArray2 = IdUtil.parseIdList(string5);
            String string6 = IdUtil.intersect(stringArray, stringArray2);
            if (string6 != null) {
                throw StandardException.newException((String)"4250C", (Object[])new Object[]{string6});
            }
            return true;
        }
        return false;
    }

    @Override
    public Serviceable apply(String string, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    @Override
    public Serializable map(String string, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    protected void setValidation() throws StandardException {
        this.pf = (PropertyFactory)GenericLanguageConnectionFactory.findServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        this.pf.addPropertySetNotification(this);
    }

    @Override
    public Parser newParser(CompilerContext compilerContext) {
        return new ParserImpl(compilerContext);
    }

    protected synchronized int getNextLCCInstanceNumber() {
        return this.nextLCCInstanceNumber++;
    }

    static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static Object startSystemModule(final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.startSystemModule(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }

    private static Object findSystemModule(final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findSystemModule(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }

    private static Object bootServiceModule(final boolean bl, final Object object, final String string, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.bootServiceModule(bl, object, string, properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }

    private static Object findServiceModule(final Object object, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(object, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }

    private static Object getServiceModule(final Object object, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.getServiceModule(object, string);
            }
        });
    }
}

