/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.method;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.Assert;
import org.springframework.validation.method.MethodValidationResult;
import org.springframework.validation.method.ParameterValidationResult;

final class DefaultMethodValidationResult
implements MethodValidationResult {
    private final Object target;
    private final Method method;
    private final List<ParameterValidationResult> parameterValidationResults;
    private final List<MessageSourceResolvable> crossParamResults;
    private final boolean forReturnValue;

    DefaultMethodValidationResult(Object target, Method method, List<ParameterValidationResult> results, List<MessageSourceResolvable> crossParamResults) {
        Assert.isTrue((!results.isEmpty() || !crossParamResults.isEmpty() ? 1 : 0) != 0, (String)"Expected validation results");
        Assert.notNull((Object)target, (String)"'target' is required");
        Assert.notNull((Object)method, (String)"Method is required");
        this.target = target;
        this.method = method;
        this.parameterValidationResults = results;
        this.crossParamResults = crossParamResults;
        this.forReturnValue = !results.isEmpty() && results.get(0).getMethodParameter().getParameterIndex() == -1;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean isForReturnValue() {
        return this.forReturnValue;
    }

    @Override
    public List<ParameterValidationResult> getParameterValidationResults() {
        return this.parameterValidationResults;
    }

    @Override
    public List<MessageSourceResolvable> getCrossParameterValidationResults() {
        return this.crossParamResults;
    }

    public String toString() {
        return this.getAllErrors().size() + " validation errors for " + (this.isForReturnValue() ? "return value" : "arguments") + " of " + this.method.toGenericString();
    }
}

