/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl.executejar;

import com.hazelcast.internal.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class MainMethodFinder {
    Method mainMethod;
    private String errorMessage;

    MainMethodFinder() {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Method getMainMethod() {
        return this.mainMethod;
    }

    boolean hasError() {
        return !StringUtil.isNullOrEmpty(this.errorMessage);
    }

    public void findMainMethod(ClassLoader classLoader, String mainClassName) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(mainClassName);
        this.getMainMethodOfClass(clazz);
    }

    void getMainMethodOfClass(Class<?> clazz) {
        try {
            this.mainMethod = clazz.getDeclaredMethod("main", String[].class);
            if (!this.isPublicAndStatic()) {
                this.errorMessage = "Class " + clazz.getName() + " has a main(String[] args) method which is not public static";
            }
        }
        catch (NoSuchMethodException exception) {
            this.errorMessage = "Class " + clazz.getName() + " does not have a main(String[] args) method";
        }
    }

    boolean isPublicAndStatic() {
        int modifiers = this.mainMethod.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }
}

