/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.response;

import com.github.caldav4j.CalDAVConstants;
import java.io.Reader;
import java.io.StringReader;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;

public class CalendarDataProperty {
    public static final String ELEMENT_CALENDAR_DATA = "calendar-data";
    private static ThreadLocal<CalendarBuilder> calendarBuilderThreadLocal = null;

    public static ThreadLocal<CalendarBuilder> getCalendarBuilderThreadLocal() {
        if (calendarBuilderThreadLocal == null) {
            calendarBuilderThreadLocal = ThreadLocal.withInitial(CalendarBuilder::new);
        }
        return calendarBuilderThreadLocal;
    }

    public static void setCalendarBuilderThreadLocal(ThreadLocal<CalendarBuilder> calendarBuilderThreadLocal) {
        CalendarDataProperty.calendarBuilderThreadLocal = calendarBuilderThreadLocal;
    }

    public static Calendar getCalendarfromProperty(DavProperty property) {
        if (property == null || property.getValue() == null) {
            return null;
        }
        Calendar calendar = null;
        String text = property.getValue().toString();
        text = text.replaceAll("\n", "\r\n").replaceAll("\r\r\n", "\r\n");
        ThreadLocal<CalendarBuilder> threadLocalCalendarBuilder = CalendarDataProperty.getCalendarBuilderThreadLocal();
        CalendarBuilder calendarBuilder = threadLocalCalendarBuilder.get();
        StringReader stringReader = new StringReader(text);
        try {
            calendar = calendarBuilder.build((Reader)stringReader);
        }
        catch (ParserException e) {
            try {
                CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
                CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
                CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
                calendar = calendarBuilder.build((Reader)stringReader);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        threadLocalCalendarBuilder.remove();
        return calendar;
    }

    public static Calendar getCalendarfromResponse(MultiStatusResponse response) {
        return CalendarDataProperty.getCalendarfromProperty(response.getProperties(200).get(CalDAVConstants.DNAME_CALENDAR_DATA));
    }

    public static String getEtagfromResponse(MultiStatusResponse response) {
        return CalendarDataProperty.getEtagfromProperty(response.getProperties(200).get(DavPropertyName.GETETAG));
    }

    public static String getEtagfromProperty(DavProperty property) {
        if (property == null || property.getValue() == null || !property.getName().equals((Object)DavPropertyName.GETETAG)) {
            return null;
        }
        return property.getValue().toString();
    }
}

