/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CBusPointToMultiPointCommandNormal is the corresponding interface of CBusPointToMultiPointCommandNormal
type CBusPointToMultiPointCommandNormal interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CBusPointToMultiPointCommand
	// GetApplication returns Application (property field)
	GetApplication() ApplicationIdContainer
	// GetSalData returns SalData (property field)
	GetSalData() SALData
	// IsCBusPointToMultiPointCommandNormal is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCBusPointToMultiPointCommandNormal()
	// CreateBuilder creates a CBusPointToMultiPointCommandNormalBuilder
	CreateCBusPointToMultiPointCommandNormalBuilder() CBusPointToMultiPointCommandNormalBuilder
}

// _CBusPointToMultiPointCommandNormal is the data-structure of this message
type _CBusPointToMultiPointCommandNormal struct {
	CBusPointToMultiPointCommandContract
	Application ApplicationIdContainer
	SalData     SALData
	// Reserved Fields
	reservedField0 *byte
}

var _ CBusPointToMultiPointCommandNormal = (*_CBusPointToMultiPointCommandNormal)(nil)
var _ CBusPointToMultiPointCommandRequirements = (*_CBusPointToMultiPointCommandNormal)(nil)

// NewCBusPointToMultiPointCommandNormal factory function for _CBusPointToMultiPointCommandNormal
func NewCBusPointToMultiPointCommandNormal(peekedApplication byte, application ApplicationIdContainer, salData SALData, cBusOptions CBusOptions) *_CBusPointToMultiPointCommandNormal {
	if salData == nil {
		panic("salData of type SALData for CBusPointToMultiPointCommandNormal must not be nil")
	}
	_result := &_CBusPointToMultiPointCommandNormal{
		CBusPointToMultiPointCommandContract: NewCBusPointToMultiPointCommand(peekedApplication, cBusOptions),
		Application:                          application,
		SalData:                              salData,
	}
	_result.CBusPointToMultiPointCommandContract.(*_CBusPointToMultiPointCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CBusPointToMultiPointCommandNormalBuilder is a builder for CBusPointToMultiPointCommandNormal
type CBusPointToMultiPointCommandNormalBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(application ApplicationIdContainer, salData SALData) CBusPointToMultiPointCommandNormalBuilder
	// WithApplication adds Application (property field)
	WithApplication(ApplicationIdContainer) CBusPointToMultiPointCommandNormalBuilder
	// WithSalData adds SalData (property field)
	WithSalData(SALData) CBusPointToMultiPointCommandNormalBuilder
	// WithSalDataBuilder adds SalData (property field) which is build by the builder
	WithSalDataBuilder(func(SALDataBuilder) SALDataBuilder) CBusPointToMultiPointCommandNormalBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CBusPointToMultiPointCommandBuilder
	// Build builds the CBusPointToMultiPointCommandNormal or returns an error if something is wrong
	Build() (CBusPointToMultiPointCommandNormal, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CBusPointToMultiPointCommandNormal
}

// NewCBusPointToMultiPointCommandNormalBuilder() creates a CBusPointToMultiPointCommandNormalBuilder
func NewCBusPointToMultiPointCommandNormalBuilder() CBusPointToMultiPointCommandNormalBuilder {
	return &_CBusPointToMultiPointCommandNormalBuilder{_CBusPointToMultiPointCommandNormal: new(_CBusPointToMultiPointCommandNormal)}
}

type _CBusPointToMultiPointCommandNormalBuilder struct {
	*_CBusPointToMultiPointCommandNormal

	parentBuilder *_CBusPointToMultiPointCommandBuilder

	collectedErr []error
}

var _ (CBusPointToMultiPointCommandNormalBuilder) = (*_CBusPointToMultiPointCommandNormalBuilder)(nil)

func (b *_CBusPointToMultiPointCommandNormalBuilder) setParent(contract CBusPointToMultiPointCommandContract) {
	b.CBusPointToMultiPointCommandContract = contract
	contract.(*_CBusPointToMultiPointCommand)._SubType = b._CBusPointToMultiPointCommandNormal
}

func (b *_CBusPointToMultiPointCommandNormalBuilder) WithMandatoryFields(application ApplicationIdContainer, salData SALData) CBusPointToMultiPointCommandNormalBuilder {
	return b.WithApplication(application).WithSalData(salData)
}

func (b *_CBusPointToMultiPointCommandNormalBuilder) WithApplication(application ApplicationIdContainer) CBusPointToMultiPointCommandNormalBuilder {
	b.Application = application
	return b
}

func (b *_CBusPointToMultiPointCommandNormalBuilder) WithSalData(salData SALData) CBusPointToMultiPointCommandNormalBuilder {
	b.SalData = salData
	return b
}

func (b *_CBusPointToMultiPointCommandNormalBuilder) WithSalDataBuilder(builderSupplier func(SALDataBuilder) SALDataBuilder) CBusPointToMultiPointCommandNormalBuilder {
	builder := builderSupplier(b.SalData.CreateSALDataBuilder())
	var err error
	b.SalData, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "SALDataBuilder failed"))
	}
	return b
}

func (b *_CBusPointToMultiPointCommandNormalBuilder) Build() (CBusPointToMultiPointCommandNormal, error) {
	if b.SalData == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'salData' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._CBusPointToMultiPointCommandNormal.deepCopy(), nil
}

func (b *_CBusPointToMultiPointCommandNormalBuilder) MustBuild() CBusPointToMultiPointCommandNormal {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CBusPointToMultiPointCommandNormalBuilder) Done() CBusPointToMultiPointCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCBusPointToMultiPointCommandBuilder().(*_CBusPointToMultiPointCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_CBusPointToMultiPointCommandNormalBuilder) buildForCBusPointToMultiPointCommand() (CBusPointToMultiPointCommand, error) {
	return b.Build()
}

func (b *_CBusPointToMultiPointCommandNormalBuilder) DeepCopy() any {
	_copy := b.CreateCBusPointToMultiPointCommandNormalBuilder().(*_CBusPointToMultiPointCommandNormalBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCBusPointToMultiPointCommandNormalBuilder creates a CBusPointToMultiPointCommandNormalBuilder
func (b *_CBusPointToMultiPointCommandNormal) CreateCBusPointToMultiPointCommandNormalBuilder() CBusPointToMultiPointCommandNormalBuilder {
	if b == nil {
		return NewCBusPointToMultiPointCommandNormalBuilder()
	}
	return &_CBusPointToMultiPointCommandNormalBuilder{_CBusPointToMultiPointCommandNormal: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CBusPointToMultiPointCommandNormal) GetParent() CBusPointToMultiPointCommandContract {
	return m.CBusPointToMultiPointCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CBusPointToMultiPointCommandNormal) GetApplication() ApplicationIdContainer {
	return m.Application
}

func (m *_CBusPointToMultiPointCommandNormal) GetSalData() SALData {
	return m.SalData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCBusPointToMultiPointCommandNormal(structType any) CBusPointToMultiPointCommandNormal {
	if casted, ok := structType.(CBusPointToMultiPointCommandNormal); ok {
		return casted
	}
	if casted, ok := structType.(*CBusPointToMultiPointCommandNormal); ok {
		return *casted
	}
	return nil
}

func (m *_CBusPointToMultiPointCommandNormal) GetTypeName() string {
	return "CBusPointToMultiPointCommandNormal"
}

func (m *_CBusPointToMultiPointCommandNormal) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CBusPointToMultiPointCommandContract.(*_CBusPointToMultiPointCommand).getLengthInBits(ctx))

	// Simple field (application)
	lengthInBits += 8

	// Reserved Field (reserved)
	lengthInBits += 8

	// Simple field (salData)
	lengthInBits += m.SalData.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_CBusPointToMultiPointCommandNormal) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CBusPointToMultiPointCommandNormal) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CBusPointToMultiPointCommand, cBusOptions CBusOptions) (__cBusPointToMultiPointCommandNormal CBusPointToMultiPointCommandNormal, err error) {
	m.CBusPointToMultiPointCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CBusPointToMultiPointCommandNormal"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CBusPointToMultiPointCommandNormal")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	application, err := ReadEnumField[ApplicationIdContainer](ctx, "application", "ApplicationIdContainer", ReadEnum(ApplicationIdContainerByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'application' field"))
	}
	m.Application = application

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadByte(readBuffer, 8), byte(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	salData, err := ReadSimpleField[SALData](ctx, "salData", ReadComplex[SALData](SALDataParseWithBufferProducer[SALData]((ApplicationId)(application.ApplicationId())), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'salData' field"))
	}
	m.SalData = salData

	if closeErr := readBuffer.CloseContext("CBusPointToMultiPointCommandNormal"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CBusPointToMultiPointCommandNormal")
	}

	return m, nil
}

func (m *_CBusPointToMultiPointCommandNormal) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CBusPointToMultiPointCommandNormal) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CBusPointToMultiPointCommandNormal"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CBusPointToMultiPointCommandNormal")
		}

		if err := WriteSimpleEnumField[ApplicationIdContainer](ctx, "application", "ApplicationIdContainer", m.GetApplication(), WriteEnum[ApplicationIdContainer, uint8](ApplicationIdContainer.GetValue, ApplicationIdContainer.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
			return errors.Wrap(err, "Error serializing 'application' field")
		}

		if err := WriteReservedField[byte](ctx, "reserved", byte(0x00), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[SALData](ctx, "salData", m.GetSalData(), WriteComplex[SALData](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'salData' field")
		}

		if popErr := writeBuffer.PopContext("CBusPointToMultiPointCommandNormal"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CBusPointToMultiPointCommandNormal")
		}
		return nil
	}
	return m.CBusPointToMultiPointCommandContract.(*_CBusPointToMultiPointCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CBusPointToMultiPointCommandNormal) IsCBusPointToMultiPointCommandNormal() {}

func (m *_CBusPointToMultiPointCommandNormal) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CBusPointToMultiPointCommandNormal) deepCopy() *_CBusPointToMultiPointCommandNormal {
	if m == nil {
		return nil
	}
	_CBusPointToMultiPointCommandNormalCopy := &_CBusPointToMultiPointCommandNormal{
		m.CBusPointToMultiPointCommandContract.(*_CBusPointToMultiPointCommand).deepCopy(),
		m.Application,
		utils.DeepCopy[SALData](m.SalData),
		m.reservedField0,
	}
	_CBusPointToMultiPointCommandNormalCopy.CBusPointToMultiPointCommandContract.(*_CBusPointToMultiPointCommand)._SubType = m
	return _CBusPointToMultiPointCommandNormalCopy
}

func (m *_CBusPointToMultiPointCommandNormal) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
